/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation.factory;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryContainerInfo;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.generation.statement.PureFlatStatementGenerator;
import org.eclipse.wb.internal.core.model.variable.FieldInitializerVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceFactoryInfo
extends JavaInfo {
    private static ComponentDescription OBJECT_DESCRIPTION;

    public InstanceFactoryInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    public static boolean isFactory(AstEditor editor, Class<?> clazz) throws Exception {
        return !FactoryDescriptionHelper.getDescriptionsMap(editor, clazz, false).isEmpty();
    }

    public static InstanceFactoryInfo createFactory(AstEditor editor, Class<?> factoryClass, CreationSupport creationSupport) throws Exception {
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription(editor, factoryClass);
        componentDescription.setModelClass(InstanceFactoryInfo.class);
        if (OBJECT_DESCRIPTION == null) {
            OBJECT_DESCRIPTION = ComponentDescriptionHelper.getDescription(editor, Object.class);
        }
        if (UiUtils.equals(componentDescription.getIcon(), OBJECT_DESCRIPTION.getIcon())) {
            Image defaultFactoryIcon = DesignerPlugin.getImage("components/factory.gif");
            componentDescription.setIcon(defaultFactoryIcon);
        }
        return (InstanceFactoryInfo)JavaInfoUtils.createJavaInfo(editor, componentDescription, creationSupport);
    }

    public static List<InstanceFactoryInfo> getFactories(JavaInfo rootJavaInfo, Class<?> factoryClass) throws Exception {
        List factories = Lists.newArrayList();
        InstanceFactoryContainerInfo container = InstanceFactoryContainerInfo.get(rootJavaInfo);
        for (InstanceFactoryInfo factory : container.getChildrenFactory()) {
            if (!factoryClass.isAssignableFrom(factory.getDescription().getComponentClass())) continue;
            factories.add(factory);
        }
        return factories;
    }

    public static InstanceFactoryInfo add(JavaInfo rootJavaInfo, Class<?> factoryClass) throws Exception {
        AstEditor editor = rootJavaInfo.getEditor();
        InstanceFactoryInfo factoryInfo = InstanceFactoryInfo.createFactory(editor, factoryClass, new ConstructorCreationSupport());
        JavaInfoUtils.add(factoryInfo, new FieldInitializerVariableSupport(factoryInfo), PureFlatStatementGenerator.INSTANCE, AssociationObjects.empty(), rootJavaInfo, null);
        rootJavaInfo.removeChild(factoryInfo);
        InstanceFactoryContainerInfo.get(rootJavaInfo).addChild(factoryInfo);
        return factoryInfo;
    }
}

