/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.nonvisual;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildTree;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.presentation.DefaultObjectPresentation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.EditorState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectorObjectInfo
extends ObjectInfo {
    public static final String COLLECTOR_ARBITRARY_KEY = "CONTAINER_OBJECT";
    private boolean m_removeOnEmpty = false;
    private boolean m_hideInTree = false;
    private final AstEditor m_editor;
    protected final String m_caption;

    public CollectorObjectInfo(AstEditor editor, String caption) throws Exception {
        this.m_editor = editor;
        this.m_caption = StringUtils.isEmpty((String)caption) ? "(container)" : caption;
        this.setBroadcastSupport(EditorState.get(this.m_editor).getBroadcast());
        this.installListeners();
    }

    protected void installListeners() {
        this.addBroadcastListener(new ObjectInfoChildTree(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                visible[0] = visible[0] & (CollectorObjectInfo.this.isHideInTree() || !CollectorObjectInfo.this.getItems().contains(object));
            }
        });
    }

    public AstEditor getEditor() {
        return this.m_editor;
    }

    public void setRemoveOnEmpty(boolean removeOnEmpty) {
        this.m_removeOnEmpty = removeOnEmpty;
    }

    public boolean isRemoveOnEmpty() {
        return this.m_removeOnEmpty;
    }

    public void setHideInTree(boolean hideInTree) {
        this.m_hideInTree = hideInTree;
    }

    public boolean isHideInTree() {
        return this.m_hideInTree;
    }

    public String getCaption() {
        return this.m_caption;
    }

    @Override
    public IObjectPresentation getPresentation() {
        return new DefaultObjectPresentation(this){

            @Override
            public String getText() throws Exception {
                return CollectorObjectInfo.this.m_caption;
            }

            @Override
            public Image getIcon() throws Exception {
                return DesignerPlugin.getImage("components/non_visual_beans_container.gif");
            }

            @Override
            public List<ObjectInfo> getChildrenTree() throws Exception {
                if (CollectorObjectInfo.this.isHideInTree()) {
                    return Lists.newLinkedList();
                }
                return CollectorObjectInfo.this.getItems();
            }

            @Override
            public boolean isVisible() throws Exception {
                return !CollectorObjectInfo.this.isHideInTree();
            }
        };
    }

    @Override
    public boolean canDelete() {
        for (ObjectInfo item : this.getItems()) {
            if (item.canDelete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void delete() throws Exception {
        ExecutionUtils.run(this, new RunnableEx(){

            public void run() throws Exception {
                List<ObjectInfo> items = CollectorObjectInfo.this.getItems();
                int i = 0;
                while (i < items.size()) {
                    ObjectInfo itemInfo = items.get(i);
                    if (!itemInfo.isDeleted()) {
                        itemInfo.delete();
                    }
                    ++i;
                }
            }
        });
    }

    public abstract List<ObjectInfo> getItems();

    public abstract void addItem(ObjectInfo var1) throws Exception;

    protected abstract void addItem(int var1, ObjectInfo var2) throws Exception;

    protected abstract void removeItem(ObjectInfo var1) throws Exception;

    public Rectangle getBounds() {
        Rectangle bounds = null;
        for (ObjectInfo objectInfo : this.getItems()) {
            if (!(objectInfo instanceof AbstractComponentInfo)) continue;
            AbstractComponentInfo componentInfo = (AbstractComponentInfo)objectInfo;
            Rectangle itemBounds = componentInfo.getBounds();
            if (bounds == null && itemBounds != null) {
                bounds = new Rectangle(itemBounds);
                continue;
            }
            if (bounds == null || itemBounds == null) continue;
            bounds.union(componentInfo.getBounds());
        }
        if (bounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return bounds;
    }

    public static CollectorObjectInfo getCollectorObjectInfo(ObjectInfo item) {
        return (CollectorObjectInfo)item.getArbitraryValue(COLLECTOR_ARBITRARY_KEY);
    }
}

