/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.collect.Maps;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.GenericTypeResolver;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTypeResolverJavaInfo
extends GenericTypeResolver {
    private final Map<String, String> m_typeArguments;

    public GenericTypeResolverJavaInfo(JavaInfo javaInfo) throws Exception {
        super(GenericTypeResolver.EMPTY);
        this.m_typeArguments = GenericTypeResolverJavaInfo.getTypeArguments(javaInfo);
    }

    private static Map<String, String> getTypeArguments(JavaInfo javaInfo) throws Exception {
        Map typeArguments;
        block4: {
            typeArguments = Maps.newHashMap();
            ASTNode node = javaInfo.getCreationSupport().getNode();
            if (!(node instanceof ClassInstanceCreation)) break block4;
            ClassInstanceCreation creation = (ClassInstanceCreation)node;
            if (creation.getType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)creation.getType();
                ITypeBinding binding = AstNodeUtils.getTypeBinding((Type)parameterizedType);
                ITypeBinding[] typeParameters_bindings = binding.getTypeDeclaration().getTypeParameters();
                ITypeBinding[] typeArguments_bindings = binding.getTypeArguments();
                int i = 0;
                while (i < typeParameters_bindings.length) {
                    ITypeBinding typeParameter = typeParameters_bindings[i];
                    ITypeBinding typeArgument = typeArguments_bindings[i];
                    String typeParameterName = typeParameter.getName();
                    String typeArgumentName = AstNodeUtils.getFullyQualifiedName(typeArgument, true);
                    typeArguments.put(typeParameterName, typeArgumentName);
                    ++i;
                }
            } else {
                Class<?> componentClass = javaInfo.getDescription().getComponentClass();
                TypeVariable<Class<?>>[] typeVariableArray = componentClass.getTypeParameters();
                int n = typeVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeVariable<Class<?>> typeParameter = typeVariableArray[n2];
                    java.lang.reflect.Type[] bounds = typeParameter.getBounds();
                    Class upperBound = (Class)bounds[0];
                    String upperBoundName = ReflectionUtils.getCanonicalName(upperBound);
                    typeArguments.put(typeParameter.getName(), upperBoundName);
                    ++n2;
                }
            }
        }
        return typeArguments;
    }

    @Override
    protected String resolveTypeVariable(TypeVariable<?> variable) {
        String variableName = variable.getName();
        return this.m_typeArguments.get(variableName);
    }
}

