/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;

public final class VariableUtils {
    private final JavaInfo m_javaInfo;

    public VariableUtils(JavaInfo javaInfo) {
        this.m_javaInfo = javaInfo;
    }

    public String getUniqueFieldName(String localName, VariableDeclaration excludedVariable) {
        return this.convertName(-1, localName, "org.eclipse.jdt.core.codeComplete.localPrefixes", "org.eclipse.jdt.core.codeComplete.localSuffixes", "org.eclipse.jdt.core.codeComplete.fieldPrefixes", "org.eclipse.jdt.core.codeComplete.fieldSuffixes", excludedVariable);
    }

    public String convertName(int position, String name, String keyPrefixes_source, String keySuffixes_source, String keyPrefixes_target, String keySuffixes_target, VariableDeclaration excludedVariable) {
        String possibleNumber;
        int index = name.lastIndexOf(95);
        if (index != -1 && StringUtils.isNumeric((String)(possibleNumber = name.substring(index + 1)))) {
            name = name.substring(0, index);
        }
        name = this.stripPrefixSuffix(name, keyPrefixes_source, keySuffixes_source);
        name = this.addPrefixSuffix(name, keyPrefixes_target, keySuffixes_target);
        return this.m_javaInfo.getEditor().getUniqueVariableName(position, name, excludedVariable);
    }

    public String addPrefixSuffix(String name, String keyPrefixes, String keySuffixes) {
        String suffix;
        String[] suffixes;
        String prefix;
        String[] prefixes = this.getVariablesPrefixSuffixOptions(keyPrefixes);
        if (prefixes.length != 0 && !name.startsWith(prefix = prefixes[0])) {
            name = String.valueOf(prefix) + name;
        }
        if ((suffixes = this.getVariablesPrefixSuffixOptions(keySuffixes)).length != 0 && !name.endsWith(suffix = suffixes[0])) {
            name = String.valueOf(name) + suffix;
        }
        return name;
    }

    public String stripPrefixSuffix(String name, String keyPrefixes, String keySuffixes) {
        String[] suffixes;
        String[] prefixes;
        Assert.isNotNull(name);
        Assert.isNotNull(keyPrefixes);
        Assert.isNotNull(keySuffixes);
        String[] stringArray = prefixes = this.getVariablesPrefixSuffixOptions(keyPrefixes);
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (name.startsWith(prefix)) {
                name = name.substring(prefix.length());
                break;
            }
            ++n2;
        }
        stringArray = suffixes = this.getVariablesPrefixSuffixOptions(keySuffixes);
        n = suffixes.length;
        n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (name.endsWith(suffix)) {
                name = name.substring(0, name.length() - suffix.length());
                break;
            }
            ++n2;
        }
        return name;
    }

    private String[] getVariablesPrefixSuffixOptions(String key) {
        IJavaProject javaProject = this.m_javaInfo.getEditor().getJavaProject();
        Map<String, String> javaOptions = ProjectUtils.getOptions(javaProject);
        return StringUtils.split((String)javaOptions.get(key), (String)",");
    }
}

