/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.ui.AbstractSourceNewComposite;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceDescription {
    private final Class<?> m_sourceClass;
    private final Class<?> m_newCompositeClass;

    public SourceDescription(Class<?> sourceClass, Class<?> newCompositeClass) {
        this.m_sourceClass = sourceClass;
        this.m_newCompositeClass = newCompositeClass;
    }

    public Class<?> getSourceClass() {
        return this.m_sourceClass;
    }

    public Class<?> getNewCompositeClass() {
        return this.m_newCompositeClass;
    }

    public AbstractSource getSource(JavaInfo component, GenericProperty property, Expression expression, List<AbstractSource> sources) throws Exception {
        Method getSourceMethod = this.m_sourceClass.getMethod("get", JavaInfo.class, GenericProperty.class, Expression.class, List.class);
        return (AbstractSource)getSourceMethod.invoke(null, component, property, expression, sources);
    }

    public List<AbstractSource> getPossibleSources(JavaInfo root, IPackageFragment pkg) throws Exception {
        Method getPossibleSourcesMethod = this.m_sourceClass.getMethod("getPossibleSources", JavaInfo.class, IPackageFragment.class);
        return (List)getPossibleSourcesMethod.invoke(null, root, pkg);
    }

    public String getTitle() {
        return (String)ReflectionUtils.invokeMethodEx(this.m_newCompositeClass, "getTitle()", new Object[0]);
    }

    public AbstractSourceNewComposite createNewComposite(Composite parent, JavaInfo root) throws Exception {
        Constructor<?> constructor = this.m_newCompositeClass.getConstructor(Composite.class, Integer.TYPE, JavaInfo.class);
        return (AbstractSourceNewComposite)((Object)constructor.newInstance(parent, 0, root));
    }

    public AbstractSource createNewSource(IEditableSource editableSource, JavaInfo root, Object parameters) throws Exception {
        Method createMethod = this.m_sourceClass.getMethod("apply_create", IEditableSource.class, JavaInfo.class, Object.class);
        return (AbstractSource)createMethod.invoke(null, editableSource, root, parameters);
    }
}

