/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.edit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.MultiKeyMap;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.SourceDescription;
import org.eclipse.wb.internal.core.nls.commands.AbstractCommand;
import org.eclipse.wb.internal.core.nls.commands.CreateSourceCommand;
import org.eclipse.wb.internal.core.nls.commands.ICommandQueue;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSourceListener;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupportListener;
import org.eclipse.wb.internal.core.nls.edit.StringPropertyInfo;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.INlsPropertyContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditableSupport
implements IEditableSupport,
ICommandQueue {
    private final JavaInfo m_root;
    private final List<IEditableSource> m_newEditableSources = Lists.newArrayList();
    private final Map<AbstractSource, IEditableSource> m_sourceToEditable = Maps.newHashMap();
    private final Map<IEditableSource, AbstractSource> m_editableToSource = Maps.newHashMap();
    private final MultiKeyMap m_externalizedProperties = new MultiKeyMap();
    private final Map<JavaInfo, List<StringPropertyInfo>> m_componentToPropertyList = Maps.newHashMap();
    private final Map<AbstractSource, IEditableSource> m_possibleSourceToEditableSource = Maps.newHashMap();
    private final Map<IEditableSource, AbstractSource> m_possibleEditableSourceToSource = Maps.newHashMap();
    private final List<IEditableSupportListener> m_listeners = Lists.newArrayList();
    private final List<AbstractCommand> m_commands = Lists.newArrayList();

    public EditableSupport(NlsSupport support) throws Exception {
        this.m_root = support.getRoot();
        AbstractSource[] sources = support.getSources();
        int i = 0;
        while (i < sources.length) {
            AbstractSource source = sources[i];
            IEditableSource editableSource = source.getEditable();
            this.hookEditableSource(editableSource);
            this.addEditableToSourceMapping(editableSource, source);
            ++i;
        }
        this.initializeProperties(support, support.getRoot());
        this.initializePossibleSources();
    }

    private void addEditableSourceListener(final IEditableSource editableSource) {
        editableSource.addListener(new IEditableSourceListener(){

            public void keyAdded(String key, Object o) {
                StringPropertyInfo propertyInfo = (StringPropertyInfo)o;
                EditableSupport.this.m_externalizedProperties.put((Object)editableSource, (Object)key, (Object)propertyInfo);
                EditableSupport.this.fire_externalizedPropertiesChanged();
            }

            public void keyRemoved(String key) {
                EditableSupport.this.m_externalizedProperties.remove((Object)editableSource, (Object)key);
                EditableSupport.this.fire_externalizedPropertiesChanged();
            }

            public void keyRenamed(String oldKey, String newKey) {
                Object propertyInfo = EditableSupport.this.m_externalizedProperties.remove((Object)editableSource, (Object)oldKey);
                if (propertyInfo != null) {
                    EditableSupport.this.m_externalizedProperties.put((Object)editableSource, (Object)newKey, propertyInfo);
                }
            }
        });
    }

    private void initializeProperties(NlsSupport support, JavaInfo component) throws Exception {
        List componentProperties = Lists.newArrayList();
        this.m_componentToPropertyList.put(component, componentProperties);
        List properties = Lists.newArrayList((Object[])component.getProperties());
        for (Property property : ImmutableList.copyOf((Collection)properties)) {
            PropertyEditor editor = property.getEditor();
            if (!(editor instanceof INlsPropertyContributor)) continue;
            ((INlsPropertyContributor)((Object)editor)).contributeNlsProperties(property, properties);
        }
        for (Property property : properties) {
            if (!NlsSupport.isStringProperty(property) || !property.isModified()) continue;
            GenericProperty stringProperty = (GenericProperty)property;
            StringPropertyInfo propertyInfo = new StringPropertyInfo(stringProperty);
            Expression expression = stringProperty.getExpression();
            if (expression == null) continue;
            if (expression instanceof StringLiteral) {
                componentProperties.add(propertyInfo);
                continue;
            }
            if (!support.isExternalized(expression)) continue;
            componentProperties.add(propertyInfo);
            AbstractSource source = NlsSupport.getSource(expression);
            IEditableSource editableSource = this.getEditableSource(source);
            String key = source.getKey(expression);
            this.m_externalizedProperties.put((Object)editableSource, (Object)key, (Object)propertyInfo);
        }
        for (JavaInfo child : this.getTreeChildren(component)) {
            this.initializeProperties(support, child);
        }
    }

    private void initializePossibleSources() throws Exception {
        IPackageFragment pkg = (IPackageFragment)this.m_root.getEditor().getModelUnit().getParent();
        SourceDescription[] sourceDescriptions = NlsSupport.getSourceDescriptions(this.m_root);
        int i = 0;
        while (i < sourceDescriptions.length) {
            SourceDescription sourceDescription = sourceDescriptions[i];
            List<AbstractSource> sources = sourceDescription.getPossibleSources(this.m_root, pkg);
            for (AbstractSource source : sources) {
                IEditableSource editableSource = source.getEditable();
                this.hookEditableSource(editableSource);
                this.m_possibleSourceToEditableSource.put(source, editableSource);
                this.m_possibleEditableSourceToSource.put(editableSource, source);
            }
            ++i;
        }
    }

    private List<IEditableSource> getPossibleEditableSources() {
        return new ArrayList<IEditableSource>((Collection)this.m_possibleEditableSourceToSource.keySet());
    }

    public AbstractSource getPossibleSource(IEditableSource editableSource) {
        return this.m_possibleEditableSourceToSource.get(editableSource);
    }

    @Override
    public void addListener(IEditableSupportListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void removeListener(IEditableSupportListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fire_sourceAdded(IEditableSource source) {
        for (IEditableSupportListener listener : this.m_listeners) {
            listener.sourceAdded(source);
        }
    }

    private void fire_externalizedPropertiesChanged() {
        for (IEditableSupportListener listener : this.m_listeners) {
            listener.externalizedPropertiesChanged();
        }
    }

    @Override
    public JavaInfo getRoot() {
        return this.m_root;
    }

    @Override
    public boolean hasExistingSources() {
        return !this.m_sourceToEditable.isEmpty();
    }

    @Override
    public List<IEditableSource> getEditableSources() {
        List editableSources = Lists.newArrayList();
        editableSources.addAll(this.m_sourceToEditable.values());
        editableSources.addAll(this.m_newEditableSources);
        if (!editableSources.isEmpty()) {
            return editableSources;
        }
        return this.getPossibleEditableSources();
    }

    @Override
    public void addSource(IEditableSource editableSource, SourceDescription sourceDescription, Object parameters) {
        CreateSourceCommand command = new CreateSourceCommand(editableSource, sourceDescription, parameters);
        this.addCommand(command);
        this.m_newEditableSources.add(editableSource);
        editableSource.setCommandQueue(this);
        this.addEditableSourceListener(editableSource);
        this.fire_sourceAdded(editableSource);
    }

    @Override
    public AbstractSource getSource(IEditableSource editableSource) {
        return this.m_editableToSource.get(editableSource);
    }

    public void addEditableToSourceMapping(IEditableSource editableSource, AbstractSource source) {
        this.m_sourceToEditable.put(source, editableSource);
        this.m_editableToSource.put(editableSource, source);
    }

    @Override
    public IEditableSource getEditableSource(AbstractSource source) {
        return this.m_sourceToEditable.get(source);
    }

    private void hookEditableSource(IEditableSource editableSource) {
        editableSource.setCommandQueue(this);
        this.addEditableSourceListener(editableSource);
    }

    @Override
    public List<JavaInfo> getComponents() {
        return new ArrayList<JavaInfo>((Collection)this.m_componentToPropertyList.keySet());
    }

    @Override
    public List<JavaInfo> getTreeChildren(JavaInfo component) throws Exception {
        List selectedTreeChildren = Lists.newArrayList();
        for (ObjectInfo child : component.getPresentation().getChildrenTree()) {
            if (!(child instanceof JavaInfo)) continue;
            selectedTreeChildren.add((JavaInfo)child);
        }
        return selectedTreeChildren;
    }

    @Override
    public List<StringPropertyInfo> getProperties(JavaInfo component) {
        List externalizableProperties = Lists.newArrayList();
        List<StringPropertyInfo> componentProperties = this.m_componentToPropertyList.get(component);
        externalizableProperties.addAll(componentProperties);
        MapIterator I = this.m_externalizedProperties.mapIterator();
        while (I.hasNext()) {
            I.next();
            StringPropertyInfo propertyInfo = (StringPropertyInfo)I.getValue();
            externalizableProperties.remove(propertyInfo);
        }
        return externalizableProperties;
    }

    @Override
    public boolean hasPropertiesInTree(JavaInfo component) throws Exception {
        if (!this.getProperties(component).isEmpty()) {
            return true;
        }
        for (JavaInfo child : this.getTreeChildren(component)) {
            if (!this.hasPropertiesInTree(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void externalizeProperty(StringPropertyInfo propertyInfo, IEditableSource editableSource, boolean copyToAllLocales) {
        editableSource.externalize(propertyInfo, copyToAllLocales);
    }

    @Override
    public void addCommand(AbstractCommand command) {
        command.addToCommandList(this.m_commands);
    }

    public List<AbstractCommand> getCommands() {
        return this.m_commands;
    }
}

