/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.state;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.PropertyEditorManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.apache.commons.collections.map.MultiKeyMap;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.BroadcastSupport;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.parser.AbstractParseFactory;
import org.eclipse.wb.internal.core.parser.JavaInfoResolver;
import org.eclipse.wb.internal.core.utils.IDisposable;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.CompositeClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.VisitedNodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorState {
    private static JavaInfo m_activeJavaInfo;
    private boolean m_disposed;
    private final AstEditor m_editor;
    private final VisitedNodes m_visitedNodes;
    private static final String KEY_EDITOR_STATE = "KEY_EDITOR_STATE";
    private BroadcastSupport m_broadcastSupport;
    private JavaInfoResolver m_javaInfoResolver;
    private ExecutionFlowDescription m_flowDescription;
    private boolean m_isExecuting;
    private boolean m_isLiveComponent;
    private ExecutionFlowUtils.VisitingContext m_tmp_visitingContext;
    private List<JavaInfo> m_tmp_Components;
    private final Set<MethodDeclaration> m_tmp_InterceptedMethods = Sets.newHashSet();
    private String m_toolkitId;
    private ClassLoader m_editorLoader;
    private final Map<String, Object> m_versions = Maps.newHashMap();
    private final List<IDescriptionVersionsProvider> m_descriptionVersionsProviders = Lists.newArrayList();
    private final MultiKeyMap m_staticSignatures = new MultiKeyMap();
    private final List<Image> m_disposableImages = Lists.newArrayList();
    private final List<IDisposable> m_disposableList = Lists.newArrayList();
    private final BadNodesCollection m_badParserNodes = new BadNodesCollection();
    private final BadNodesCollection m_badRefreshNodes = new BadNodesCollection();
    private final List<EditorWarning> m_warnings = Lists.newArrayList();

    public static JavaInfo getActiveJavaInfo() {
        return m_activeJavaInfo;
    }

    public static void setActiveJavaInfo(JavaInfo rootInfo) {
        m_activeJavaInfo = rootInfo;
    }

    public static EditorState get(AstEditor editor) {
        EditorState state = (EditorState)editor.getGlobalValue(KEY_EDITOR_STATE);
        if (state == null) {
            state = new EditorState(editor);
            editor.putGlobalValue(KEY_EDITOR_STATE, state);
        }
        return state;
    }

    private EditorState(AstEditor editor) {
        this.m_editor = editor;
        this.m_visitedNodes = new VisitedNodes();
    }

    public BroadcastSupport getBroadcast() {
        if (this.m_broadcastSupport == null) {
            this.m_broadcastSupport = new BroadcastSupport();
        }
        return this.m_broadcastSupport;
    }

    public void setBroadcastSupport(BroadcastSupport broadcastSupport) {
        this.m_broadcastSupport = broadcastSupport;
    }

    public AstEditor getEditor() {
        return this.m_editor;
    }

    public VisitedNodes getVisitedNodes() {
        return this.m_visitedNodes;
    }

    public JavaInfoResolver getJavaInfoResolver() {
        return this.m_javaInfoResolver;
    }

    public void setJavaInfoResolver(JavaInfoResolver javaInfoResolver) {
        this.m_javaInfoResolver = javaInfoResolver;
    }

    public boolean isDisposed() {
        return this.m_disposed;
    }

    public void dispose() {
        for (Image image : this.m_disposableImages) {
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
        this.m_disposableImages.clear();
        for (IDisposable disposable : this.m_disposableList) {
            disposable.dispose();
        }
        this.m_disposableList.clear();
        this.dispose_PropertyEditorManager();
        this.dispose_UIManager();
        ExecutionUtils.runIgnore(new RunnableEx(){

            public void run() throws Exception {
                AbstractParseFactory.deinitializeClassLoader(EditorState.this.m_editorLoader, EditorState.this.m_toolkitId);
            }
        });
        this.m_disposed = true;
    }

    private void dispose_UIManager() {
        ExecutionUtils.runIgnore(new RunnableEx(){

            public void run() throws Exception {
                UIDefaults defaults = UIManager.getDefaults();
                Collection values = defaults.values();
                Iterator I = values.iterator();
                while (I.hasNext()) {
                    Object value = I.next();
                    if (!(value instanceof Class) || !EditorState.this.isLoadedFrom((Class)value)) continue;
                    I.remove();
                }
            }
        });
    }

    private void dispose_PropertyEditorManager() {
        ExecutionUtils.runIgnore(new RunnableEx(){

            public void run() throws Exception {
                Map registry = (Map)ReflectionUtils.getFieldObject(PropertyEditorManager.class, "registry");
                if (registry != null) {
                    Iterator I = registry.entrySet().iterator();
                    while (I.hasNext()) {
                        Map.Entry entry = I.next();
                        Class editorClass = (Class)entry.getValue();
                        if (!EditorState.this.isLoadedFrom(editorClass)) continue;
                        I.remove();
                    }
                }
            }
        });
    }

    public boolean isLoadedFrom(Class<?> clazz) {
        return EditorState.isLoadedFrom(clazz, this.m_editorLoader);
    }

    private static boolean isLoadedFrom(Class<?> clazz, ClassLoader loader) {
        if (clazz.getClassLoader() == loader) {
            return true;
        }
        if (loader instanceof CompositeClassLoader) {
            CompositeClassLoader compositeClassLoader = (CompositeClassLoader)loader;
            for (ClassLoader classLoader : compositeClassLoader.getClassLoaders()) {
                if (!EditorState.isLoadedFrom(clazz, classLoader)) continue;
                return true;
            }
        }
        return false;
    }

    public ExecutionFlowDescription getFlowDescription() {
        return this.m_flowDescription;
    }

    public void setFlowDescription(ExecutionFlowDescription flowDescription) {
        Assert.isNotNull(flowDescription);
        this.m_flowDescription = flowDescription;
    }

    public boolean isExecuting() {
        return this.m_isExecuting;
    }

    public void setExecuting(boolean isExecuting) {
        this.m_isExecuting = isExecuting;
    }

    public boolean isLiveComponent() {
        return this.m_isLiveComponent;
    }

    public void setLiveComponent(boolean isLiveComponent) {
        this.m_isLiveComponent = isLiveComponent;
    }

    public void setTmp_visitingContext(ExecutionFlowUtils.VisitingContext tmp_visitingContext) {
        this.m_tmp_visitingContext = tmp_visitingContext;
    }

    public ExecutionFlowUtils.VisitingContext getTmp_visitingContext() {
        return this.m_tmp_visitingContext;
    }

    public void setTmp_Components(List<JavaInfo> components) {
        this.m_tmp_Components = components;
    }

    public List<JavaInfo> getTmp_Components() {
        return this.m_tmp_Components;
    }

    public Set<MethodDeclaration> getTmp_InterceptedMethods() {
        return this.m_tmp_InterceptedMethods;
    }

    public String getToolkitId() {
        return this.m_toolkitId;
    }

    public ClassLoader getEditorLoader() {
        return this.m_editorLoader;
    }

    public boolean isInitialized() {
        return this.m_editorLoader != null;
    }

    public void initialize(String toolkitId, ClassLoader loader) {
        this.m_toolkitId = toolkitId;
        Assert.isNull(this.m_editorLoader);
        Assert.isNotNull(loader);
        this.m_editorLoader = loader;
        GlobalState.setClassLoader(loader);
    }

    public Map<String, Object> getVersions() {
        return this.m_versions;
    }

    public List<IDescriptionVersionsProvider> getDescriptionVersionsProviders() {
        return this.m_descriptionVersionsProviders;
    }

    public void addVersions(Map<String, ?> versions) {
        this.m_versions.putAll(versions);
    }

    public void addDescriptionVersionsProvider(IDescriptionVersionsProvider provider) {
        Assert.isNotNull(provider);
        if (!this.m_descriptionVersionsProviders.contains(provider)) {
            this.m_descriptionVersionsProviders.add(provider);
        }
    }

    public Map<String, FactoryMethodDescription> getFactorySignatures(Class<?> factoryClass, boolean forStatic) {
        return (Map)this.m_staticSignatures.get(factoryClass, (Object)forStatic);
    }

    public void putFactorySignatures(Class<?> factoryClass, boolean forStatic, Map<String, FactoryMethodDescription> signaturesMap) {
        this.m_staticSignatures.put(factoryClass, (Object)forStatic, signaturesMap);
    }

    public void addDisposableImage(Image image) {
        if (image != null && !this.m_disposableImages.contains(image)) {
            this.m_disposableImages.add(image);
        }
    }

    public void addDisposable(IDisposable disposable) {
        if (disposable != null && !this.m_disposableList.contains(disposable)) {
            this.m_disposableList.add(disposable);
        }
    }

    public BadNodesCollection getBadParserNodes() {
        return this.m_badParserNodes;
    }

    public BadNodesCollection getBadRefreshNodes() {
        return this.m_badRefreshNodes;
    }

    public List<EditorWarning> getWarnings() {
        return this.m_warnings;
    }

    public void addWarning(EditorWarning warning) {
        this.m_warnings.add(warning);
    }

    public static final class BadNodeInformation {
        private final ASTNode m_node;
        private final Throwable m_exception;

        public BadNodeInformation(ASTNode node, Throwable exception) {
            Assert.isNotNull(node);
            this.m_node = node;
            this.m_exception = exception;
        }

        public ASTNode getNode() {
            return this.m_node;
        }

        public Throwable getException() {
            return this.m_exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BadNodesCollection {
        private final List<BadNodeInformation> m_nodes = Lists.newArrayList();

        public void clear() {
            this.m_nodes.clear();
        }

        public void add(ASTNode node, Throwable e) {
            this.m_nodes.add(new BadNodeInformation(node, e));
        }

        public boolean isEmpty() {
            return this.m_nodes.isEmpty();
        }

        public List<BadNodeInformation> nodes() {
            return this.m_nodes;
        }

        public void print() {
            for (BadNodeInformation node : this.m_nodes) {
                System.out.flush();
                System.err.flush();
                System.out.println("------------------ bad node ------------------");
                System.out.println(node.getNode());
                System.out.flush();
                System.err.flush();
                node.getException().printStackTrace();
                System.out.flush();
                System.err.flush();
            }
        }
    }
}

