/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.discovery.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.discovery.core.WBDiscoveryCorePlugin;
import org.eclipse.wb.internal.discovery.core.WBToolkit;
import org.eclipse.wb.internal.discovery.core.WBToolkitFeature;
import org.eclipse.wb.internal.discovery.ui.Messages;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class P2Provisioner {
    private List<WBToolkit> toolkits;
    private ProvisioningUI provisioningUI;
    private LoadMetadataRepositoryJob repositoryLoadingJob;

    public P2Provisioner(List<WBToolkit> toolkits) {
        this.toolkits = toolkits;
    }

    public void installToolkits(final IProgressMonitor progressMonitor) throws ProvisionException, OperationCanceledException {
        this.provisioningUI = ProvisioningUI.getDefaultUI();
        this.repositoryLoadingJob = new LoadMetadataRepositoryJob(this.provisioningUI);
        final Collection<IInstallableUnit> installableUnits = this.collectInstallableUnits(progressMonitor);
        if (installableUnits.size() > 0) {
            final InstallOperation installOperation = this.provisioningUI.getInstallOperation(installableUnits, this.getRepositories());
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        P2Provisioner.this.provisioningUI.openInstallWizard(installableUnits, installOperation, P2Provisioner.this.repositoryLoadingJob);
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            });
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    progressMonitor.done();
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.P2Provisioner_unableInstallTitle, (String)Messages.P2Provisioner_unableInstallMessage);
                }
            });
        }
    }

    public void uninstallToolkits(final IProgressMonitor progressMonitor) throws ProvisionException, OperationCanceledException {
        this.provisioningUI = ProvisioningUI.getDefaultUI();
        this.repositoryLoadingJob = new LoadMetadataRepositoryJob(this.provisioningUI);
        final Collection<IInstallableUnit> units = this.collectUninstallableUnits(progressMonitor);
        if (units.size() > 0) {
            final UninstallOperation installOperation = this.provisioningUI.getUninstallOperation(units, this.getRepositories());
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        P2Provisioner.this.provisioningUI.openUninstallWizard(units, installOperation, P2Provisioner.this.repositoryLoadingJob);
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            });
        }
    }

    private URI[] getRepositories() {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (WBToolkit toolkit : this.toolkits) {
            URI uri = toolkit.getUpdateSiteURI();
            if (uri != null) {
                uris.add(uri);
            }
            if ((uri = toolkit.getAuxiliaryUpdateSiteURI()) == null) continue;
            uris.add(uri);
        }
        return uris.toArray(new URI[uris.size()]);
    }

    private Collection<IInstallableUnit> collectInstallableUnits(IProgressMonitor progressMonitor) throws ProvisionException, OperationCanceledException {
        String statusText = Messages.P2Provisioner_statusInstalling;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)statusText, (int)(100 * this.toolkits.size()));
        ArrayList<IInstallableUnit> units = new ArrayList<IInstallableUnit>();
        for (WBToolkit toolkit : this.toolkits) {
            ProvisioningSession session = this.provisioningUI.getSession();
            URI updateSiteURI = toolkit.getUpdateSiteURI();
            if (updateSiteURI == null) continue;
            IProvisioningAgent agent = session.getProvisioningAgent();
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            URI auxiliaryUpdateUrl = toolkit.getAuxiliaryUpdateSiteURI();
            if (auxiliaryUpdateUrl != null) {
                manager.addRepository(auxiliaryUpdateUrl);
                artifactManager.addRepository(auxiliaryUpdateUrl);
                manager.loadRepository(auxiliaryUpdateUrl, (IProgressMonitor)monitor.newChild(25));
            }
            manager.addRepository(updateSiteURI);
            artifactManager.addRepository(updateSiteURI);
            IMetadataRepository metadataRepo = manager.loadRepository(updateSiteURI, (IProgressMonitor)monitor.newChild(25));
            for (WBToolkitFeature feature : toolkit.getFeatures()) {
                String featureId = String.valueOf(feature.getFeatureId()) + ".feature.group";
                Collection featureResults = metadataRepo.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)featureId)), (IProgressMonitor)monitor.newChild(50)).toUnmodifiableSet();
                units.addAll(featureResults);
            }
        }
        return units;
    }

    private Collection<IInstallableUnit> collectUninstallableUnits(IProgressMonitor progressMonitor) {
        ArrayList<IInstallableUnit> units = new ArrayList<IInstallableUnit>();
        IProfile profile = this.getCurrentProfile();
        if (profile != null) {
            for (WBToolkit toolkit : this.toolkits) {
                for (WBToolkitFeature feature : toolkit.getFeatures()) {
                    IQueryResult results = profile.available(QueryUtil.createIUQuery((String)(String.valueOf(feature.getFeatureId()) + ".feature.group")), (IProgressMonitor)new NullProgressMonitor());
                    units.addAll(results.toSet());
                }
            }
        }
        return units;
    }

    private IProfile getCurrentProfile() {
        ServiceReference sr = WBDiscoveryCorePlugin.getBundleContext().getServiceReference(IProvisioningAgentProvider.SERVICE_NAME);
        if (sr == null) {
            return null;
        }
        IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)WBDiscoveryCorePlugin.getBundleContext().getService(sr);
        try {
            IProvisioningAgent agent = agentProvider.createAgent(null);
            IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
            return profileRegistry.getProfile("_SELF_");
        }
        catch (ProvisionException provisionException) {
            return null;
        }
    }
}

