/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassConfiguration;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentObject;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.BeanBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.xwt.Messages;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.beans.BeansObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.xwt.ui.contentproviders.ConverterUiContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterInfo {
    private boolean m_element;
    private boolean m_staticResurce;
    private String m_resourceReference;
    private String m_className;
    private String m_namespace;
    private boolean m_update;

    public void parse(DatabindingsProvider provider, DocumentElement element) throws Exception {
        if (element != null) {
            List children = element.getChildren();
            if (children.size() == 1) {
                this.parseClass(provider, element.getRoot(), ((DocumentElement)children.get(0)).getTag());
            } else {
                provider.addWarning(MessageFormat.format(Messages.ConverterInfo_converterNotFound, element), new Throwable());
            }
            this.m_element = true;
        }
    }

    public void parse(DatabindingsProvider provider, DocumentElement root, String attribute) throws Exception {
        boolean bl = this.m_staticResurce = attribute != null && attribute.startsWith("{StaticResource");
        if (this.m_staticResurce) {
            this.m_resourceReference = StringUtils.substringBetween((String)attribute, (String)"{StaticResource", (String)"}").trim();
            BeansObserveTypeContainer beanContainer = (BeansObserveTypeContainer)provider.getContainer(ObserveType.BEANS);
            if (beanContainer.resolve(this.m_resourceReference) == null) {
                this.m_staticResurce = false;
                this.m_resourceReference = null;
                provider.addWarning(MessageFormat.format(Messages.ConverterInfo_converterNotFound, attribute), new Throwable());
            }
        } else {
            this.parseClass(provider, root, attribute);
        }
    }

    private void parseClass(DatabindingsProvider provider, DocumentElement root, String value) throws Exception {
        this.m_namespace = StringUtils.substringBefore((String)value, (String)":");
        String packageValue = root.getAttribute("xmlns:" + this.m_namespace);
        if (packageValue == null) {
            this.m_namespace = null;
            provider.addWarning(MessageFormat.format(Messages.ConverterInfo_converterNotFound, value), new Throwable());
        } else {
            this.m_className = String.valueOf(StringUtils.substringAfter((String)packageValue, (String)"clr-namespace:")) + "." + StringUtils.substringAfter((String)value, (String)":");
            try {
                ClassLoader classLoader = provider.getXmlObjectRoot().getContext().getClassLoader();
                classLoader.loadClass(this.m_className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.m_className = null;
                this.m_namespace = null;
                provider.addWarning(MessageFormat.format(Messages.ConverterInfo_converterClassNotFound, this.m_className), new Throwable());
            }
        }
    }

    public String getValue() {
        return this.m_staticResurce ? this.m_resourceReference : this.m_className;
    }

    public void setValue(String value, boolean staticResurce) throws Exception {
        this.m_update = true;
        if (value == null) {
            if (this.m_resourceReference == null && this.m_className == null) {
                return;
            }
            this.m_staticResurce = false;
            this.m_resourceReference = null;
            this.m_className = null;
            this.m_namespace = null;
        } else {
            if (this.m_staticResurce == staticResurce && value.equals(this.getValue())) {
                return;
            }
            this.m_staticResurce = staticResurce;
            if (this.m_staticResurce) {
                this.m_resourceReference = value;
                this.m_className = null;
                this.m_namespace = null;
            } else {
                String newPackageName;
                String oldPackageName;
                if (this.m_namespace != null && !(oldPackageName = ClassUtils.getPackageName((String)this.m_className)).equals(newPackageName = ClassUtils.getPackageName((String)value))) {
                    this.m_namespace = null;
                }
                this.m_resourceReference = null;
                this.m_className = value;
            }
        }
    }

    public void appendValue(StringBuffer value) throws Exception {
        if (this.m_update && this.getValue() != null) {
            value.append(", converter=");
            if (this.m_staticResurce) {
                value.append("{StaticResource " + this.m_resourceReference + "}");
            } else {
                value.append(String.valueOf(StringUtils.defaultString((String)this.m_namespace)) + ":" + ClassUtils.getShortClassName((String)this.m_className));
            }
        }
    }

    public boolean update() throws Exception {
        return this.m_update;
    }

    public void applyChanges(AbstractDocumentObject object) throws Exception {
        if (this.m_update) {
            if (object instanceof DocumentAttribute) {
                if (this.m_className != null && this.m_namespace == null) {
                    DocumentAttribute attribute = (DocumentAttribute)object;
                    this.createNamespace(attribute.getEnclosingElement().getRoot());
                    String value = attribute.getValue();
                    int index = value.indexOf("converter=") + 10;
                    attribute.setValue(String.valueOf(value.substring(0, index)) + this.m_namespace + value.substring(index));
                }
            } else {
                DocumentElement bindingElement = (DocumentElement)object;
                DocumentElement converterElement = bindingElement.getChild("Binding.converter", true);
                if (this.getValue() == null) {
                    if (converterElement != null) {
                        converterElement.remove();
                    }
                } else {
                    if (this.m_namespace == null) {
                        this.createNamespace(bindingElement.getRoot());
                    }
                    String value = String.valueOf(this.m_namespace) + ":" + ClassUtils.getShortClassName((String)this.m_className);
                    if (converterElement == null) {
                        converterElement = new DocumentElement("Binding.converter");
                        converterElement.addChild(new DocumentElement(value));
                        bindingElement.addChild(converterElement);
                    } else {
                        List children = converterElement.getChildren();
                        if (children.size() == 1) {
                            ((DocumentElement)children.get(0)).setTag(value);
                        } else {
                            converterElement.removeChildren();
                            converterElement.addChild(new DocumentElement(value));
                        }
                    }
                }
            }
            this.m_update = false;
        }
    }

    private void createNamespace(DocumentElement rootElement) throws Exception {
        String domainNameSpace;
        Set domains = Sets.newHashSet();
        String domainName = "clr-namespace:" + ClassUtils.getPackageName((String)this.m_className);
        for (DocumentAttribute attribute : rootElement.getDocumentAttributes()) {
            if (!attribute.getName().startsWith("xmlns:") || !attribute.getValue().startsWith("clr-namespace:")) continue;
            String domainNameSpace2 = attribute.getName().substring(6);
            if (attribute.getValue().equals(domainName)) {
                this.m_namespace = domainNameSpace2;
                return;
            }
            domains.add(domainNameSpace2);
        }
        int index = 0;
        while (domains.contains(domainNameSpace = "c" + Integer.toString(index))) {
            ++index;
        }
        this.m_namespace = domainNameSpace;
        rootElement.setAttribute("xmlns:" + domainNameSpace, domainName);
    }

    public void createContentProviders(List<IUiContentProvider> providers, IPageListener listener, DatabindingsProvider provider) throws Exception {
        ChooseClassConfiguration configuration = new ChooseClassConfiguration();
        configuration.setDialogFieldLabel(Messages.ConverterInfo_providerTitle);
        configuration.setValueScope("org.eclipse.e4.xwt.IValueConverter");
        configuration.setClearValue("N/S");
        configuration.setBaseClassName("org.eclipse.e4.xwt.IValueConverter");
        configuration.setConstructorParameters(ArrayUtils.EMPTY_CLASS_ARRAY);
        configuration.setEmptyClassErrorMessage(Messages.ConverterInfo_errorMessage);
        configuration.setErrorMessagePrefix(Messages.ConverterInfo_errorMessagePrefix);
        if (!this.m_element) {
            ClassLoader classLoader = provider.getXmlObjectRoot().getContext().getClassLoader();
            Class<?> ConverterClass = classLoader.loadClass("org.eclipse.e4.xwt.IValueConverter");
            List defaultValues = Lists.newArrayList();
            BeansObserveTypeContainer beanContainer = (BeansObserveTypeContainer)provider.getContainer(ObserveType.BEANS);
            for (BeanBindableInfo bindable : beanContainer.getObservables0()) {
                if (!ConverterClass.isAssignableFrom(bindable.getObjectType())) continue;
                defaultValues.add(bindable.getReference());
            }
            if (!defaultValues.isEmpty()) {
                configuration.setDefaultValues(defaultValues.toArray(new String[defaultValues.size()]));
            }
        }
        providers.add((IUiContentProvider)new ConverterUiContentProvider(provider, configuration, this));
    }
}

