/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.ColumnsDialog;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.RowsDialog;

public final class DimensionsProperty
extends Property {
    private final boolean m_horizontal;

    public DimensionsProperty(MigLayoutInfo layout, boolean horizontal) {
        super((PropertyEditor)new Editor(layout, horizontal));
        this.setCategory(PropertyCategory.PREFERRED);
        this.m_horizontal = horizontal;
    }

    public String getTitle() {
        return this.m_horizontal ? "columnSpecs" : "rowSpecs";
    }

    public Object getValue() throws Exception {
        return UNKNOWN_VALUE;
    }

    public boolean isModified() throws Exception {
        return true;
    }

    public void setValue(Object value) throws Exception {
    }

    private static class Editor
    extends TextDialogPropertyEditor {
        private final MigLayoutInfo m_layout;
        private final boolean m_horizontal;

        public Editor(MigLayoutInfo layout, boolean horizontal) {
            this.m_layout = layout;
            this.m_horizontal = horizontal;
        }

        protected String getText(Property property) throws Exception {
            List titles = Lists.newArrayList();
            List<MigDimensionInfo> dimensions = this.m_horizontal ? this.m_layout.getColumns() : this.m_layout.getRows();
            for (MigDimensionInfo dimension : dimensions) {
                titles.add(dimension.getString(true));
            }
            return StringUtils.join(titles.iterator(), (String)"");
        }

        protected void openDialog(Property property) throws Exception {
            if (this.m_horizontal) {
                new ColumnsDialog(DesignerPlugin.getShell(), this.m_layout).open();
            } else {
                new RowsDialog(DesignerPlugin.getShell(), this.m_layout).open();
            }
        }
    }
}

