/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ui.debug;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.mwe.ui.debug.model.MWEBreakpoint;
import org.eclipse.emf.mwe.ui.debug.processing.PluginAdapter;
import org.eclipse.emf.mwe.ui.workflow.util.PluginConfigurationElementUtil;
import org.eclipse.internal.xtend.expression.ast.BooleanOperation;
import org.eclipse.internal.xtend.expression.ast.Cast;
import org.eclipse.internal.xtend.expression.ast.ChainExpression;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.ISyntaxElement;
import org.eclipse.internal.xtend.expression.ast.IfExpression;
import org.eclipse.internal.xtend.expression.ast.LetExpression;
import org.eclipse.internal.xtend.expression.ast.OperationCall;
import org.eclipse.internal.xtend.expression.ast.SwitchExpression;
import org.eclipse.internal.xtend.expression.debug.BaseSpecialTreatment;
import org.eclipse.internal.xtend.expression.debug.EvaluatedElementWrapper;
import org.eclipse.internal.xtend.expression.debug.ExpressionModelPresentation;
import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.CreateExtensionStatement;
import org.eclipse.internal.xtend.xtend.ast.ExpressionExtensionStatement;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.internal.XtendLog;
import org.eclipse.xtend.ui.XtendEditorPlugin;
import org.eclipse.xtend.ui.editor.XtendEditor;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionPluginAdapter
implements PluginAdapter {
    protected ExpressionModelPresentation pres;
    protected Set<BaseSpecialTreatment> specials = new HashSet<BaseSpecialTreatment>();
    private Image icon = null;

    public ExpressionPluginAdapter() {
        this.pres = new ExpressionModelPresentation(this.specials);
    }

    protected String getRequiredExtension() {
        return "ext";
    }

    public boolean canHandleResourceExtension(String ext) {
        return this.getRequiredExtension().equals(ext);
    }

    public boolean canHandleType(String type) {
        return "expression".equals(type);
    }

    public String getEditorId() {
        return PluginConfigurationElementUtil.getConfigAttribute((String)("org.eclipse.ui.editors/editor[class=" + XtendEditor.class.getName() + "]/id"));
    }

    public boolean isToggleBpEnabled(IResource resource, int start, int end, int line) {
        List<ISyntaxElement> candidates = this.getAllElementsForExtensionAtOffset(resource, start);
        if (candidates.isEmpty()) {
            return false;
        }
        ISyntaxElement element = this.findLastValidElementBeforeOffset(candidates, start);
        if (element == null) {
            return false;
        }
        return this.pres.getStart(element) <= start && this.pres.getStartingEndPosition(element) >= end;
    }

    public MWEBreakpoint createBreakpoint(IResource resource, int start, int end, int line) throws CoreException {
        ISyntaxElement element = this.findElementForPosition(resource, start, end);
        if (element == null) {
            return null;
        }
        return new MWEBreakpoint(resource, element.getNameString(null), element.getLine(), this.pres.getStart(element), this.pres.getStartingEndPosition(element));
    }

    public IBreakpoint checkBreakpoints(IBreakpoint[] bps, IResource resource, int start, int end, int line) throws CoreException {
        ISyntaxElement element = this.findElementForPosition(resource, start, end);
        if (element == null) {
            return null;
        }
        IBreakpoint[] iBreakpointArray = bps;
        int n = bps.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp1 = iBreakpointArray[n2];
            MWEBreakpoint bp = (MWEBreakpoint)bp1;
            if (bp.getResource().equals(resource.getFullPath().toString()) && bp.getLine() == element.getLine()) {
                return bp;
            }
            ++n2;
        }
        return null;
    }

    private ISyntaxElement findElementForPosition(IResource resource, int start, int end) {
        List<ISyntaxElement> candidates = this.getAllElementsForExtensionAtOffset(resource, start);
        ISyntaxElement element = null;
        element = end == start ? this.findLastValidElementBeforeOffset(candidates, start) : this.findFirstValidElementInLine(candidates, start, end);
        if (element == null) {
            element = this.findLastValidElementBeforeOffset(candidates, start);
        }
        return element;
    }

    private List<ISyntaxElement> getAllElementsForExtensionAtOffset(IResource resource, int offset) {
        IXtendXpandProject project = Activator.getExtXptModelManager().findProject(resource.getProject().getFullPath());
        if (project != null) {
            IXtendXpandResource[] iXtendXpandResourceArray = project.getAllRegisteredResources();
            int n = iXtendXpandResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IXtendXpandResource res = iXtendXpandResourceArray[n2];
                if (res.getUnderlyingStorage().equals(resource)) {
                    List<ISyntaxElement> candidates = this.collectFirstLevelElements(res);
                    if (candidates.isEmpty()) {
                        return Collections.emptyList();
                    }
                    ISyntaxElement topElement = candidates.get(0);
                    for (ISyntaxElement next : candidates) {
                        int start = next.getStart();
                        if (start == 0) {
                            System.out.println("Start is 0 for " + next.getClass().getSimpleName());
                            List<ISyntaxElement> bodyElements = this.getBody(next);
                            if (!bodyElements.isEmpty()) {
                                start = this.pres.getStart(bodyElements.get(0));
                            }
                        }
                        if (start > offset) break;
                        topElement = next;
                    }
                    return this.getAllContainingElements(topElement);
                }
                ++n2;
            }
        } else {
            XtendLog.logInfo((String)("Couldn't create ExtXpt Project for project " + resource.getProject().getName()));
        }
        return Collections.emptyList();
    }

    private List<ISyntaxElement> getAllContainingElements(ISyntaxElement parent) {
        ArrayList<ISyntaxElement> result = new ArrayList<ISyntaxElement>();
        if (parent instanceof EvaluatedElementWrapper) {
            result.add(((EvaluatedElementWrapper)parent).getElement());
        } else {
            List<ISyntaxElement> bodyElements = this.getBody(parent);
            for (ISyntaxElement element : bodyElements) {
                result.addAll(this.getAllContainingElements(element));
            }
        }
        return result;
    }

    private ISyntaxElement findLastValidElementBeforeOffset(List<ISyntaxElement> candidates, int offset) {
        ISyntaxElement previousValid = null;
        ISyntaxElement candidate = null;
        for (ISyntaxElement next : candidates) {
            if (this.isValidReturnElement(next)) {
                previousValid = next;
            }
            if (this.pres.getStart(next) > offset && this.isValidReturnElement(candidate)) {
                return candidate;
            }
            candidate = next;
        }
        if (this.isValidReturnElement(candidate)) {
            return candidate;
        }
        return previousValid;
    }

    private ISyntaxElement findFirstValidElementInLine(List<ISyntaxElement> candidates, int start, int end) {
        for (ISyntaxElement next : candidates) {
            if (this.pres.getStart(next) > start && this.isValidReturnElement(next)) {
                return next;
            }
            if (this.pres.getStart(next) > end) break;
        }
        return null;
    }

    protected List<ISyntaxElement> collectFirstLevelElements(IXtendXpandResource res) {
        ArrayList exts = new ArrayList();
        exts.addAll(((ExtensionFile)res.getExtXptResource()).getExtensions());
        exts.addAll(((ExtensionFile)res.getExtXptResource()).getArounds());
        ArrayList<ISyntaxElement> expressions = new ArrayList<ISyntaxElement>();
        for (ISyntaxElement ext : exts) {
            if (ext instanceof ExpressionExtensionStatement) {
                expressions.add(ext);
                continue;
            }
            if (ext instanceof CreateExtensionStatement) {
                expressions.add(ext);
                continue;
            }
            if (!(ext instanceof Around)) continue;
            expressions.add(ext);
        }
        return expressions;
    }

    protected List<ISyntaxElement> getBody(ISyntaxElement exp) {
        IfExpression op;
        ISyntaxElement[] body = new ISyntaxElement[]{};
        if (exp instanceof IfExpression) {
            op = (IfExpression)exp;
            body = new ISyntaxElement[]{op.getCondition(), op.getThenPart(), op.getElsePart()};
        } else if (exp instanceof OperationCall) {
            op = (OperationCall)exp;
            ArrayList<Object> kids = new ArrayList<Object>();
            kids.add(op.getTarget());
            kids.add(new EvaluatedElementWrapper((ISyntaxElement)op));
            kids.addAll(op.getParamsAsList());
            body = kids.toArray(new ISyntaxElement[0]);
        } else if (exp instanceof FeatureCall) {
            body = new ISyntaxElement[]{((FeatureCall)exp).getTarget(), new EvaluatedElementWrapper(exp)};
        } else if (exp instanceof ExpressionExtensionStatement) {
            body = new ISyntaxElement[]{((ExpressionExtensionStatement)exp).getExpression()};
        } else if (exp instanceof CreateExtensionStatement) {
            body = new ISyntaxElement[]{((CreateExtensionStatement)exp).getExpression()};
        } else if (exp instanceof Around) {
            body = new ISyntaxElement[]{((Around)exp).getExpression()};
        } else if (exp instanceof BooleanOperation) {
            op = (BooleanOperation)exp;
            body = new ISyntaxElement[]{op.getLeft(), op.getRight()};
        } else if (exp instanceof SwitchExpression) {
            op = (SwitchExpression)exp;
            body = new ISyntaxElement[]{op.getSwitchExpr(), op.getDefaultExpr()};
        } else if (exp instanceof ChainExpression) {
            op = (ChainExpression)exp;
            body = new ISyntaxElement[]{op.getFirst(), op.getNext()};
        } else if (exp instanceof LetExpression) {
            op = (LetExpression)exp;
            body = new ISyntaxElement[]{op.getVarExpression(), op.getTargetExpression()};
        } else if (exp instanceof Cast) {
            op = (Cast)exp;
            body = new ISyntaxElement[]{op.getTarget()};
        }
        ArrayList<ISyntaxElement> result = new ArrayList<ISyntaxElement>();
        ISyntaxElement[] iSyntaxElementArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            ISyntaxElement element = iSyntaxElementArray[n2];
            if (element != null) {
                result.add(element);
            }
            ++n2;
        }
        return result;
    }

    protected boolean isValidReturnElement(ISyntaxElement se) {
        return se instanceof Expression;
    }

    public Image getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        Path path = new Path("/icons/extensionfile.gif");
        InputStream is = null;
        try {
            is = FileLocator.openStream((Bundle)XtendEditorPlugin.getDefault().getBundle(), (IPath)path, (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (is != null) {
            ImageData iData = new ImageData(is);
            this.icon = new Image((Device)Display.getCurrent(), iData);
            return this.icon;
        }
        return null;
    }
}

