/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeNotFoundException;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.IJdtTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.JdtBasedTypeFactory;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeMirror;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.util.Strings;

public class JdtTypeProvider
extends AbstractJvmTypeProvider
implements IJdtTypeProvider {
    private final IJavaProject javaProject;
    private final TypeURIHelper typeUriHelper;
    private final JdtBasedTypeFactory typeFactory;

    public JdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet) {
        super(resourceSet);
        if (javaProject == null) {
            throw new IllegalArgumentException("javaProject may not be null");
        }
        this.javaProject = javaProject;
        this.typeUriHelper = this.createTypeURIHelper();
        this.typeFactory = this.createTypeFactory();
    }

    protected JdtBasedTypeFactory createTypeFactory() {
        return new JdtBasedTypeFactory(this.typeUriHelper);
    }

    protected TypeURIHelper createTypeURIHelper() {
        return new TypeURIHelper();
    }

    public JvmType findTypeByName(String name) throws TypeNotFoundException {
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("null");
        }
        String signature = null;
        try {
            signature = name.startsWith("[") ? name : Signature.createTypeSignature((String)name, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            throw new TypeNotFoundException(name);
        }
        URI resourceURI = this.typeUriHelper.createResourceURI(signature);
        String resourcePath = resourceURI.path();
        if (resourcePath.startsWith("/Primitives")) {
            TypeResource resource = (TypeResource)this.getResourceSet().getResource(resourceURI, true);
            JvmType result = this.findTypeBySignature(signature, resource);
            return result;
        }
        TypeResource resource = (TypeResource)this.getResourceSet().getResource(resourceURI, false);
        if (resource != null) {
            JvmType result = this.findTypeBySignature(signature, resource);
            return result;
        }
        String topLevelType = resourceURI.segment(resourceURI.segmentCount() - 1);
        try {
            int lastDot = topLevelType.lastIndexOf(46);
            String packageName = null;
            String typeName = topLevelType;
            if (lastDot != -1) {
                typeName = typeName.substring(lastDot + 1);
                packageName = topLevelType.substring(0, lastDot);
            }
            if (this.javaProject.findType(packageName, typeName) != null) {
                resource = (TypeResource)this.getResourceSet().getResource(resourceURI, true);
                JvmType result = this.findTypeBySignature(signature, resource);
                return result;
            }
            throw new TypeNotFoundException(name);
        }
        catch (JavaModelException e) {
            throw new TypeNotFoundException(name);
        }
    }

    public JvmType findTypeBySignature(String signature, TypeResource resource) throws TypeNotFoundException {
        String fragment = this.typeUriHelper.getFragment(signature);
        JvmType result = (JvmType)resource.getEObject(fragment);
        if (result == null) {
            throw new TypeNotFoundException("Type: '" + signature + "' is not available.");
        }
        return result;
    }

    protected IMirror createMirrorForFQN(String name) throws TypeNotFoundException {
        try {
            IType type = this.javaProject.findType(name);
            if (type == null || !type.exists()) {
                throw new TypeNotFoundException("No such type available '" + name + "'");
            }
            return new JdtTypeMirror(type, this.typeFactory);
        }
        catch (JavaModelException e) {
            throw new TypeNotFoundException(name, (Throwable)e);
        }
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public TypeURIHelper getTypeUriHelper() {
        return this.typeUriHelper;
    }

    public JdtBasedTypeFactory getJdtBasedTypeFactory() {
        return this.typeFactory;
    }
}

