/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class FeatureOverridesService {
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private TypeArgumentContextProvider contextProvider;

    @Inject
    protected FeatureOverridesService() {
    }

    public FeatureOverridesService(SuperTypeCollector superTypeCollector, TypeArgumentContextProvider contextProvider) {
        this.superTypeCollector = superTypeCollector;
        this.contextProvider = contextProvider;
    }

    public Iterable<JvmFeature> getAllJvmFeatures(JvmTypeReference type) {
        TypeArgumentContext context = this.contextProvider.getReceiverContext(type);
        JvmType rawType = type.getType();
        if (rawType == null || rawType.eIsProxy() || !(rawType instanceof JvmDeclaredType)) {
            return Collections.emptyList();
        }
        return this.getAllJvmFeatures((JvmDeclaredType)rawType, context);
    }

    public Iterable<JvmFeature> getAllJvmFeatures(JvmDeclaredType type, TypeArgumentContext ctx) {
        LinkedHashMultimap featureIndex = LinkedHashMultimap.create();
        this.indexFeatures(type, (Multimap<Triple<EClass, String, Integer>, JvmFeature>)featureIndex);
        Set<JvmTypeReference> types = this.superTypeCollector.collectSuperTypes(type);
        for (JvmTypeReference jvmTypeReference : types) {
            JvmType jvmType = jvmTypeReference.getType();
            if (!(jvmType instanceof JvmDeclaredType)) continue;
            this.indexFeatures((JvmDeclaredType)jvmType, (Multimap<Triple<EClass, String, Integer>, JvmFeature>)featureIndex);
        }
        return this.removeOverridden((Multimap<Triple<EClass, String, Integer>, JvmFeature>)featureIndex, ctx);
    }

    protected void indexFeatures(JvmDeclaredType type, Multimap<Triple<EClass, String, Integer>, JvmFeature> index) {
        for (JvmMember member : type.getMembers()) {
            Triple key;
            if (member instanceof JvmExecutable) {
                key = Tuples.create((Object)member.eClass(), (Object)member.getSimpleName(), (Object)((JvmExecutable)member).getParameters().size());
                index.put((Object)key, (Object)((JvmFeature)member));
                continue;
            }
            if (!(member instanceof JvmField)) continue;
            key = Tuples.create((Object)member.eClass(), (Object)member.getSimpleName(), (Object)-1);
            index.put((Object)key, (Object)((JvmFeature)member));
        }
    }

    protected Iterable<JvmFeature> removeOverridden(Multimap<Triple<EClass, String, Integer>, JvmFeature> featureIndex, TypeArgumentContext ctx) {
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)featureIndex.values());
        for (Collection featuresWithSameName : featureIndex.asMap().values()) {
            if (featuresWithSameName.size() <= 1) continue;
            for (JvmFeature op1 : featuresWithSameName) {
                for (JvmFeature op2 : featuresWithSameName) {
                    if (!result.contains(op1) || op1.getDeclaringType() == op2.getDeclaringType() || !this.internalIsOverridden(op1, op2, ctx, true)) continue;
                    result.remove(op2);
                }
            }
        }
        return result;
    }

    protected boolean internalIsOverridden(JvmFeature overriding, JvmFeature overridden, TypeArgumentContext context, boolean isCheckInheritance) {
        if (overriding == overridden) {
            return false;
        }
        if (!this.isNameEqual(overriding, overridden)) {
            return false;
        }
        if (overriding instanceof JvmOperation && overridden instanceof JvmOperation) {
            JvmOperation overridingOp = (JvmOperation)overriding;
            JvmOperation overriddenOp = (JvmOperation)overridden;
            if (!this.isSameNumberOfArguments(overridingOp, overriddenOp)) {
                return false;
            }
            if (!this.isSameArgumentTypes(overridingOp, overriddenOp, context)) {
                return false;
            }
        }
        if (overriding instanceof JvmField && overridden instanceof JvmField) {
            JvmField overridingField = (JvmField)overriding;
            JvmField overriddenField = (JvmField)overridden;
            if (overridingField.isStatic() != overriddenField.isStatic()) {
                return false;
            }
        }
        return true;
    }

    public boolean isOverridden(JvmFeature overriding, JvmFeature overridden, TypeArgumentContext context, boolean isCheckInheritance) {
        if (overriding == overridden) {
            return false;
        }
        if (overridden.getClass() != overriding.getClass()) {
            return false;
        }
        if (!this.isNameEqual(overriding, overridden)) {
            return false;
        }
        if (isCheckInheritance && !this.isInheritanceRelation(overriding, overridden)) {
            return false;
        }
        return this.internalIsOverridden(overriding, overridden, context, isCheckInheritance);
    }

    protected boolean isNameEqual(JvmFeature overriding, JvmFeature overridden) {
        return overriding.getSimpleName().equals(overridden.getSimpleName());
    }

    protected boolean isSameNumberOfArguments(JvmOperation overriding, JvmOperation overridden) {
        return overriding.getParameters().size() == overridden.getParameters().size();
    }

    protected boolean isSameArgumentTypes(JvmOperation overriding, JvmOperation overridden, TypeArgumentContext context) {
        int i = 0;
        while (i < overriding.getParameters().size()) {
            JvmTypeReference overriddenType;
            JvmFormalParameter overridingParam = (JvmFormalParameter)overriding.getParameters().get(i);
            JvmFormalParameter overriddenParam = (JvmFormalParameter)overridden.getParameters().get(i);
            JvmTypeReference overridingType = context.getLowerBound(overridingParam.getParameterType());
            if (!EcoreUtil.equals((EObject)overridingType, (EObject)(overriddenType = context.getLowerBound(overriddenParam.getParameterType())))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isInheritanceRelation(JvmMember overriding, JvmMember overridden) {
        return this.superTypeCollector.isSuperType(overriding.getDeclaringType(), overridden.getDeclaringType());
    }
}

