/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Primitives {
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;
    @Inject
    private TypeReferences typeReferences;

    public void setTypeProviderFactory(IJvmTypeProvider.Factory typeProviderFactory) {
        this.typeProviderFactory = typeProviderFactory;
    }

    public Primitive primitiveKind(JvmPrimitiveType primitiveType) {
        String name = primitiveType.getIdentifier();
        if (Boolean.TYPE.getName().equals(name)) {
            return Primitive.Boolean;
        }
        if (Integer.TYPE.getName().equals(name)) {
            return Primitive.Int;
        }
        if (Byte.TYPE.getName().equals(name)) {
            return Primitive.Byte;
        }
        if (Short.TYPE.getName().equals(name)) {
            return Primitive.Short;
        }
        if (Character.TYPE.getName().equals(name)) {
            return Primitive.Char;
        }
        if (Long.TYPE.getName().equals(name)) {
            return Primitive.Long;
        }
        if (Float.TYPE.getName().equals(name)) {
            return Primitive.Float;
        }
        if (Double.TYPE.getName().equals(name)) {
            return Primitive.Double;
        }
        if (Void.TYPE.getName().equals(name)) {
            return Primitive.Void;
        }
        throw new IllegalArgumentException("Unkown primitive " + name);
    }

    public JvmTypeReference asWrapperTypeIfPrimitive(JvmTypeReference primitive) {
        if (primitive == null || !this.isPrimitive(primitive)) {
            return primitive;
        }
        return this.typeReferences.createTypeRef(this.getWrapperType((JvmPrimitiveType)primitive.getType()), new JvmTypeReference[0]);
    }

    public JvmType getWrapperType(JvmPrimitiveType primitive) {
        switch (this.primitiveKind(primitive)) {
            case Byte: {
                return this.getType(Byte.class, (Notifier)primitive);
            }
            case Short: {
                return this.getType(Short.class, (Notifier)primitive);
            }
            case Char: {
                return this.getType(Character.class, (Notifier)primitive);
            }
            case Int: {
                return this.getType(Integer.class, (Notifier)primitive);
            }
            case Long: {
                return this.getType(Long.class, (Notifier)primitive);
            }
            case Float: {
                return this.getType(Float.class, (Notifier)primitive);
            }
            case Double: {
                return this.getType(Double.class, (Notifier)primitive);
            }
            case Boolean: {
                return this.getType(Boolean.class, (Notifier)primitive);
            }
            case Void: {
                return this.getType(Void.class, (Notifier)primitive);
            }
        }
        throw new IllegalArgumentException("Not a primitive : " + primitive);
    }

    protected JvmType getType(Class<?> class1, Notifier context) {
        ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)context);
        if (resourceSet == null) {
            throw new NullPointerException("context not contained in ResourceSet");
        }
        IJvmTypeProvider provider = this.typeProviderFactory.findOrCreateTypeProvider(resourceSet);
        return provider.findTypeByName(class1.getCanonicalName());
    }

    public boolean isPrimitive(JvmTypeReference type) {
        return type.getType() instanceof JvmPrimitiveType;
    }

    public boolean isWrapperType(JvmTypeReference type) {
        JvmTypeReference result = this.asPrimitiveIfWrapperType(type);
        return result != type;
    }

    public JvmTypeReference asPrimitiveIfWrapperType(JvmTypeReference type) {
        if (this.typeReferences.is(type, Byte.class)) {
            return this.typeReferences.getTypeForName(Byte.TYPE, type.getType(), new JvmTypeReference[0]);
        }
        if (this.typeReferences.is(type, Short.class)) {
            return this.typeReferences.getTypeForName(Short.TYPE, type.getType(), new JvmTypeReference[0]);
        }
        if (this.typeReferences.is(type, Character.class)) {
            return this.typeReferences.getTypeForName(Character.TYPE, type.getType(), new JvmTypeReference[0]);
        }
        if (this.typeReferences.is(type, Integer.class)) {
            return this.typeReferences.getTypeForName(Integer.TYPE, type.getType(), new JvmTypeReference[0]);
        }
        if (this.typeReferences.is(type, Long.class)) {
            return this.typeReferences.getTypeForName(Long.TYPE, type.getType(), new JvmTypeReference[0]);
        }
        if (this.typeReferences.is(type, Float.class)) {
            return this.typeReferences.getTypeForName(Float.TYPE, type.getType(), new JvmTypeReference[0]);
        }
        if (this.typeReferences.is(type, Double.class)) {
            return this.typeReferences.getTypeForName(Double.TYPE, type.getType(), new JvmTypeReference[0]);
        }
        if (this.typeReferences.is(type, Boolean.class)) {
            return this.typeReferences.getTypeForName(Boolean.TYPE, type.getType(), new JvmTypeReference[0]);
        }
        if (this.typeReferences.is(type, Void.class)) {
            return this.typeReferences.getTypeForName(Void.TYPE, type.getType(), new JvmTypeReference[0]);
        }
        return type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Primitive {
        Byte,
        Short,
        Char,
        Int,
        Long,
        Float,
        Double,
        Void,
        Boolean;

    }
}

