/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstraintOwner;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeArgumentContext {
    private static final Logger logger = Logger.getLogger(TypeArgumentContext.class);
    private Map<JvmTypeParameter, TypeArgumentContextProvider.ResolveInfo> context;
    private IJvmTypeProvider.Factory typeProviderFactory;
    private TypeReferences typeReferences;

    public TypeArgumentContext(Map<JvmTypeParameter, TypeArgumentContextProvider.ResolveInfo> context, IJvmTypeProvider.Factory typeProviderFactory, TypeReferences typeReferences) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (typeProviderFactory == null) {
            throw new NullPointerException("typeProviderFactory");
        }
        if (typeReferences == null) {
            throw new NullPointerException("typeReferences");
        }
        this.context = context;
        this.typeProviderFactory = typeProviderFactory;
        this.typeReferences = typeReferences;
    }

    public JvmTypeReference getBoundArgument(JvmTypeParameter param) {
        TypeArgumentContextProvider.ResolveInfo info = this.context.get(param);
        if (info == null) {
            return null;
        }
        return info.reference;
    }

    public JvmTypeReference getLowerBound(JvmTypeReference element) {
        JvmTypeReference copy = this.doGetResolvedCopy(element);
        if (copy instanceof JvmWildcardTypeReference) {
            JvmType context = null;
            for (JvmTypeConstraint constraint : ((JvmWildcardTypeReference)copy).getConstraints()) {
                if (constraint instanceof JvmLowerBound) {
                    JvmTypeReference lowerBound = constraint.getTypeReference();
                    return lowerBound;
                }
                if (constraint.getTypeReference() == null || context != null) continue;
                context = constraint.getTypeReference().getType();
            }
            if (context != null) {
                return this.typeReferences.createAnyTypeReference(context);
            }
            return null;
        }
        this.removeObjectLowerBound(copy);
        return copy;
    }

    protected void removeObjectLowerBound(JvmTypeReference copy) {
        if (copy instanceof JvmParameterizedTypeReference) {
            ListIterator argumentIter = ((JvmParameterizedTypeReference)copy).getArguments().listIterator();
            block0: while (argumentIter.hasNext()) {
                JvmTypeReference argument = (JvmTypeReference)argumentIter.next();
                if (!(argument instanceof JvmWildcardTypeReference)) continue;
                Iterator constraintIter = ((JvmWildcardTypeReference)argument).getConstraints().iterator();
                while (constraintIter.hasNext()) {
                    JvmTypeConstraint constraint = (JvmTypeConstraint)constraintIter.next();
                    if (!(constraint instanceof JvmLowerBound) || !this.typeReferences.isInstanceOf(constraint.getTypeReference(), Object.class)) continue;
                    constraintIter.remove();
                    argumentIter.set(constraint.getTypeReference());
                    continue block0;
                }
            }
        }
    }

    public JvmTypeReference getUpperBound(JvmTypeReference element, Notifier context) {
        JvmTypeReference copy = this.doGetResolvedCopy(element);
        if (copy instanceof JvmWildcardTypeReference) {
            for (JvmTypeConstraint constraint : ((JvmWildcardTypeReference)copy).getConstraints()) {
                if (!(constraint instanceof JvmUpperBound)) continue;
                return constraint.getTypeReference();
            }
            IJvmTypeProvider provider = this.typeProviderFactory.findOrCreateTypeProvider(this.getResourceSet(context));
            JvmType objectType = provider.findTypeByName(Object.class.getCanonicalName());
            return this.typeReferences.createTypeRef(objectType, new JvmTypeReference[0]);
        }
        return copy;
    }

    protected ResourceSet getResourceSet(Notifier context2) {
        if (context2 == null) {
            throw new NullPointerException("the passed context needs to be a or be contained in a ResourceSet.");
        }
        ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)context2);
        if (resourceSet != null) {
            return resourceSet;
        }
        throw new IllegalArgumentException(" a notifier must be either an EObject, a Resource or a ResourceSet");
    }

    public JvmTypeReference resolve(JvmTypeReference element) {
        JvmTypeReference copy = this.doGetResolvedCopy(element);
        return copy;
    }

    protected JvmTypeReference doGetResolvedCopy(JvmTypeReference element) {
        return this.doGetResolvedCopy(element, Sets.newHashSet(), Maps.newHashMap());
    }

    protected JvmTypeReference doGetResolvedCopy(JvmTypeReference element, final Set<JvmType> resolving, final Map<JvmType, JvmTypeReference> unresolved) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doGetResolvedCopy: " + element + " in context " + this + " resolving: " + resolving + " unresolved: " + unresolved));
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier(false, true){

            public EObject copy(EObject object) {
                EObject resolvedObject = this.resolveTypeParameters(object);
                EObject result = super.copy(resolvedObject);
                return result;
            }

            protected EObject resolveTypeParameters(EObject object) {
                JvmParameterizedTypeReference parameterizedTypeRef;
                JvmType type;
                if (object instanceof JvmParameterizedTypeReference && (type = (parameterizedTypeRef = (JvmParameterizedTypeReference)object).getType()) instanceof JvmTypeParameter && resolving.add(type)) {
                    try {
                        JvmTypeReference resolved = TypeArgumentContext.this.getBoundArgument((JvmTypeParameter)type);
                        if (resolved != null && resolved != object) {
                            JvmTypeReference resolvedCopy;
                            if (resolved.getType() == type) {
                                JvmParameterizedTypeReference jvmParameterizedTypeReference = parameterizedTypeRef;
                                return jvmParameterizedTypeReference;
                            }
                            if (resolved.getType() == null) {
                                if (object.eContainer() instanceof JvmTypeConstraint) {
                                    EObject eObject = object;
                                    return eObject;
                                }
                                if (!unresolved.containsKey(type)) {
                                    JvmTypeReference resolvedCopy2 = TypeArgumentContext.this.doGetResolvedCopy(resolved, resolving, unresolved);
                                    unresolved.put(type, resolvedCopy2);
                                    JvmTypeReference jvmTypeReference = resolvedCopy2;
                                    return jvmTypeReference;
                                }
                                JvmTypeReference resolvedCopy3 = (JvmTypeReference)unresolved.get(type);
                                EObject eObject = EcoreUtil2.clone((EObject)resolvedCopy3);
                                return eObject;
                            }
                            HashSet referencesToBeReplaced = Sets.newHashSet();
                            resolved = (JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)resolved);
                            UnmodifiableIterator iterator = Iterators.filter((Iterator)EcoreUtil2.eAll((EObject)resolved), JvmParameterizedTypeReference.class);
                            while (iterator.hasNext()) {
                                JvmParameterizedTypeReference containedReference = (JvmParameterizedTypeReference)iterator.next();
                                if (!resolving.contains(containedReference.getType())) continue;
                                referencesToBeReplaced.add(containedReference);
                            }
                            if (referencesToBeReplaced.isEmpty()) {
                                resolvedCopy = TypeArgumentContext.this.doGetResolvedCopy(resolved, resolving, unresolved);
                                EObject eObject = this.resolveTypeParameters(resolvedCopy);
                                return eObject;
                            }
                            block10: for (JvmParameterizedTypeReference replaceMe : referencesToBeReplaced) {
                                if (replaceMe.eContainer() instanceof JvmTypeConstraint) {
                                    JvmTypeConstraint containerConstraint = (JvmTypeConstraint)replaceMe.eContainer();
                                    JvmConstraintOwner constraintOwner = (JvmConstraintOwner)((Object)replaceMe.getType());
                                    for (JvmTypeConstraint constraint : constraintOwner.getConstraints()) {
                                        if (constraint.eClass() != containerConstraint.eClass()) continue;
                                        containerConstraint.setTypeReference((JvmTypeReference)EcoreUtil2.clone((EObject)constraint.getTypeReference()));
                                        continue block10;
                                    }
                                    continue;
                                }
                                JvmConstraintOwner constraintOwner = (JvmConstraintOwner)((Object)replaceMe.getType());
                                JvmWildcardTypeReference wildCard = TypeArgumentContext.this.typeReferences.wildCard();
                                for (JvmTypeConstraint constraint : constraintOwner.getConstraints()) {
                                    wildCard.getConstraints().add((Object)((JvmTypeConstraint)EcoreUtil2.clone((EObject)constraint)));
                                }
                                EcoreUtil.replace((EObject)replaceMe, (EObject)wildCard);
                            }
                            resolvedCopy = TypeArgumentContext.this.doGetResolvedCopy(resolved, resolving, unresolved);
                            EObject eObject = this.resolveTypeParameters(resolvedCopy);
                            return eObject;
                        }
                        JvmParameterizedTypeReference jvmParameterizedTypeReference = TypeArgumentContext.this.typeReferences.createTypeRef(type, new JvmTypeReference[0]);
                        return jvmParameterizedTypeReference;
                    }
                    finally {
                        resolving.remove(type);
                    }
                }
                return object;
            }
        };
        JvmTypeReference copy = (JvmTypeReference)copier.copy((EObject)element);
        copier.copyReferences();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doGetResolvedCopy: " + element + " resolved to: " + copy));
        }
        return copy;
    }

    public String toString() {
        return this.context.toString();
    }

    protected Map<JvmTypeParameter, TypeArgumentContextProvider.ResolveInfo> getContextMap() {
        return this.context;
    }
}

