/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmConstraintOwner;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeArgumentContextProvider {
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypeConformanceComputer conformanceComputer;
    @Inject
    private Primitives primitives;
    @Inject
    private SuperTypeCollector superTypeCollector;

    public void setTypeProviderFactory(IJvmTypeProvider.Factory typeProviderFactory) {
        this.typeProviderFactory = typeProviderFactory;
    }

    public void setTypeReferences(TypeReferences typeReferences) {
        this.typeReferences = typeReferences;
    }

    public void setConformanceComputer(TypeConformanceComputer conformanceComputer) {
        this.conformanceComputer = conformanceComputer;
    }

    public final TypeArgumentContext getNullContext() {
        return this.get(Collections.<JvmTypeParameter, ResolveInfo>emptyMap());
    }

    public TypeArgumentContext get(Map<JvmTypeParameter, ResolveInfo> context) {
        Map<JvmTypeParameter, ResolveInfo> resolved = this.resolveTypeParametersReferencedInTypeParameters(context, false);
        return new TypeArgumentContext(resolved, this.typeProviderFactory, this.typeReferences);
    }

    public TypeArgumentContext getReceiverContext(JvmTypeReference receiver) {
        Map<JvmTypeParameter, ResolveInfo> map = this.resolveReceiver(receiver);
        return this.get(map);
    }

    public TypeArgumentContext getReceiverContext(JvmTypeReference receiverType, JvmTypeReference featureType, JvmTypeReference expectedType) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        if (receiverType != null) {
            map.putAll((Multimap)Multimaps.forMap(this.resolveReceiver(receiverType)));
        }
        map.putAll((Multimap)Multimaps.forMap(this.resolveInferredTypeArgContext(featureType, expectedType, false)));
        Map<JvmTypeParameter, ResolveInfo> result = this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)map);
        return this.get(result);
    }

    protected Map<JvmTypeParameter, ResolveInfo> resolveInferredTypeArgContext(JvmTypeReference featureType, JvmTypeReference expectation, boolean ignoreOperationTypeParameters) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        if (expectation != null) {
            ResolveInfo info = new ResolveInfo(expectation);
            info.preferSubtypes = true;
            this.resolve(featureType, info, (Multimap<JvmTypeParameter, ResolveInfo>)map, ignoreOperationTypeParameters);
        }
        return this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)map);
    }

    public TypeArgumentContext getExplicitMethodInvocationContext(JvmTypeParameterDeclarator parameterDeclarator, JvmTypeReference receiverType, List<JvmTypeReference> typeArguments) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        if (receiverType != null) {
            map.putAll((Multimap)Multimaps.forMap(this.resolveReceiver(receiverType)));
        }
        HashMap explicitArguments = Maps.newHashMap();
        EList<JvmTypeParameter> typeParameters = parameterDeclarator.getTypeParameters();
        int max = Math.min(typeParameters.size(), typeArguments.size());
        int i = 0;
        while (i < max) {
            ResolveInfo info = new ResolveInfo(typeArguments.get(i));
            info.exactMatch = true;
            explicitArguments.put((JvmTypeParameter)typeParameters.get(i), info);
            ++i;
        }
        map.putAll((Multimap)Multimaps.forMap(this.resolveTypeParametersReferencedInTypeParameters(explicitArguments, false)));
        Map<JvmTypeParameter, ResolveInfo> result = this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)map);
        return this.get(result);
    }

    public TypeArgumentContext injectReceiverContext(TypeArgumentContext context, JvmTypeReference receiverType) {
        if (receiverType == null) {
            return context;
        }
        LinkedHashMultimap map = LinkedHashMultimap.create();
        map.putAll((Multimap)Multimaps.forMap(context.getContextMap()));
        map.putAll((Multimap)Multimaps.forMap(this.resolveReceiver(receiverType)));
        Map<JvmTypeParameter, ResolveInfo> result = this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)map);
        return this.get(result);
    }

    public TypeArgumentContext injectArgumentTypeContext(TypeArgumentContext context, JvmOperation operation, boolean ignoreEmptyVarArgs, JvmTypeReference ... actualArgumentTypes) {
        if (actualArgumentTypes.length == 0 && (!operation.isVarArgs() || ignoreEmptyVarArgs)) {
            return context;
        }
        LinkedHashMultimap map = LinkedHashMultimap.create();
        map.putAll((Multimap)Multimaps.forMap(context.getContextMap()));
        map.putAll((Multimap)Multimaps.forMap(this.resolveInferredMethodTypeArgContext((JvmFeature)operation, operation.getReturnType(), null, ignoreEmptyVarArgs, actualArgumentTypes)));
        Map<JvmTypeParameter, ResolveInfo> result = this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)map);
        return this.get(result);
    }

    public TypeArgumentContext injectArgumentTypeContext(TypeArgumentContext context, JvmConstructor operation, JvmTypeReference createdResult, boolean ignoreEmptyVarArgs, JvmTypeReference ... actualArgumentTypes) {
        if (actualArgumentTypes.length == 0 && (!operation.isVarArgs() || ignoreEmptyVarArgs)) {
            return context;
        }
        LinkedHashMultimap map = LinkedHashMultimap.create();
        map.putAll((Multimap)Multimaps.forMap(context.getContextMap()));
        map.putAll((Multimap)Multimaps.forMap(this.resolveInferredMethodTypeArgContext((JvmFeature)operation, createdResult, null, ignoreEmptyVarArgs, actualArgumentTypes)));
        Map<JvmTypeParameter, ResolveInfo> result = this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)map);
        return this.get(result);
    }

    public TypeArgumentContext injectExpectedTypeContext(TypeArgumentContext context, JvmOperation operation, JvmTypeReference expectedType) {
        if (expectedType == null) {
            return context;
        }
        LinkedHashMultimap map = LinkedHashMultimap.create();
        map.putAll((Multimap)Multimaps.forMap(context.getContextMap()));
        map.putAll((Multimap)Multimaps.forMap(this.resolveInferredMethodTypeArgContext((JvmFeature)operation, operation.getReturnType(), expectedType, null)));
        Map<JvmTypeParameter, ResolveInfo> result = this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)map);
        return this.get(result);
    }

    public TypeArgumentContext injectExpectedTypeContext(TypeArgumentContext context, JvmConstructor constructor, JvmTypeReference createdResult, JvmTypeReference expectedType) {
        if (expectedType == null) {
            return context;
        }
        LinkedHashMultimap map = LinkedHashMultimap.create();
        map.putAll((Multimap)Multimaps.forMap(context.getContextMap()));
        map.putAll((Multimap)Multimaps.forMap(this.resolveInferredMethodTypeArgContext((JvmFeature)constructor, createdResult, expectedType, null)));
        Map<JvmTypeParameter, ResolveInfo> result = this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)map);
        return this.get(result);
    }

    public TypeArgumentContext getInferredMethodInvocationContext(JvmOperation op, JvmTypeReference receiverType, JvmTypeReference expectedReturnType, JvmTypeReference ... actualArgumentTypes) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        if (receiverType != null) {
            map.putAll((Multimap)Multimaps.forMap(this.resolveReceiver(receiverType)));
        }
        if (!op.getTypeParameters().isEmpty() || map.isEmpty()) {
            map.putAll((Multimap)Multimaps.forMap(this.resolveInferredMethodTypeArgContext((JvmFeature)op, op.getReturnType(), expectedReturnType, actualArgumentTypes)));
        }
        Map<JvmTypeParameter, ResolveInfo> result = this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)map);
        return this.get(result);
    }

    protected Map<JvmTypeParameter, ResolveInfo> resolveTypeParametersReferencedInTypeParameters(Map<JvmTypeParameter, ResolveInfo> context, boolean ignoreOperationArguments) {
        LinkedHashMultimap result = LinkedHashMultimap.create((Multimap)Multimaps.forMap(context));
        for (Map.Entry<JvmTypeParameter, ResolveInfo> entry : context.entrySet()) {
            EList constraints = entry.getKey().getConstraints();
            if (constraints.isEmpty()) continue;
            this.resolve(entry.getKey(), entry.getValue(), (Multimap<JvmTypeParameter, ResolveInfo>)result, ignoreOperationArguments);
        }
        return this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)result);
    }

    protected Map<JvmTypeParameter, ResolveInfo> resolveReceiver(JvmTypeReference contextRef) {
        if (contextRef == null || contextRef.getType() instanceof JvmPrimitiveType) {
            return Collections.emptyMap();
        }
        LinkedHashMultimap context = LinkedHashMultimap.create();
        this.internalComputeContext(contextRef, (Multimap<JvmTypeParameter, ResolveInfo>)context, Sets.newHashSet((Object[])new JvmType[]{contextRef.getType()}));
        return this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)context);
    }

    public Map<JvmTypeParameter, ResolveInfo> resolveInferredMethodTypeArgContext(JvmFeature feature, JvmTypeReference returnType, JvmTypeReference expectation, JvmTypeReference ... argumentTypes) {
        return this.resolveInferredMethodTypeArgContext(feature, returnType, expectation, false, argumentTypes);
    }

    public Map<JvmTypeParameter, ResolveInfo> resolveInferredMethodTypeArgContext(JvmFeature feature, JvmTypeReference returnType, JvmTypeReference expectation, boolean ignoreEmptyVarArgs, JvmTypeReference ... argumentTypes) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        if (feature instanceof JvmExecutable) {
            JvmExecutable op = (JvmExecutable)feature;
            if (argumentTypes != null) {
                int paramCount = op.getParameters().size();
                if (op.isVarArgs()) {
                    --paramCount;
                }
                int i = 0;
                while (i < paramCount && i < argumentTypes.length) {
                    JvmTypeReference actualArgumentType = argumentTypes[i];
                    if (actualArgumentType != null) {
                        JvmTypeReference declaredParameterType = ((JvmFormalParameter)op.getParameters().get(i)).getParameterType();
                        ResolveInfo info = new ResolveInfo(actualArgumentType);
                        info.superTypeAllowed = true;
                        this.resolve(declaredParameterType, info, (Multimap<JvmTypeParameter, ResolveInfo>)map, false);
                    }
                    ++i;
                }
                if (op.isVarArgs()) {
                    JvmTypeReference parameterType = ((JvmFormalParameter)op.getParameters().get(paramCount)).getParameterType();
                    if (!(parameterType.getType() instanceof JvmArrayType)) {
                        throw new IllegalStateException("VarArg methods expect last paramter to be an array type");
                    }
                    JvmTypeReference componentType = ((JvmArrayType)parameterType.getType()).getComponentType();
                    ArrayList varArgTypes = Collections.emptyList();
                    if (paramCount <= argumentTypes.length) {
                        varArgTypes = Lists.newArrayList((Iterable)Iterables.filter(Arrays.asList(argumentTypes).subList(paramCount, argumentTypes.length), (Predicate)Predicates.notNull()));
                    }
                    if (!varArgTypes.isEmpty()) {
                        if (!this.primitives.isPrimitive(componentType)) {
                            int i2 = 0;
                            while (i2 < varArgTypes.size()) {
                                varArgTypes.set(i2, this.primitives.asWrapperTypeIfPrimitive((JvmTypeReference)varArgTypes.get(i2)));
                                ++i2;
                            }
                        }
                        JvmTypeReference commonVarArgType = this.conformanceComputer.getCommonSuperType(varArgTypes);
                        ResolveInfo info = new ResolveInfo(commonVarArgType);
                        info.superTypeAllowed = true;
                        this.resolve(componentType, info, (Multimap<JvmTypeParameter, ResolveInfo>)map, false);
                    } else if (!ignoreEmptyVarArgs) {
                        JvmTypeReference information = this.computeVarArgTypeInformation(feature, componentType.getType());
                        ResolveInfo info = new ResolveInfo(information);
                        info.superTypeAllowed = true;
                        info.preferSubtypes = true;
                        this.resolve(componentType, info, (Multimap<JvmTypeParameter, ResolveInfo>)map, false);
                    }
                }
            }
            if (expectation != null && returnType != null) {
                ResolveInfo info = new ResolveInfo(expectation);
                info.preferSubtypes = true;
                this.resolve(returnType, info, (Multimap<JvmTypeParameter, ResolveInfo>)map, true);
            }
        }
        return this.internalFindBestMatches((Multimap<JvmTypeParameter, ResolveInfo>)map);
    }

    protected JvmTypeReference computeVarArgTypeInformation(JvmFeature feature, JvmType type) {
        if (type instanceof JvmConstraintOwner) {
            ArrayList allUpperBounds = Lists.newArrayList();
            for (JvmTypeConstraint constraint : ((JvmConstraintOwner)((Object)type)).getConstraints()) {
                if (!(constraint instanceof JvmUpperBound)) continue;
                allUpperBounds.add(constraint.getTypeReference());
            }
            if (allUpperBounds.isEmpty()) {
                JvmTypeReference objectType = this.typeReferences.getTypeForName(Object.class, feature, new JvmTypeReference[0]);
                return objectType;
            }
            JvmTypeReference upperBound = this.conformanceComputer.getCommonSuperType(allUpperBounds);
            return upperBound;
        }
        if (type instanceof JvmTypeParameterDeclarator && !((JvmTypeParameterDeclarator)((Object)type)).getTypeParameters().isEmpty()) {
            ArrayList arguments = Lists.newArrayList();
            EList<JvmTypeParameter> parameters = ((JvmTypeParameterDeclarator)((Object)type)).getTypeParameters();
            for (JvmTypeParameter parameter : parameters) {
                arguments.add(this.computeVarArgTypeInformation(feature, parameter));
            }
            return this.typeReferences.createTypeRef(type, arguments.toArray(new JvmTypeReference[arguments.size()]));
        }
        JvmTypeReference objectType = this.typeReferences.getTypeForName(Object.class, feature, new JvmTypeReference[0]);
        return objectType;
    }

    protected Map<JvmTypeParameter, ResolveInfo> internalFindBestMatches(Multimap<JvmTypeParameter, ResolveInfo> map) {
        HashMap result = Maps.newHashMap();
        for (JvmTypeParameter param : map.keySet()) {
            Collection infos = map.get((Object)param);
            for (ResolveInfo info : infos) {
                if (result.containsKey(param)) {
                    ResolveInfo currentBestMatch = (ResolveInfo)result.get(param);
                    ResolveInfo better = this.getBetterMatch(currentBestMatch, info);
                    result.put(param, better);
                    continue;
                }
                result.put(param, info);
            }
        }
        return result;
    }

    protected ResolveInfo getBetterMatch(ResolveInfo current, ResolveInfo isBetter) {
        if (!this.isResolved(current.reference)) {
            if (this.isResolved(isBetter.reference)) {
                return isBetter;
            }
            return current;
        }
        if (current.reference instanceof JvmAnyTypeReference) {
            if (isBetter.reference instanceof JvmAnyTypeReference) {
                return current;
            }
            return isBetter;
        }
        if (isBetter.reference instanceof JvmAnyTypeReference) {
            return current;
        }
        if (this.isResolved(isBetter.reference) && !EcoreUtil.equals((EObject)current.reference, (EObject)isBetter.reference)) {
            if (current.exactMatch && !(current.reference instanceof JvmWildcardTypeReference)) {
                return current;
            }
            if (isBetter.exactMatch && !(isBetter.reference instanceof JvmWildcardTypeReference)) {
                return isBetter;
            }
            if (current.preferSubtypes && this.conformanceComputer.isConformant(current.reference, isBetter.reference)) {
                return isBetter;
            }
            if (isBetter.preferSubtypes && this.conformanceComputer.isConformant(isBetter.reference, current.reference) && !(current.reference instanceof JvmWildcardTypeReference)) {
                return current;
            }
            if (current.superTypeAllowed && isBetter.superTypeAllowed) {
                return current.copyIfDifferent(this.conformanceComputer.getCommonSuperType(Lists.newArrayList((Object[])new JvmTypeReference[]{current.reference, isBetter.reference})));
            }
            if (current.superTypeAllowed && this.conformanceComputer.isConformant(isBetter.reference, current.reference)) {
                return isBetter;
            }
        }
        return current;
    }

    protected boolean isResolved(JvmTypeReference type) {
        if (type.getType() instanceof JvmTypeParameter || type.getType() instanceof JvmVoid) {
            return false;
        }
        if (type instanceof JvmWildcardTypeReference) {
            JvmWildcardTypeReference wildcard = (JvmWildcardTypeReference)type;
            if (wildcard.getConstraints().isEmpty()) {
                return false;
            }
            for (JvmTypeConstraint constraint : wildcard.getConstraints()) {
                if (this.isResolved(constraint.getTypeReference())) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    protected void internalComputeContext(JvmTypeReference contextRef, Multimap<JvmTypeParameter, ResolveInfo> context, Set<JvmType> computing) {
        block13: {
            JvmType type;
            block12: {
                JvmParameterizedTypeReference typeRef;
                if (contextRef instanceof JvmMultiTypeReference) {
                    JvmMultiTypeReference multiType = (JvmMultiTypeReference)contextRef;
                    for (JvmTypeReference typeReference : multiType.getReferences()) {
                        this.internalComputeContext(typeReference, context, computing);
                    }
                    return;
                }
                if (contextRef instanceof JvmParameterizedTypeReference && (typeRef = (JvmParameterizedTypeReference)contextRef).getType() instanceof JvmTypeParameterDeclarator) {
                    EList<JvmTypeParameter> typeParameters = ((JvmTypeParameterDeclarator)((Object)typeRef.getType())).getTypeParameters();
                    EList<JvmTypeReference> typeArguments = typeRef.getArguments();
                    if (!typeArguments.isEmpty()) {
                        int i = 0;
                        while (i < typeArguments.size() && i < typeParameters.size()) {
                            JvmTypeReference argument = (JvmTypeReference)typeArguments.get(i);
                            if (argument != null) {
                                JvmTypeParameter param = (JvmTypeParameter)typeParameters.get(i);
                                if (context.containsKey((Object)argument.getType())) {
                                    context.putAll((Object)param, (Iterable)context.get((Object)((JvmTypeParameter)argument.getType())));
                                } else {
                                    ResolveInfo info = new ResolveInfo(argument);
                                    boolean bl = info.exactMatch = !(argument instanceof JvmWildcardTypeReference);
                                    if (!info.exactMatch) {
                                        info.preferSubtypes = true;
                                    }
                                    context.put((Object)param, (Object)info);
                                }
                            }
                            ++i;
                        }
                    }
                }
                if (!((type = contextRef.getType()) instanceof JvmDeclaredType)) break block12;
                JvmDeclaredType declaredType = (JvmDeclaredType)type;
                EList<JvmTypeReference> superTypes = declaredType.getSuperTypes();
                if (superTypes.isEmpty()) {
                    return;
                }
                for (JvmTypeReference superType : superTypes) {
                    if (!computing.add(superType.getType())) continue;
                    this.internalComputeContext(superType, context, computing);
                }
                break block13;
            }
            if (!(type instanceof JvmTypeParameter)) break block13;
            for (JvmTypeConstraint constraint : ((JvmTypeParameter)type).getConstraints()) {
                JvmTypeReference upperBound;
                if (!(constraint instanceof JvmUpperBound) || !computing.add((upperBound = constraint.getTypeReference()).getType())) continue;
                this.internalComputeContext(upperBound, context, computing);
            }
        }
    }

    protected void resolve(JvmTypeReference declaration, ResolveInfo information, Multimap<JvmTypeParameter, ResolveInfo> existing, boolean returnTypeContext) {
        JvmTypeReference informationUpperBound;
        JvmWildcardTypeReference wildcardInformation;
        JvmTypeParameter typeParameter = this.getReferenceTypeParameter(declaration);
        information = information != null ? information.copyIfDifferent(this.primitives.asWrapperTypeIfPrimitive(information.reference)) : new ResolveInfo(null);
        if (typeParameter != null && information.reference != null && this.isValidParameter(typeParameter, information.reference, returnTypeContext) && !this.containsEntry(existing, typeParameter, information)) {
            existing.put((Object)typeParameter, (Object)information);
            Collection resolveData = existing.get((Object)typeParameter);
            ArrayList transitiveParameters = Lists.newArrayListWithExpectedSize((int)2);
            for (ResolveInfo resolveDataItem : resolveData) {
                if (!(resolveDataItem.reference.getType() instanceof JvmTypeParameter) || resolveDataItem.reference == information.reference) continue;
                transitiveParameters.add((JvmTypeParameter)resolveDataItem.reference.getType());
            }
            for (JvmTypeParameter transitiveParameter : transitiveParameters) {
                if (this.containsEntry(existing, transitiveParameter, information)) continue;
                existing.put((Object)transitiveParameter, (Object)information);
            }
            this.resolve(typeParameter, information, existing, returnTypeContext);
        }
        if (declaration instanceof JvmParameterizedTypeReference) {
            JvmParameterizedTypeReference parameterizedDeclaration = (JvmParameterizedTypeReference)declaration;
            EList<JvmTypeReference> declArgs = parameterizedDeclaration.getArguments();
            if (information.reference instanceof JvmParameterizedTypeReference) {
                Iterable allTypes = Iterables.concat(Collections.singleton(information.reference), this.superTypeCollector.collectSuperTypes(information.reference));
                Set<JvmType> rawSuperTypes = this.superTypeCollector.collectSuperTypesAsRawTypes(information.reference);
                rawSuperTypes.add(information.reference.getType());
                for (JvmTypeReference localInformation : allTypes) {
                    JvmParameterizedTypeReference parameterizedInformation = (JvmParameterizedTypeReference)localInformation;
                    EList<JvmTypeReference> infoArgs = parameterizedInformation.getArguments();
                    int i = 0;
                    while (i < declArgs.size() && i < infoArgs.size()) {
                        JvmTypeParameter infoParam;
                        JvmTypeReference infoArg = (JvmTypeReference)infoArgs.get(i);
                        JvmTypeReference declArg = (JvmTypeReference)declArgs.get(i);
                        boolean recurse = true;
                        if (infoArg.getType() instanceof JvmTypeParameter && declArg.getType() instanceof JvmTypeParameter && rawSuperTypes.contains((infoParam = (JvmTypeParameter)infoArg.getType()).getDeclarator())) {
                            recurse = false;
                        }
                        if (recurse) {
                            ResolveInfo info = new ResolveInfo((JvmTypeReference)infoArgs.get(i));
                            info.superTypeAllowed = infoArg instanceof JvmWildcardTypeReference;
                            info.preferSubtypes = information.preferSubtypes || declArg instanceof JvmWildcardTypeReference && this.getSingleUpperBoundOrNull((JvmWildcardTypeReference)declArg) == null;
                            this.resolve(declArg, info, existing, returnTypeContext);
                        }
                        ++i;
                    }
                }
            } else if (information.reference instanceof JvmWildcardTypeReference) {
                wildcardInformation = (JvmWildcardTypeReference)information.reference;
                informationUpperBound = this.getSingleUpperBoundOrNull(wildcardInformation);
                ResolveInfo info = new ResolveInfo(informationUpperBound);
                info.exactMatch = !information.preferSubtypes;
                info.preferSubtypes = information.preferSubtypes;
                this.resolve(parameterizedDeclaration, info, existing, returnTypeContext);
            } else if (information.reference instanceof JvmGenericArrayTypeReference && declArgs.size() >= 1) {
                JvmGenericArrayTypeReference arrayInformation = (JvmGenericArrayTypeReference)information.reference;
                ResolveInfo info = new ResolveInfo(arrayInformation.getComponentType());
                info.preferSubtypes = true;
                this.resolve((JvmTypeReference)declArgs.get(0), info, existing, returnTypeContext);
            }
        } else if (declaration instanceof JvmWildcardTypeReference) {
            JvmWildcardTypeReference wildcardDeclaration = (JvmWildcardTypeReference)declaration;
            JvmTypeReference wildcardUpperBound = this.getSingleUpperBoundOrNull(wildcardDeclaration);
            if (information.reference instanceof JvmParameterizedTypeReference) {
                this.resolve(wildcardUpperBound, information, existing, returnTypeContext);
            } else if (information.reference instanceof JvmWildcardTypeReference) {
                wildcardInformation = (JvmWildcardTypeReference)information.reference;
                informationUpperBound = this.getSingleUpperBoundOrNull(wildcardInformation);
                ResolveInfo info = new ResolveInfo(informationUpperBound);
                info.preferSubtypes = true;
                this.resolve(wildcardUpperBound, info, existing, returnTypeContext);
            }
        } else if (declaration instanceof JvmGenericArrayTypeReference) {
            JvmTypeReference componentType = ((JvmGenericArrayTypeReference)declaration).getComponentType();
            if (information.reference instanceof JvmGenericArrayTypeReference) {
                ResolveInfo componentInfo = information.copyIfDifferent(((JvmGenericArrayTypeReference)information.reference).getComponentType());
                this.resolve(componentType, componentInfo, existing, returnTypeContext);
            }
        }
    }

    private JvmTypeReference getSingleUpperBoundOrNull(JvmConstraintOwner constraintOwner) {
        JvmTypeConstraint result = null;
        for (JvmTypeConstraint constraint : constraintOwner.getConstraints()) {
            if (!(constraint instanceof JvmUpperBound)) continue;
            if (result == null) {
                result = (JvmUpperBound)constraint;
                continue;
            }
            return null;
        }
        if (result != null) {
            return result.getTypeReference();
        }
        return null;
    }

    private boolean isValidParameter(JvmTypeParameter typeParameter, JvmTypeReference information, boolean ignoreOperationArguments) {
        if (!ignoreOperationArguments || !(typeParameter.getDeclarator() instanceof JvmOperation)) {
            return true;
        }
        if (information instanceof JvmParameterizedTypeReference) {
            JvmParameterizedTypeReference reference = (JvmParameterizedTypeReference)information;
            if (reference.getType() instanceof JvmTypeParameter && typeParameter.getDeclarator() == ((JvmTypeParameter)reference.getType()).getDeclarator()) {
                return false;
            }
            for (JvmTypeReference argument : reference.getArguments()) {
                if (this.isValidParameter(typeParameter, argument, ignoreOperationArguments)) continue;
                return false;
            }
        } else if (information instanceof JvmWildcardTypeReference) {
            EList<JvmTypeConstraint> constraints = ((JvmWildcardTypeReference)information).getConstraints();
            for (JvmTypeConstraint constraint : constraints) {
                if (this.isValidParameter(typeParameter, constraint.getTypeReference(), ignoreOperationArguments)) continue;
                return false;
            }
        } else if (information instanceof JvmGenericArrayTypeReference) {
            return this.isValidParameter(typeParameter, ((JvmGenericArrayTypeReference)information).getComponentType(), ignoreOperationArguments);
        }
        return true;
    }

    protected boolean containsEntry(Multimap<JvmTypeParameter, ResolveInfo> existing, JvmTypeParameter typeParameter, ResolveInfo information) {
        if (information.reference instanceof JvmWildcardTypeReference) {
            JvmWildcardTypeReference wildcard = (JvmWildcardTypeReference)information.reference;
            boolean otherConstraintSeen = false;
            boolean constraintIsTypeParam = false;
            for (JvmTypeConstraint constraint : wildcard.getConstraints()) {
                if (constraint instanceof JvmUpperBound && typeParameter == constraint.getTypeReference().getType()) {
                    constraintIsTypeParam = true;
                    continue;
                }
                otherConstraintSeen = true;
            }
            if (constraintIsTypeParam && !otherConstraintSeen) {
                return true;
            }
        }
        if (existing.containsKey((Object)typeParameter)) {
            Collection collection = existing.get((Object)typeParameter);
            for (ResolveInfo info : collection) {
                if (!EcoreUtil.equals((EObject)info.reference, (EObject)information.reference)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected JvmTypeParameter getReferenceTypeParameter(JvmTypeReference ref) {
        if (ref == null) {
            return null;
        }
        if (ref.getType() instanceof JvmTypeParameter) {
            return (JvmTypeParameter)ref.getType();
        }
        if (ref instanceof JvmWildcardTypeReference) {
            EList<JvmTypeConstraint> constraints = ((JvmWildcardTypeReference)ref).getConstraints();
            for (JvmTypeConstraint constraint : constraints) {
                if (constraint.getTypeReference() == null || !(constraint.getTypeReference().getType() instanceof JvmTypeParameter)) continue;
                return (JvmTypeParameter)constraint.getTypeReference().getType();
            }
        }
        return null;
    }

    protected void resolve(JvmTypeParameter key, ResolveInfo info, Multimap<JvmTypeParameter, ResolveInfo> existing, boolean ignoreOperationArguments) {
        for (JvmTypeConstraint constrain : key.getConstraints()) {
            JvmTypeReference reference = constrain.getTypeReference();
            this.resolve(reference, info, existing, ignoreOperationArguments);
        }
    }

    public static class ResolveInfo {
        public JvmTypeReference reference;
        protected boolean exactMatch;
        protected boolean preferSubtypes;
        protected boolean superTypeAllowed;

        public ResolveInfo(JvmTypeReference reference) {
            this.reference = reference;
        }

        protected ResolveInfo copyIfDifferent(JvmTypeReference reference) {
            if (reference == this.reference) {
                return this;
            }
            ResolveInfo result = new ResolveInfo(reference);
            result.exactMatch = this.exactMatch;
            result.preferSubtypes = this.preferSubtypes;
            result.superTypeAllowed = this.superTypeAllowed;
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.exactMatch ? 1231 : 1237);
            result = 31 * result + (this.preferSubtypes ? 1231 : 1237);
            result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
            result = 31 * result + (this.superTypeAllowed ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResolveInfo other = (ResolveInfo)obj;
            if (this.exactMatch != other.exactMatch) {
                return false;
            }
            if (this.preferSubtypes != other.preferSubtypes) {
                return false;
            }
            if (this.reference == null ? other.reference != null : !this.reference.equals(other.reference)) {
                return false;
            }
            return this.superTypeAllowed == other.superTypeAllowed;
        }

        public String toString() {
            return this.reference.toString();
        }
    }
}

