/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.PolymorphicDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConformanceComputer {
    private PolymorphicDispatcher<Boolean> isConformantDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_isConformant", (int)3, (int)5, (Object)this);
    @Inject
    protected SuperTypeCollector superTypeCollector;
    @Inject
    protected TypesFactory factory = TypesFactory.eINSTANCE;
    @Inject
    protected TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    protected Primitives primitives;
    @Inject
    protected TypeReferences typeReferences;

    public void setSuperTypeCollector(SuperTypeCollector superTypeCollector) {
        this.superTypeCollector = superTypeCollector;
    }

    public void setPrimitives(Primitives primitives) {
        this.primitives = primitives;
    }

    public void setFactory(TypesFactory factory) {
        this.factory = factory;
    }

    public void setTypeArgumentContextProvider(TypeArgumentContextProvider typeArgumentContextProvider) {
        this.typeArgumentContextProvider = typeArgumentContextProvider;
    }

    public void setTypeReferences(TypeReferences typeReferences) {
        this.typeReferences = typeReferences;
    }

    public boolean isConformant(JvmTypeReference left, JvmTypeReference right) {
        return this.isConformant(left, right, false);
    }

    public boolean isConformant(JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        if (left == null || right == null) {
            return false;
        }
        if (left == right) {
            return true;
        }
        if (this.isUnresolvedType(left) || this.isUnresolvedType(right)) {
            return false;
        }
        if (this.isAnyTypeReference(left)) {
            boolean result = this.isAnyTypeReference(right);
            return result;
        }
        if (this.isPrimitiveVoid(left)) {
            boolean result = this.isPrimitiveVoid(right);
            return result;
        }
        if (this.isAnyTypeReference(right)) {
            boolean result = !this.isPrimitiveType(left);
            return result;
        }
        if (this.isObject(left)) {
            boolean result = !this.isPrimitiveVoid(right);
            return result;
        }
        Boolean result = (Boolean)this.isConformantDispatcher.invoke(new Object[]{left, right, ignoreGenerics});
        return result;
    }

    protected boolean isPrimitiveType(JvmTypeReference reference) {
        return reference.getType() instanceof JvmPrimitiveType;
    }

    protected boolean isAnyTypeReference(JvmTypeReference reference) {
        return reference instanceof JvmAnyTypeReference;
    }

    protected boolean isUnresolvedType(JvmTypeReference reference) {
        if (reference instanceof JvmMultiTypeReference || reference instanceof JvmAnyTypeReference || reference instanceof JvmWildcardTypeReference) {
            return false;
        }
        return reference.getType() == null || reference.getType().eIsProxy();
    }

    protected boolean isPrimitiveVoid(JvmTypeReference reference) {
        return reference.getType() instanceof JvmVoid;
    }

    protected boolean isObject(JvmTypeReference reference) {
        return Object.class.getCanonicalName().equals(reference.getIdentifier());
    }

    protected Boolean _isConformant(JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        Boolean result = (Boolean)this.isConformantDispatcher.invoke(new Object[]{left.getType(), right.getType(), left, right, ignoreGenerics});
        return result;
    }

    protected Boolean _isConformant(JvmMultiTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        for (JvmTypeReference reference : left.getReferences()) {
            if (this.isConformant(reference, right, ignoreGenerics)) continue;
            return false;
        }
        return !left.getReferences().isEmpty();
    }

    protected Boolean _isConformant(JvmTypeReference left, JvmMultiTypeReference right, boolean ignoreGenerics) {
        for (JvmTypeReference reference : right.getReferences()) {
            if (!this.isConformant(left, reference, ignoreGenerics)) continue;
            return true;
        }
        return false;
    }

    protected Boolean _isConformant(JvmGenericArrayTypeReference left, JvmWildcardTypeReference right, boolean ignoreGenerics) {
        EList<JvmTypeConstraint> constraints = right.getConstraints();
        for (JvmTypeConstraint constraint : constraints) {
            if (constraint instanceof JvmUpperBound && !this.isConformant(left, constraint.getTypeReference(), ignoreGenerics)) {
                return false;
            }
            if (!(constraint instanceof JvmLowerBound) || this.isConformant(constraint.getTypeReference(), left, ignoreGenerics)) continue;
            return false;
        }
        return Boolean.TRUE;
    }

    protected Boolean _isConformant(JvmWildcardTypeReference left, JvmGenericArrayTypeReference right, boolean ignoreGenerics) {
        EList<JvmTypeConstraint> constraints = left.getConstraints();
        for (JvmTypeConstraint constraint : constraints) {
            if (constraint instanceof JvmUpperBound && !this.isConformant(constraint.getTypeReference(), right, ignoreGenerics)) {
                return false;
            }
            if (!(constraint instanceof JvmLowerBound) || this.isConformant(right, constraint.getTypeReference(), ignoreGenerics)) continue;
            return false;
        }
        return Boolean.TRUE;
    }

    protected Boolean _isConformant(JvmWildcardTypeReference left, JvmParameterizedTypeReference right, boolean ignoreGenerics) {
        for (JvmTypeConstraint constraint : left.getConstraints()) {
            JvmTypeReference lowerBound;
            Boolean result;
            JvmTypeReference upperBound;
            if (!(constraint instanceof JvmUpperBound ? (upperBound = constraint.getTypeReference()) != null && (result = Boolean.valueOf(this.isConformant(upperBound, right))) == false : constraint instanceof JvmLowerBound && (result = Boolean.valueOf(this.isConformant(right, lowerBound = constraint.getTypeReference()))) == false)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean _isConformant(JvmParameterizedTypeReference left, JvmWildcardTypeReference right, boolean ignoreGenerics) {
        return Boolean.FALSE;
    }

    protected Boolean _isConformant(JvmWildcardTypeReference left, JvmWildcardTypeReference right, boolean ignoreGenerics) {
        EList<JvmTypeConstraint> leftConstraints = left.getConstraints();
        EList<JvmTypeConstraint> rightConstraints = right.getConstraints();
        return this.areConstraintsConformant((List<JvmTypeConstraint>)leftConstraints, (List<JvmTypeConstraint>)rightConstraints);
    }

    protected Boolean areConstraintsConformant(List<JvmTypeConstraint> leftConstraints, List<JvmTypeConstraint> rightConstraints) {
        if (leftConstraints.size() != rightConstraints.size()) {
            return Boolean.FALSE;
        }
        int constraintCount = leftConstraints.size();
        int i = 0;
        while (i < constraintCount) {
            JvmTypeConstraint leftConstraint = leftConstraints.get(i);
            JvmTypeConstraint rightConstraint = rightConstraints.get(i);
            if (leftConstraint.eClass() != rightConstraint.eClass()) {
                return Boolean.FALSE;
            }
            if (leftConstraint instanceof JvmUpperBound ? leftConstraint.getTypeReference() != null && !this.isConformant(leftConstraint.getTypeReference(), rightConstraint.getTypeReference()) : !this.isConformant(rightConstraint.getTypeReference(), leftConstraint.getTypeReference())) {
                return Boolean.FALSE;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    protected Boolean _isConformant(JvmPrimitiveType leftType, JvmPrimitiveType rightType, JvmParameterizedTypeReference left, JvmParameterizedTypeReference right, boolean ignoreGenerics) {
        if (leftType == rightType) {
            return true;
        }
        return this.isWideningConversion(leftType, rightType);
    }

    protected Boolean isWideningConversion(JvmPrimitiveType leftType, JvmPrimitiveType rightType) {
        Primitives.Primitive left = this.primitiveKind(leftType);
        Primitives.Primitive right = this.primitiveKind(rightType);
        switch (right) {
            case Byte: {
                if (left != Primitives.Primitive.Short && left != Primitives.Primitive.Char && left != Primitives.Primitive.Int && left != Primitives.Primitive.Long && left != Primitives.Primitive.Float && left != Primitives.Primitive.Double) {
                    return false;
                }
                return true;
            }
            case Short: {
                if (left != Primitives.Primitive.Int && left != Primitives.Primitive.Long && left != Primitives.Primitive.Float && left != Primitives.Primitive.Double) {
                    return false;
                }
                return true;
            }
            case Char: {
                if (left != Primitives.Primitive.Int && left != Primitives.Primitive.Long && left != Primitives.Primitive.Float && left != Primitives.Primitive.Double) {
                    return false;
                }
                return true;
            }
            case Int: {
                if (left != Primitives.Primitive.Long && left != Primitives.Primitive.Float && left != Primitives.Primitive.Double) {
                    return false;
                }
                return true;
            }
            case Long: {
                if (left != Primitives.Primitive.Float && left != Primitives.Primitive.Double) {
                    return false;
                }
                return true;
            }
            case Float: {
                if (left == Primitives.Primitive.Double) {
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected Primitives.Primitive primitiveKind(JvmPrimitiveType primitiveType) {
        return this.primitives.primitiveKind(primitiveType);
    }

    protected Boolean _isConformant(JvmPrimitiveType leftType, JvmType rightType, JvmParameterizedTypeReference left, JvmParameterizedTypeReference right, boolean ignoreGenerics) {
        return this.isUnBoxing(leftType, rightType);
    }

    protected Boolean _isConformant(JvmDeclaredType leftType, JvmPrimitiveType rightType, JvmParameterizedTypeReference left, JvmParameterizedTypeReference right, boolean ignoreGenerics) {
        return this.isBoxing(leftType, rightType);
    }

    protected Boolean _isConformant(JvmDeclaredType leftType, JvmDeclaredType rightType, JvmParameterizedTypeReference left, JvmParameterizedTypeReference right, boolean ignoreGenerics) {
        if (leftType == rightType || this.superTypeCollector.collectSuperTypesAsRawTypes(right).contains(leftType)) {
            if (!ignoreGenerics && !this.areArgumentsAssignableFrom(left, right)) {
                return false;
            }
            return true;
        }
        return Boolean.FALSE;
    }

    protected Boolean _isConformant(JvmDeclaredType leftType, JvmType rightType, JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        return Boolean.FALSE;
    }

    protected Boolean _isConformant(JvmDeclaredType leftType, JvmTypeParameter rightType, JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        EList constraints = rightType.getConstraints();
        for (JvmTypeConstraint constraint : constraints) {
            JvmTypeReference lowerBound;
            JvmTypeReference upperBound;
            if (!(constraint instanceof JvmUpperBound ? !this.isConformant(left, upperBound = constraint.getTypeReference(), ignoreGenerics) : constraint instanceof JvmLowerBound && !this.isConformant(lowerBound = constraint.getTypeReference(), left, ignoreGenerics))) continue;
            return false;
        }
        if (constraints.isEmpty()) {
            return this.typeReferences.is(left, Object.class);
        }
        return true;
    }

    protected Boolean _isConformant(JvmTypeParameter leftType, JvmTypeParameter rightType, JvmParameterizedTypeReference left, JvmParameterizedTypeReference right, boolean ignoreGenerics) {
        if (leftType == rightType) {
            return Boolean.TRUE;
        }
        boolean result = this.areConstraintsConformant((List<JvmTypeConstraint>)leftType.getConstraints(), (List<JvmTypeConstraint>)rightType.getConstraints());
        if (result) {
            return true;
        }
        for (JvmTypeConstraint constraint : rightType.getConstraints()) {
            if (!(constraint instanceof JvmUpperBound) || !this.isConformant(left, constraint.getTypeReference(), ignoreGenerics)) continue;
            return true;
        }
        return false;
    }

    protected Boolean _isConformant(JvmTypeParameter leftType, JvmType rightType, JvmParameterizedTypeReference left, JvmParameterizedTypeReference right, boolean ignoreGenerics) {
        EList list = leftType.getConstraints();
        for (JvmTypeConstraint jvmTypeConstraint : list) {
            JvmTypeReference typeReference;
            if (!(jvmTypeConstraint instanceof JvmUpperBound) || !this.isConformant(typeReference = jvmTypeConstraint.getTypeReference(), right, ignoreGenerics)) continue;
            return true;
        }
        return list.isEmpty();
    }

    protected Boolean _isConformant(JvmArrayType leftType, JvmArrayType rightType, JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        JvmTypeReference leftComponentType = leftType.getComponentType();
        JvmTypeReference rightComponentType = rightType.getComponentType();
        return this.isConformant(leftComponentType, rightComponentType);
    }

    protected Boolean _isConformant(JvmArrayType leftType, JvmType rightType, JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        return Boolean.FALSE;
    }

    protected Boolean _isConformant(JvmType leftType, JvmArrayType rightType, JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        return Boolean.FALSE;
    }

    protected Boolean _isConformant(JvmDeclaredType leftType, JvmArrayType rightType, JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        return Object.class.getCanonicalName().equals(leftType.getIdentifier());
    }

    protected boolean areArgumentsAssignableFrom(JvmParameterizedTypeReference left, JvmParameterizedTypeReference right) {
        if (left.getArguments().size() == 0 || right.getArguments().size() == 0) {
            return true;
        }
        if (left.getArguments().size() != right.getArguments().size()) {
            return false;
        }
        int i = 0;
        while (i < left.getArguments().size()) {
            JvmTypeReference argumentB;
            JvmTypeReference argumentA = (JvmTypeReference)left.getArguments().get(i);
            if (!this.isArgumentAssignable(argumentA, argumentB = (JvmTypeReference)right.getArguments().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isArgumentAssignable(JvmTypeReference refA, JvmTypeReference refB) {
        if (this.isUnconstrainedWildcard(refA)) {
            return true;
        }
        if (refA instanceof JvmAnyTypeReference) {
            return true;
        }
        JvmTypeReference upperA = this.getUpper(refA);
        JvmTypeReference upperB = this.getUpper(refB);
        JvmTypeReference lowerA = this.getLower(refA);
        JvmTypeReference lowerB = this.getLower(refB);
        if (upperA != null) {
            if (upperB != null) {
                return this.isConformant(upperA, upperB);
            }
            if (!(refB instanceof JvmWildcardTypeReference)) {
                return this.isConformant(upperA, refB);
            }
        } else if (!(refA instanceof JvmWildcardTypeReference)) {
            if (!(refB instanceof JvmWildcardTypeReference)) {
                JvmType typeB;
                JvmType typeA = refA.getType();
                if (typeA == (typeB = refB.getType())) {
                    return this.isConformant(refA, refB);
                }
                if (typeA.eClass() == typeB.eClass() && typeA instanceof JvmTypeParameter ? this._isConformant((JvmTypeParameter)typeA, (JvmTypeParameter)typeB, (JvmParameterizedTypeReference)refA, (JvmParameterizedTypeReference)refB, false) != false : typeA instanceof JvmTypeParameter && this._isConformant((JvmTypeParameter)typeA, typeB, (JvmParameterizedTypeReference)refA, (JvmParameterizedTypeReference)refB, false) != false) {
                    return this.areArgumentsAssignableFrom((JvmParameterizedTypeReference)refA, (JvmParameterizedTypeReference)refB);
                }
            }
        } else if (lowerA != null) {
            if (this.isUnconstrainedWildcard(refB)) {
                return false;
            }
            if (upperB != null && !this.isConformant(upperB, lowerA)) {
                return false;
            }
            if (lowerB == null || this.isConformant(lowerB, lowerA)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isUnconstrainedWildcard(JvmTypeReference argumentA) {
        if (argumentA instanceof JvmWildcardTypeReference) {
            JvmUpperBound upper;
            JvmWildcardTypeReference wc = (JvmWildcardTypeReference)argumentA;
            if (wc.getConstraints().isEmpty()) {
                return true;
            }
            if (wc.getConstraints().size() == 1 && wc.getConstraints().get(0) instanceof JvmUpperBound && this.typeReferences.is((upper = (JvmUpperBound)wc.getConstraints().get(0)).getTypeReference(), Object.class)) {
                return true;
            }
        }
        return false;
    }

    protected JvmTypeReference getLower(JvmTypeReference argumentA) {
        if (argumentA instanceof JvmWildcardTypeReference) {
            EList<JvmTypeConstraint> list = ((JvmWildcardTypeReference)argumentA).getConstraints();
            for (JvmTypeConstraint constraint : list) {
                if (!(constraint instanceof JvmLowerBound)) continue;
                return constraint.getTypeReference();
            }
        }
        return null;
    }

    protected JvmTypeReference getUpper(JvmTypeReference argument) {
        if (argument instanceof JvmWildcardTypeReference) {
            EList<JvmTypeConstraint> list = ((JvmWildcardTypeReference)argument).getConstraints();
            for (JvmTypeConstraint constraint : list) {
                if (!(constraint instanceof JvmUpperBound)) continue;
                JvmTypeReference typeReference = constraint.getTypeReference();
                return typeReference;
            }
        }
        return null;
    }

    protected boolean isBoxing(JvmType typeA, JvmPrimitiveType typeB) {
        Primitives.Primitive primitive = this.primitiveKind(typeB);
        switch (primitive) {
            case Byte: {
                return this.is(typeA, Byte.class, Serializable.class, Comparable.class, Number.class, Object.class);
            }
            case Short: {
                return this.is(typeA, Short.class, Serializable.class, Comparable.class, Number.class, Object.class);
            }
            case Char: {
                return this.is(typeA, Character.class, Serializable.class, Comparable.class, Object.class);
            }
            case Int: {
                return this.is(typeA, Integer.class, Serializable.class, Comparable.class, Number.class, Object.class);
            }
            case Long: {
                return this.is(typeA, Long.class, Serializable.class, Comparable.class, Number.class, Object.class);
            }
            case Float: {
                return this.is(typeA, Float.class, Serializable.class, Comparable.class, Number.class, Object.class);
            }
            case Double: {
                return this.is(typeA, Double.class, Serializable.class, Comparable.class, Number.class, Object.class);
            }
            case Boolean: {
                return this.is(typeA, Boolean.class, Serializable.class, Comparable.class, Object.class);
            }
        }
        return false;
    }

    protected boolean isUnBoxing(JvmPrimitiveType typeA, JvmType typeB) {
        Primitives.Primitive primitive = this.primitiveKind(typeA);
        switch (primitive) {
            case Byte: {
                return this.is(typeB, Byte.class);
            }
            case Short: {
                return this.is(typeB, Short.class);
            }
            case Char: {
                return this.is(typeB, Character.class);
            }
            case Int: {
                return this.is(typeB, Integer.class);
            }
            case Long: {
                return this.is(typeB, Long.class);
            }
            case Float: {
                return this.is(typeB, Float.class);
            }
            case Double: {
                return this.is(typeB, Double.class);
            }
            case Boolean: {
                return this.is(typeB, Boolean.class);
            }
        }
        return false;
    }

    protected boolean is(JvmType typeA, Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            boolean result = typeA.getIdentifier().equals(clazz.getCanonicalName());
            if (result) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public JvmTypeReference getCommonSuperType(List<JvmTypeReference> types) {
        if (types == null || types.isEmpty()) {
            throw new IllegalArgumentException("Types can't be null or empty " + types);
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        for (JvmTypeReference type : types) {
            if (this.conformsToAll(type, types)) {
                return type;
            }
            if (!this.isPrimitiveVoid(type)) continue;
            return null;
        }
        if (this.containsPrimitive(types)) {
            List<JvmTypeReference> withoutPrimitives = this.replacePrimitives(types);
            return this.getCommonSuperType(withoutPrimitives);
        }
        JvmTypeReference firstType = types.get(0);
        List<JvmTypeReference> tail = types.subList(1, types.size());
        LinkedHashMultimap all = LinkedHashMultimap.create();
        LinkedHashMultiset cumulatedDistance = LinkedHashMultiset.create();
        this.initializeDistance(firstType, (Multimap<JvmType, JvmTypeReference>)all, (Multiset<JvmType>)cumulatedDistance);
        this.cumulateDistance(tail, (Multimap<JvmType, JvmTypeReference>)all, (Multiset<JvmType>)cumulatedDistance);
        ArrayList candidates = Lists.newArrayList((Iterable)cumulatedDistance.entrySet());
        if (candidates.size() == 1) {
            JvmType firstRawType = (JvmType)((Multiset.Entry)candidates.get(0)).getElement();
            return this.getFirstForRawType((Multimap<JvmType, JvmTypeReference>)all, firstRawType);
        }
        this.inplaceSortByDistanceAndName(candidates);
        ArrayList referencesWithSameDistance = Lists.newArrayListWithExpectedSize((int)2);
        int wasDistance = -1;
        for (Multiset.Entry rawTypeCandidate : candidates) {
            if (wasDistance == -1) {
                wasDistance = rawTypeCandidate.getCount();
            } else if (wasDistance != rawTypeCandidate.getCount()) break;
            JvmType rawType = (JvmType)rawTypeCandidate.getElement();
            JvmTypeReference result = this.getTypeParametersForSupertype((Multimap<JvmType, JvmTypeReference>)all, rawType, types);
            if (result == null) continue;
            referencesWithSameDistance.add(result);
        }
        if (referencesWithSameDistance.size() == 1) {
            return (JvmTypeReference)referencesWithSameDistance.get(0);
        }
        if (referencesWithSameDistance.size() > 1) {
            JvmMultiTypeReference result = this.typeReferences.createMultiTypeReference(((JvmTypeReference)referencesWithSameDistance.get(0)).getType(), new JvmTypeReference[0]);
            for (JvmTypeReference reference : referencesWithSameDistance) {
                result.getReferences().add((Object)((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)reference)));
            }
            return result;
        }
        return this.typeReferences.getTypeForName(Object.class, this.findContext(firstType), new JvmTypeReference[0]);
    }

    protected JvmType findContext(JvmTypeReference firstType) {
        if (firstType instanceof JvmGenericArrayTypeReference) {
            return this.findContext(((JvmGenericArrayTypeReference)firstType).getComponentType());
        }
        return firstType.getType();
    }

    protected List<JvmTypeReference> replacePrimitives(List<JvmTypeReference> types) {
        ArrayList result = Lists.newArrayList();
        for (JvmTypeReference type : types) {
            result.add(this.primitives.asWrapperTypeIfPrimitive(type));
        }
        return result;
    }

    protected boolean containsPrimitive(List<JvmTypeReference> types) {
        for (JvmTypeReference type : types) {
            if (!this.isPrimitiveType(type)) continue;
            return true;
        }
        return false;
    }

    protected JvmTypeReference getTypeParametersForSupertype(Multimap<JvmType, JvmTypeReference> all, JvmType rawType, List<JvmTypeReference> initiallyRequested) {
        if (rawType instanceof JvmTypeParameterDeclarator) {
            EList<JvmTypeParameter> typeParameters = ((JvmTypeParameterDeclarator)((Object)rawType)).getTypeParameters();
            if (typeParameters.isEmpty()) {
                return this.getFirstForRawType(all, rawType);
            }
            ArrayList parameterSuperTypes = Lists.newArrayList();
            int i = 0;
            while (i < typeParameters.size()) {
                ArrayList parameterReferences = Lists.newArrayList();
                for (JvmTypeReference reference : all.get((Object)rawType)) {
                    if (reference instanceof JvmParameterizedTypeReference) {
                        JvmParameterizedTypeReference parameterized = (JvmParameterizedTypeReference)reference;
                        if (parameterized.getArguments().isEmpty()) {
                            JvmParameterizedTypeReference result = this.factory.createJvmParameterizedTypeReference();
                            result.setType(rawType);
                            return result;
                        }
                        JvmTypeReference parameterReference = (JvmTypeReference)parameterized.getArguments().get(i);
                        parameterReferences.add(parameterReference);
                        continue;
                    }
                    return null;
                }
                JvmTypeReference parameterSuperType = this.getCommonParameterSuperType(parameterReferences, initiallyRequested);
                if (parameterSuperType == null) {
                    return null;
                }
                parameterSuperTypes.add(parameterSuperType);
                ++i;
            }
            JvmParameterizedTypeReference result = this.factory.createJvmParameterizedTypeReference();
            result.setType(rawType);
            for (JvmTypeReference parameterSuperType : parameterSuperTypes) {
                result.getArguments().add((Object)((JvmTypeReference)EcoreUtil.copy((EObject)parameterSuperType)));
            }
            return result;
        }
        return null;
    }

    protected JvmTypeReference getFirstForRawType(Multimap<JvmType, JvmTypeReference> all, JvmType rawType) {
        JvmTypeReference result = (JvmTypeReference)all.get((Object)rawType).iterator().next();
        return result;
    }

    protected void initializeDistance(JvmTypeReference firstType, Multimap<JvmType, JvmTypeReference> all, Multiset<JvmType> cumulatedDistance) {
        TypeArgumentContext firstContext = this.typeArgumentContextProvider.getReceiverContext(firstType);
        MaxDistanceRawTypeAcceptor acceptor = new MaxDistanceRawTypeAcceptor(cumulatedDistance, all, new ArgumentResolver(firstContext));
        acceptor.accept(firstType, 0);
        this.superTypeCollector.collectSuperTypes(firstType, acceptor);
    }

    protected void cumulateDistance(List<JvmTypeReference> references, Multimap<JvmType, JvmTypeReference> all, Multiset<JvmType> cumulatedDistance) {
        for (JvmTypeReference other : references) {
            LinkedHashMultiset otherDistance = LinkedHashMultiset.create();
            this.initializeDistance(other, all, (Multiset<JvmType>)otherDistance);
            cumulatedDistance.retainAll((Collection)otherDistance);
            for (Multiset.Entry typeToDistance : otherDistance.entrySet()) {
                if (!cumulatedDistance.contains(typeToDistance.getElement())) continue;
                cumulatedDistance.add((Object)((JvmType)typeToDistance.getElement()), typeToDistance.getCount());
            }
        }
    }

    protected void inplaceSortByDistanceAndName(List<Multiset.Entry<JvmType>> candidates) {
        Collections.sort(candidates, new Comparator<Multiset.Entry<JvmType>>(){

            @Override
            public int compare(Multiset.Entry<JvmType> o1, Multiset.Entry<JvmType> o2) {
                if (o1.getCount() == o2.getCount()) {
                    if (o1.getElement() instanceof JvmGenericType && o2.getElement() instanceof JvmGenericType) {
                        if (((JvmGenericType)o1.getElement()).isInterface()) {
                            if (!((JvmGenericType)o2.getElement()).isInterface()) {
                                return 1;
                            }
                        } else if (((JvmGenericType)o2.getElement()).isInterface()) {
                            return -1;
                        }
                    }
                    return ((JvmType)o1.getElement()).getIdentifier().compareTo(((JvmType)o2.getElement()).getIdentifier());
                }
                if (o1.getCount() < o2.getCount()) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public JvmTypeReference getCommonParameterSuperType(List<JvmTypeReference> types, List<JvmTypeReference> initiallyRequested) {
        HashSet initiallyRequestedNames;
        Function<JvmTypeReference, String> getCanonicalName = new Function<JvmTypeReference, String>(){

            public String apply(JvmTypeReference from) {
                return from.getIdentifier();
            }
        };
        HashSet allNames = Sets.newHashSet((Iterable)Iterables.transform(types, (Function)getCanonicalName));
        if (allNames.size() == 1) {
            return types.get(0);
        }
        if (types.size() == initiallyRequested.size() && (initiallyRequestedNames = Sets.newHashSet((Iterable)Iterables.transform(initiallyRequested, (Function)getCanonicalName))).equals(allNames)) {
            JvmTypeReference objectTypeReference = this.typeReferences.getTypeForName(Object.class, types.get(0).getType(), new JvmTypeReference[0]);
            return this.typeReferences.wildCardExtends(objectTypeReference);
        }
        JvmTypeReference superType = this.getCommonSuperType(types);
        if (superType instanceof JvmWildcardTypeReference) {
            return superType;
        }
        JvmWildcardTypeReference wildcardTypeReference = this.factory.createJvmWildcardTypeReference();
        JvmUpperBound upperBound = this.factory.createJvmUpperBound();
        upperBound.setTypeReference((JvmTypeReference)EcoreUtil.copy((EObject)superType));
        wildcardTypeReference.getConstraints().add((Object)upperBound);
        return wildcardTypeReference;
    }

    protected boolean conformsToAll(JvmTypeReference type, List<JvmTypeReference> types) {
        boolean conform = true;
        int i = 0;
        while (conform && i < types.size()) {
            conform = this.isConformant(type, types.get(i));
            ++i;
        }
        return conform;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ArgumentResolver
    implements Function<JvmTypeReference, JvmTypeReference> {
        private final TypeArgumentContext context;

        protected ArgumentResolver(TypeArgumentContext context) {
            this.context = context;
        }

        public JvmTypeReference apply(JvmTypeReference from) {
            JvmTypeReference result = this.context.resolve(from);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MaxDistanceRawTypeAcceptor
    implements SuperTypeCollector.SuperTypeAcceptor {
        private final Multiset<JvmType> distances;
        private final Multimap<JvmType, JvmTypeReference> rawTypeToReference;
        private final Function<JvmTypeReference, JvmTypeReference> resolver;

        protected MaxDistanceRawTypeAcceptor(Multiset<JvmType> result, Multimap<JvmType, JvmTypeReference> all, Function<JvmTypeReference, JvmTypeReference> resolver) {
            this.distances = result;
            this.rawTypeToReference = all;
            this.resolver = resolver;
        }

        @Override
        public boolean accept(JvmTypeReference superType, int distance) {
            JvmType type = superType.getType();
            this.rawTypeToReference.put((Object)type, (Object)((JvmTypeReference)this.resolver.apply((Object)superType)));
            if (this.distances.contains((Object)type)) {
                int currentCount = this.distances.count((Object)type);
                if (currentCount < distance + 1) {
                    this.distances.setCount((Object)type, distance + 1);
                }
            } else {
                this.distances.add((Object)type, distance + 1);
            }
            return true;
        }
    }
}

