/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategy;

public class PartitionDeletionEditStrategy
extends AbstractEditStrategy {
    private String left;
    private String right;

    public PartitionDeletionEditStrategy(String left, String right) {
        this.left = left;
        this.right = right;
    }

    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.text.equals("") && command.length == 1) {
            if (command.offset + this.right.length() + this.left.length() > document.getLength()) {
                return;
            }
            if (command.offset + command.length - this.left.length() < 0) {
                return;
            }
            if (command.length != this.left.length()) {
                return;
            }
            String string = document.get(command.offset, this.left.length() + this.right.length());
            if (string.equals(String.valueOf(this.left) + this.right)) {
                command.length = this.left.length() + this.right.length();
            }
        }
    }

    public static class Factory {
        @Inject
        private MembersInjector<PartitionDeletionEditStrategy> injector;

        public PartitionDeletionEditStrategy newInstance(String left, String right) {
            PartitionDeletionEditStrategy result = new PartitionDeletionEditStrategy(left, right);
            this.injector.injectMembers((Object)result);
            return result;
        }
    }
}

