/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.highlighting;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.ui.highlighting.XbaseHighlightingCalculator;
import org.eclipse.xtext.xtend2.richstring.AbstractRichStringPartAcceptor;
import org.eclipse.xtext.xtend2.richstring.DefaultIndentationHandler;
import org.eclipse.xtext.xtend2.richstring.IRichStringIndentationHandler;
import org.eclipse.xtext.xtend2.richstring.IRichStringPartAcceptor;
import org.eclipse.xtext.xtend2.richstring.RichStringProcessor;
import org.eclipse.xtext.xtend2.services.Xtend2GrammarAccess;
import org.eclipse.xtext.xtend2.xtend2.RichString;
import org.eclipse.xtext.xtend2.xtend2.RichStringLiteral;
import org.eclipse.xtext.xtend2.xtend2.Xtend2Package;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendMember;

public class RichStringAwareHighlightingCalculator
extends XbaseHighlightingCalculator {
    @Inject
    private RichStringProcessor processor;
    @Inject
    private Provider<DefaultIndentationHandler> indentationHandlerProvider;
    private Keyword createKeyword;

    @Inject
    protected void setXtendGrammarAccess(Xtend2GrammarAccess grammarAccess) {
        this.createKeyword = grammarAccess.getValidIDAccess().getCreateKeyword_1();
    }

    protected void doProvideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        XtendFile file = (XtendFile)resource.getContents().get(0);
        if (file.getXtendClass() != null) {
            for (XtendMember member : file.getXtendClass().getMembers()) {
                if (member.eClass() != Xtend2Package.Literals.XTEND_FUNCTION) continue;
                XtendFunction function = (XtendFunction)member;
                XExpression rootExpression = function.getExpression();
                this.highlightRichStrings(rootExpression, acceptor);
            }
        }
        super.doProvideHighlightingFor(resource, acceptor);
    }

    protected void highlightRichStrings(XExpression expression, IHighlightedPositionAcceptor acceptor) {
        if (expression != null) {
            TreeIterator iterator = EcoreUtil2.eAll((EObject)expression);
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (!(object instanceof RichString)) continue;
                RichStringHighlighter highlighter = this.createRichStringHighlighter(acceptor);
                this.processor.process((RichString)object, (IRichStringPartAcceptor)highlighter, (IRichStringIndentationHandler)this.indentationHandlerProvider.get());
                iterator.prune();
            }
        }
    }

    protected RichStringHighlighter createRichStringHighlighter(IHighlightedPositionAcceptor acceptor) {
        return new RichStringHighlighter(acceptor);
    }

    protected void highlightSpecialIdentifiers(ILeafNode leafNode, IHighlightedPositionAcceptor acceptor, TerminalRule idRule) {
        super.highlightSpecialIdentifiers(leafNode, acceptor, idRule);
        if (leafNode.getGrammarElement() == this.createKeyword) {
            acceptor.addPosition(leafNode.getOffset(), leafNode.getLength(), new String[]{"default"});
        }
    }

    protected class RichStringHighlighter
    extends AbstractRichStringPartAcceptor.ForLoopOnce {
        private int currentOffset = -1;
        private RichStringLiteral recent = null;
        private final IHighlightedPositionAcceptor acceptor;

        public RichStringHighlighter(IHighlightedPositionAcceptor acceptor) {
            this.acceptor = acceptor;
        }

        public void announceNextLiteral(RichStringLiteral object) {
            this.resetCurrentOffset(object);
        }

        public void acceptSemanticText(CharSequence text, RichStringLiteral origin) {
            this.resetCurrentOffset(origin);
            this.currentOffset += text.length();
        }

        protected void resetCurrentOffset(RichStringLiteral origin) {
            if (origin != null && origin != this.recent) {
                this.recent = origin;
                List featureNodes = NodeModelUtils.findNodesForFeature((EObject)origin, (EStructuralFeature)XbasePackage.Literals.XSTRING_LITERAL__VALUE);
                if (featureNodes.size() == 1) {
                    INode node = (INode)featureNodes.get(0);
                    this.currentOffset = node.getOffset();
                    if (node.getText().charAt(0) == '\'') {
                        this.acceptor.addPosition(this.currentOffset, 3, new String[]{"xtend2.insignificant.template.text"});
                        this.highlightClosingQuotes(node);
                        this.currentOffset += 3;
                    } else {
                        this.highlightClosingQuotes(node);
                        ++this.currentOffset;
                    }
                }
            }
        }

        protected void highlightClosingQuotes(INode node) {
            int length = 0;
            if (node.getText().endsWith("'''")) {
                length = 3;
            } else if (node.getText().endsWith("''")) {
                length = 2;
            } else if (node.getText().endsWith("'")) {
                length = 1;
            }
            if (length != 0) {
                this.acceptor.addPosition(this.currentOffset + node.getLength() - length, length, new String[]{"xtend2.insignificant.template.text"});
            }
        }

        public void acceptTemplateText(CharSequence text, RichStringLiteral origin) {
            this.resetCurrentOffset(origin);
            if (text.length() > 0) {
                this.acceptor.addPosition(this.currentOffset, text.length(), new String[]{"xtend2.insignificant.template.text"});
                this.currentOffset += text.length();
            }
        }

        public void acceptSemanticLineBreak(int charCount, RichStringLiteral origin, boolean controlStructureSeen) {
            this.resetCurrentOffset(origin);
            if (controlStructureSeen) {
                this.acceptor.addPosition(this.currentOffset, charCount, new String[]{"xtend2.potential.line.break"});
            } else {
                this.acceptor.addPosition(this.currentOffset, charCount, new String[]{"xtend2.template.line.break"});
            }
            this.currentOffset += charCount;
        }

        public void acceptTemplateLineBreak(int charCount, RichStringLiteral origin) {
            this.resetCurrentOffset(origin);
            this.currentOffset += charCount;
        }

        public void acceptIfCondition(XExpression condition) {
            RichStringAwareHighlightingCalculator.this.highlightRichStrings(condition, this.acceptor);
        }

        public void acceptElseIfCondition(XExpression condition) {
            RichStringAwareHighlightingCalculator.this.highlightRichStrings(condition, this.acceptor);
        }

        public void acceptForLoop(JvmFormalParameter parameter, XExpression expression) {
            RichStringAwareHighlightingCalculator.this.highlightRichStrings(expression, this.acceptor);
            super.acceptForLoop(parameter, expression);
        }

        public void acceptExpression(XExpression expression, CharSequence indentation) {
            RichStringAwareHighlightingCalculator.this.highlightRichStrings(expression, this.acceptor);
        }
    }
}

