/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelInferrer;
import org.eclipse.xtext.xtend2.dispatch.DispatchingSupport;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendField;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendMember;
import org.eclipse.xtext.xtend2.xtend2.XtendParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xtend2JvmModelInferrer
implements IJvmModelInferrer {
    @Inject
    protected TypesFactory typesFactory;
    @Inject
    private IJvmModelAssociator associator;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private DispatchingSupport dispatchingSupport;

    public List<? extends JvmDeclaredType> inferJvmModel(EObject xtendFile) {
        this.associator.disassociate(xtendFile);
        XtendFile xtendFile2 = (XtendFile)xtendFile;
        if (xtendFile2.getXtendClass() == null || xtendFile2.getXtendClass().getName() == null) {
            return Collections.emptyList();
        }
        JvmGenericType inferredJvmType = this.transform(xtendFile2.getXtendClass());
        return Collections.singletonList(inferredJvmType);
    }

    protected JvmGenericType transform(XtendClass source) {
        JvmGenericType target = this.typesFactory.createJvmGenericType();
        source.eResource().getContents().add((Object)target);
        this.associator.associatePrimary((EObject)source, (EObject)target);
        target.setPackageName(source.getPackageName());
        target.setSimpleName(source.getName());
        target.setVisibility(JvmVisibility.PUBLIC);
        this.addConstructor(source, target);
        for (JvmTypeReference superType : source.getSuperTypes()) {
            target.getSuperTypes().add((Object)((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)superType)));
        }
        for (JvmTypeParameter typeParameter : source.getTypeParameters()) {
            target.getTypeParameters().add((Object)((JvmTypeParameter)EcoreUtil2.cloneWithProxies((EObject)typeParameter)));
        }
        for (XtendMember member : source.getMembers()) {
            if ((!(member instanceof XtendField) || ((XtendField)member).getName() == null) && (!(member instanceof XtendFunction) || ((XtendFunction)member).getName() == null)) continue;
            this.transform(member, target);
        }
        this.appendSyntheticDispatchMethods(source, target);
        this.computeInferredReturnTypes(target);
        return target;
    }

    protected void appendSyntheticDispatchMethods(XtendClass source, JvmGenericType target) {
        Multimap<Pair<String, Integer>, JvmOperation> methods = this.dispatchingSupport.getDispatchMethods(target);
        for (Pair key : methods.keySet()) {
            Collection operations = methods.get((Object)key);
            JvmOperation operation = this.deriveGenericDispatchOperationSignature(this.dispatchingSupport.sort(operations), target);
            operation.setSimpleName((String)key.getFirst());
            operation.setVisibility(JvmVisibility.PUBLIC);
        }
    }

    protected JvmOperation deriveGenericDispatchOperationSignature(Collection<JvmOperation> operations, JvmGenericType target) {
        if (operations.isEmpty()) {
            return null;
        }
        Iterator<JvmOperation> iterator = operations.iterator();
        JvmOperation first = iterator.next();
        JvmOperation result = this.typesFactory.createJvmOperation();
        target.getMembers().add((Object)result);
        int i = 0;
        while (i < first.getParameters().size()) {
            JvmFormalParameter parameter = this.typesFactory.createJvmFormalParameter();
            result.getParameters().add((Object)parameter);
            parameter.setParameterType(this.getTypeProxy((EObject)parameter));
            JvmFormalParameter parameter2 = (JvmFormalParameter)first.getParameters().get(i);
            parameter.setName(parameter2.getName());
            ++i;
        }
        for (JvmOperation jvmOperation : operations) {
            Iterable xtendFunctions = Iterables.filter((Iterable)this.associations.getSourceElements((EObject)jvmOperation), XtendFunction.class);
            for (XtendFunction func : xtendFunctions) {
                this.associator.associate((EObject)func, (EObject)result);
            }
        }
        return result;
    }

    protected void addConstructor(XtendClass source, JvmGenericType target) {
        JvmConstructor constructor = this.typesFactory.createJvmConstructor();
        target.getMembers().add((Object)constructor);
        this.associator.associatePrimary((EObject)source, (EObject)constructor);
        constructor.setSimpleName(source.getName());
        constructor.setVisibility(JvmVisibility.PUBLIC);
    }

    protected JvmMember transform(XtendMember sourceMember, JvmGenericType container) {
        if (sourceMember instanceof XtendFunction) {
            XtendFunction source = (XtendFunction)sourceMember;
            JvmOperation target = this.typesFactory.createJvmOperation();
            container.getMembers().add((Object)target);
            this.associator.associatePrimary((EObject)source, (EObject)target);
            String sourceName = source.getName();
            JvmVisibility visibility = JvmVisibility.PUBLIC;
            if (source.isDispatch()) {
                sourceName = "_" + sourceName;
                visibility = JvmVisibility.PROTECTED;
            }
            target.setSimpleName(sourceName);
            target.setVisibility(visibility);
            for (XtendParameter parameter : source.getParameters()) {
                JvmFormalParameter jvmParam = this.typesFactory.createJvmFormalParameter();
                jvmParam.setName(parameter.getName());
                jvmParam.setParameterType((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)parameter.getParameterType()));
                target.getParameters().add((Object)jvmParam);
            }
            if (source.getReturnType() != null) {
                target.setReturnType((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)source.getReturnType()));
            } else {
                target.setReturnType(this.getTypeProxy((EObject)target));
            }
            for (JvmTypeParameter typeParameter : source.getTypeParameters()) {
                target.getTypeParameters().add((Object)((JvmTypeParameter)EcoreUtil2.cloneWithProxies((EObject)typeParameter)));
            }
            return target;
        }
        if (sourceMember instanceof XtendField) {
            XtendField dep = (XtendField)sourceMember;
            JvmField field = this.typesFactory.createJvmField();
            container.getMembers().add((Object)field);
            this.associator.associatePrimary((EObject)dep, (EObject)field);
            field.setVisibility(JvmVisibility.PRIVATE);
            field.setSimpleName(dep.getName());
            field.setType((JvmTypeReference)EcoreUtil2.cloneWithProxies((EObject)dep.getType()));
            return field;
        }
        throw new IllegalArgumentException("Cannot transform " + Strings.notNull((Object)sourceMember) + " to a JvmMember");
    }

    protected void computeInferredReturnTypes(JvmGenericType inferredJvmType) {
        Iterable operations = inferredJvmType.getDeclaredOperations();
        for (JvmOperation jvmOperation : operations) {
            jvmOperation.setReturnType(this.getTypeProxy((EObject)jvmOperation));
        }
    }

    protected JvmTypeReference getTypeProxy(EObject pointer) {
        JvmParameterizedTypeReference typeReference = this.typesFactory.createJvmParameterizedTypeReference();
        Resource eResource = pointer.eResource();
        String fragment = eResource.getURIFragment(pointer);
        URI uri = eResource.getURI();
        uri = uri.appendFragment("\u00a7lazyType$" + fragment);
        ((InternalEObject)typeReference).eSetProxyURI(uri);
        return typeReference;
    }
}

