/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.search.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.layer.ILayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellDisplayValueSearchUtil {
    static List<PositionCoordinate> getCellCoordinates(ILayer contextLayer, int startingColumnPosition, int startingRowPosition, int width, int height) {
        ArrayList<PositionCoordinate> coordinates = new ArrayList<PositionCoordinate>();
        int columnPosition = 0;
        while (columnPosition < width) {
            int rowPosition = 0;
            while (rowPosition < height) {
                PositionCoordinate coordinate = new PositionCoordinate(contextLayer, startingColumnPosition, startingRowPosition++);
                coordinates.add(coordinate);
                ++rowPosition;
            }
            ++startingColumnPosition;
            ++columnPosition;
        }
        return coordinates;
    }

    static List<PositionCoordinate> getDescendingCellCoordinates(ILayer contextLayer, int startingColumnPosition, int startingRowPosition, int width, int height) {
        ArrayList<PositionCoordinate> coordinates = new ArrayList<PositionCoordinate>();
        int columnPosition = width;
        while (columnPosition >= 0 && startingColumnPosition >= 0) {
            int rowPosition = height;
            while (rowPosition >= 0 && startingRowPosition >= 0) {
                PositionCoordinate coordinate = new PositionCoordinate(contextLayer, startingColumnPosition, startingRowPosition--);
                coordinates.add(coordinate);
                --rowPosition;
            }
            --startingColumnPosition;
            --columnPosition;
        }
        return coordinates;
    }

    static PositionCoordinate findCell(ILayer layer, IConfigRegistry configRegistry, PositionCoordinate[] cellsToSearch, Object valueToMatch, Comparator comparator, boolean caseSensitive) {
        List<PositionCoordinate> cellCoordinates = Arrays.asList(cellsToSearch);
        PositionCoordinate targetCoordinate = null;
        String stringValue = caseSensitive ? valueToMatch.toString() : valueToMatch.toString().toLowerCase();
        int cellIndex = 0;
        while (cellIndex < cellCoordinates.size()) {
            PositionCoordinate cellCoordinate = cellCoordinates.get(cellIndex);
            int columnPosition = cellCoordinate.columnPosition;
            int rowPosition = cellCoordinate.rowPosition;
            IDisplayConverter displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "NORMAL", layer.getConfigLabelsByPosition(columnPosition, rowPosition).getLabels());
            Object dataValue = displayConverter.canonicalToDisplayValue(layer.getDataValueByPosition(columnPosition, rowPosition));
            if (dataValue instanceof Comparable) {
                String dataValueString;
                String string = dataValueString = caseSensitive ? dataValue.toString() : dataValue.toString().toLowerCase();
                if (comparator.compare(stringValue, dataValueString) == 0 || dataValueString.contains(stringValue)) {
                    targetCoordinate = cellCoordinate;
                    break;
                }
            }
            ++cellIndex;
        }
        return targetCoordinate;
    }
}

