/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnectionRequest;

public class NetPackageRequest
extends NetConnectionRequest {
    static final String COLLECTIONNAME = "NULLID";
    static final String collectionName = "NULLID";

    NetPackageRequest(NetAgent netAgent, CcsidManager ccsidManager, int bufferSize) {
        super(netAgent, ccsidManager, bufferSize);
    }

    void buildCommonPKGNAMinfo(Section section) throws SqlException {
        String collectionToFlow = "NULLID";
        int maxIdentifierLength = 255;
        boolean scldtalenRequired = false;
        scldtalenRequired = this.checkPKGNAMlengths(this.netAgent_.netConnection_.databaseName_, maxIdentifierLength, 18);
        if (!scldtalenRequired) {
            scldtalenRequired = this.checkPKGNAMlengths(collectionToFlow, maxIdentifierLength, 18);
        }
        if (!scldtalenRequired) {
            scldtalenRequired = this.checkPKGNAMlengths(section.getPackageName(), maxIdentifierLength, 18);
        }
        if (!scldtalenRequired) {
            this.writeScalarPaddedString(this.netAgent_.netConnection_.databaseName_, 18);
            this.writeScalarPaddedString(collectionToFlow, 18);
            this.writeScalarPaddedString(section.getPackageName(), 18);
        } else {
            this.buildSCLDTA(this.netAgent_.netConnection_.databaseName_, 18);
            this.buildSCLDTA(collectionToFlow, 18);
            this.buildSCLDTA(section.getPackageName(), 18);
        }
    }

    private void buildSCLDTA(String identifier, int minimumLength) throws SqlException {
        if (identifier.length() <= minimumLength) {
            this.write2Bytes(minimumLength);
            this.writeScalarPaddedString(identifier, minimumLength);
        } else {
            this.write2Bytes(identifier.length());
            this.writeScalarPaddedString(identifier, identifier.length());
        }
    }

    void buildPKGNAMCSN(Section section) throws SqlException {
        if (!this.canCommandUseDefaultPKGNAMCSN()) {
            this.markLengthBytes(8467);
            if (section.getPKGNAMCBytes() != null) {
                this.writeStoredPKGNAMCBytes(section);
            } else {
                this.markForCachingPKGNAMCSN();
                this.buildCommonPKGNAMinfo(section);
                this.writeScalarPaddedBytes(Configuration.dncPackageConsistencyToken, 8, (byte)0);
                this.storePKGNAMCBytes(section);
            }
            this.write2Bytes(section.getSectionNumber());
            this.updateLengthBytes();
        } else {
            this.writeScalar2Bytes(8460, section.getSectionNumber());
        }
    }

    private void storePKGNAMCBytes(Section section) {
        int startPos = this.popMarkForCachingPKGNAMCSN();
        int copyLength = this.offset_ - startPos;
        byte[] b = new byte[copyLength];
        System.arraycopy(this.bytes_, startPos, b, 0, copyLength);
        section.setPKGNAMCBytes(b);
    }

    private void writeStoredPKGNAMCBytes(Section section) {
        byte[] b = section.getPKGNAMCBytes();
        this.ensureLength(this.offset_ + b.length);
        System.arraycopy(b, 0, this.bytes_, this.offset_, b.length);
        this.offset_ += b.length;
    }

    private boolean canCommandUseDefaultPKGNAMCSN() {
        return false;
    }

    private boolean checkPKGNAMlengths(String identifier, int maxIdentifierLength, int lengthRequiringScldta) throws SqlException {
        int length = identifier.length();
        if (length > maxIdentifierLength) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("42622"), (Object)identifier, new Integer(maxIdentifierLength));
        }
        return length > lengthRequiringScldta;
    }

    private byte[] getBytes(String string, String encoding) throws SqlException {
        try {
            return string.getBytes(encoding);
        }
        catch (Exception e) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XJ001.U"), (Object)e.getClass().getName(), (Object)e.getMessage(), (Throwable)e);
        }
    }

    private void buildNOCMorNOCS(String string) throws SqlException {
        if (string == null) {
            this.write2Bytes(65535);
        } else {
            byte[] sqlBytes = null;
            if (this.netAgent_.typdef_.isCcsidMbcSet()) {
                sqlBytes = this.getBytes(string, this.netAgent_.typdef_.getCcsidMbcEncoding());
                this.write1Byte(0);
                this.write4Bytes(sqlBytes.length);
                this.writeBytes(sqlBytes, sqlBytes.length);
                this.write1Byte(255);
            } else {
                sqlBytes = this.getBytes(string, this.netAgent_.typdef_.getCcsidSbcEncoding());
                this.write1Byte(255);
                this.write1Byte(0);
                this.write4Bytes(sqlBytes.length);
                this.writeBytes(sqlBytes, sqlBytes.length);
            }
        }
    }

    private void buildSQLSTTGRP(String string) throws SqlException {
        this.buildNOCMorNOCS(string);
    }

    private void buildSQLSTT(String string) throws SqlException {
        this.buildSQLSTTGRP(string);
    }

    protected void buildSQLSTTcommandData(String sql) throws SqlException {
        this.createEncryptedCommandData();
        int loc = this.offset_;
        this.markLengthBytes(9236);
        this.buildSQLSTT(sql);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(loc);
        }
    }

    protected void buildSQLATTRcommandData(String sql) throws SqlException {
        this.createEncryptedCommandData();
        int loc = this.offset_;
        this.markLengthBytes(9296);
        this.buildSQLSTT(sql);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(loc);
        }
    }

    public void encryptDataStream(int lengthLocation) throws SqlException {
        byte[] clearedBytes = new byte[this.offset_ - lengthLocation];
        for (int i = lengthLocation; i < this.offset_; ++i) {
            clearedBytes[i - lengthLocation] = this.bytes_[i];
        }
        byte[] encryptedBytes = this.netAgent_.netConnection_.getEncryptionManager().encryptData(clearedBytes, 9, this.netAgent_.netConnection_.getTargetPublicKey(), this.netAgent_.netConnection_.getTargetPublicKey());
        int length = encryptedBytes.length;
        if (this.bytes_.length >= lengthLocation + length) {
            System.arraycopy(encryptedBytes, 0, this.bytes_, lengthLocation, length);
        } else {
            byte[] largeByte = new byte[lengthLocation + length];
            System.arraycopy(this.bytes_, 0, largeByte, 0, lengthLocation);
            System.arraycopy(encryptedBytes, 0, largeByte, lengthLocation, length);
            this.bytes_ = largeByte;
        }
        this.offset_ += length - clearedBytes.length;
        this.bytes_[lengthLocation - 6] = (byte)(length >>> 8 & 0xFF);
        this.bytes_[lengthLocation - 5] = (byte)(length & 0xFF);
    }
}

