/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.Limit;

public class ArrayOutputStream
extends OutputStream
implements Limit {
    private byte[] pageData;
    private int start;
    private int end;
    private int position;

    public ArrayOutputStream() {
    }

    public ArrayOutputStream(byte[] data) {
        this.setData(data);
    }

    public void setData(byte[] data) {
        this.pageData = data;
        this.start = 0;
        this.end = data != null ? data.length : 0;
        this.position = 0;
    }

    public void write(int b) throws IOException {
        if (this.position >= this.end) {
            throw new EOFException();
        }
        this.pageData[this.position++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.position + len > this.end) {
            throw new EOFException();
        }
        System.arraycopy(b, off, this.pageData, this.position, len);
        this.position += len;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int newPosition) throws IOException {
        if (newPosition < this.start || newPosition > this.end) {
            throw new EOFException();
        }
        this.position = newPosition;
    }

    public void setLimit(int length) throws IOException {
        if (length < 0) {
            throw new EOFException();
        }
        if (this.position + length > this.end) {
            throw new EOFException();
        }
        this.start = this.position;
        this.end = this.position + length;
    }

    public int clearLimit() {
        int unwritten = this.end - this.position;
        this.end = this.pageData.length;
        return unwritten;
    }
}

