/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TupleFilter;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;

public class DropDependencyFilter
implements TupleFilter {
    UUID providerID;
    UUIDFactory uuidFactory = null;
    DataValueFactory dataValueFactory = null;
    BooleanDataValue trueValue;
    BooleanDataValue falseValue;

    public DropDependencyFilter(UUID providerID) {
        this.providerID = providerID;
    }

    public void init(ExecRow parameters) throws StandardException {
    }

    public BooleanDataValue execute(ExecRow currentRow) throws StandardException {
        DataValueDescriptor col = currentRow.getColumn(3);
        String providerIDstring = col.getString();
        UUID providerUUID = this.getUUIDFactory().recreateUUID(providerIDstring);
        if (this.providerID.equals(providerUUID)) {
            return this.getTrueValue();
        }
        return this.getFalseValue();
    }

    private UUIDFactory getUUIDFactory() throws StandardException {
        if (this.uuidFactory == null) {
            this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory;
    }

    private DataValueFactory getDataValueFactory() {
        if (this.dataValueFactory == null) {
            LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
            this.dataValueFactory = lcc.getDataValueFactory();
        }
        return this.dataValueFactory;
    }

    private BooleanDataValue getTrueValue() throws StandardException {
        if (this.trueValue == null) {
            this.trueValue = this.getDataValueFactory().getDataValue(true);
        }
        return this.trueValue;
    }

    private BooleanDataValue getFalseValue() throws StandardException {
        if (this.falseValue == null) {
            this.falseValue = this.getDataValueFactory().getDataValue(false);
        }
        return this.falseValue;
    }
}

