/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class BaseTableNumbersVisitor
implements Visitor {
    private JBitSet tableMap;
    private int columnNumber;

    public BaseTableNumbersVisitor(JBitSet tableMap) {
        this.tableMap = tableMap;
        this.columnNumber = -1;
    }

    protected void setTableMap(JBitSet tableMap) {
        this.tableMap = tableMap;
    }

    protected void reset() {
        this.tableMap.clearAll();
        this.columnNumber = -1;
    }

    protected int getColumnNumber() {
        return this.columnNumber;
    }

    public Visitable visit(Visitable node) throws StandardException {
        ResultColumn rc = null;
        if (node instanceof ColumnReference) {
            rc = ((ColumnReference)node).getSource();
            if (rc == null) {
                return node;
            }
        } else if (node instanceof ResultColumn) {
            rc = (ResultColumn)node;
        } else if (node instanceof SelectNode) {
            ((SelectNode)node).getFromList().accept(this);
        } else if (node instanceof FromBaseTable) {
            this.tableMap.set(((FromBaseTable)node).getTableNumber());
        }
        if (rc != null) {
            int baseTableNumber = rc.getTableNumber();
            if (baseTableNumber >= 0) {
                ValueNode rcExpr = rc.getExpression();
                while (rcExpr instanceof VirtualColumnNode) {
                    rc = ((VirtualColumnNode)rcExpr).getSourceColumn();
                    rcExpr = rc.getExpression();
                }
                if (rcExpr instanceof ColumnReference) {
                    rcExpr.accept(this);
                } else {
                    this.tableMap.set(baseTableNumber);
                    this.columnNumber = rc.getColumnPosition();
                }
            } else if (node instanceof ColumnReference) {
                ColumnReference cr = (ColumnReference)node;
                cr.getTablesReferenced(this.tableMap);
                this.columnNumber = cr.getColumnNumber();
            }
        }
        return node;
    }

    public boolean skipChildren(Visitable node) {
        return node instanceof FromBaseTable || node instanceof SelectNode || node instanceof PredicateList;
    }

    public boolean stopTraversal() {
        return false;
    }
}

