/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Arrays;
import java.util.Collections;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.TableScanResultSet;

class MultiProbeTableScanResultSet
extends TableScanResultSet
implements CursorResultSet {
    protected DataValueDescriptor[] probeValues;
    protected DataValueDescriptor[] origProbeValues;
    protected int probeValIndex;
    private int sortRequired;

    MultiProbeTableScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, DataValueDescriptor[] probingVals, int sortRequired, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(conglomId, scoci, activation, resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, colRefItem, indexColItem, lockMode, tableLocked, isolationLevel, 1, oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost);
        SanityManager.ASSERT(probingVals != null && probingVals.length > 0, "No probe values found for multi-probe scan.");
        this.origProbeValues = probingVals;
        this.sortRequired = sortRequired;
    }

    public void openCore() throws StandardException {
        if (this.sortRequired == 3) {
            this.probeValues = this.origProbeValues;
        } else {
            Object[] pVals = new DataValueDescriptor[this.origProbeValues.length];
            for (int i = 0; i < pVals.length; ++i) {
                pVals[i] = this.origProbeValues[i].getClone();
            }
            if (this.sortRequired == 1) {
                Arrays.sort(pVals);
            } else {
                Arrays.sort(pVals, Collections.reverseOrder());
            }
            this.probeValues = pVals;
        }
        this.probeValIndex = 0;
        super.openCore();
    }

    protected void openScanController(TransactionController tc) throws StandardException {
        this.openScanController(tc, this.probeValues[0]);
        this.probeValIndex = 1;
    }

    public void reopenCore() throws StandardException {
        this.reopenCore(false);
    }

    private void reopenCore(boolean forNextProbe) throws StandardException {
        if (!forNextProbe) {
            this.probeValIndex = 0;
        }
        super.reopenCore();
    }

    protected void reopenScanController() throws StandardException {
        if (this.probeValIndex == 0) {
            this.rowsThisScan = 0L;
        }
        DataValueDescriptor pv = null;
        if (this.moreInListVals() && (pv = this.getNextProbeValue()) == null) {
            return;
        }
        this.reopenScanController(pv);
    }

    public ExecRow getNextRowCore() throws StandardException {
        this.checkCancellationFlag();
        ExecRow result = super.getNextRowCore();
        while (result == null && this.moreInListVals()) {
            this.reopenCore(true);
            result = super.getNextRowCore();
        }
        return result;
    }

    public void close() throws StandardException {
        super.close();
    }

    private boolean moreInListVals() {
        return this.probeValIndex < this.probeValues.length;
    }

    private DataValueDescriptor getNextProbeValue() throws StandardException {
        int ctr;
        for (ctr = this.probeValIndex; ctr > 0 && ctr < this.probeValues.length && this.probeValues[this.probeValIndex - 1].equals(this.probeValues[ctr]); ++ctr) {
        }
        this.probeValIndex = ctr;
        if (this.probeValIndex < this.probeValues.length) {
            return this.probeValues[this.probeValIndex++];
        }
        return null;
    }
}

