/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.sql.execute.rts.RealNoRowsResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;

public class RealDeleteResultSetStatistics
extends RealNoRowsResultSetStatistics {
    public int rowCount;
    public boolean deferred;
    public boolean tableLock;
    public int indexesUpdated;

    public RealDeleteResultSetStatistics(int rowCount, boolean deferred, int indexesUpdated, boolean tableLock, long executeTime, ResultSetStatistics sourceResultSetStatistics) {
        super(executeTime, sourceResultSetStatistics);
        this.rowCount = rowCount;
        this.deferred = deferred;
        this.indexesUpdated = indexesUpdated;
        this.tableLock = tableLock;
        this.sourceResultSetStatistics = sourceResultSetStatistics;
    }

    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        return this.indent + MessageService.getTextMessage("43X13.U") + " " + MessageService.getTextMessage(this.tableLock ? "43X14.U" : "43X15.U") + ":\n" + this.indent + MessageService.getTextMessage("43X16.U") + ": " + this.deferred + "\n" + this.indent + MessageService.getTextMessage("43X17.U") + " = " + this.rowCount + "\n" + this.indent + MessageService.getTextMessage("43X18.U") + " = " + this.indexesUpdated + "\n" + this.dumpTimeStats(this.indent) + (this.sourceResultSetStatistics == null ? "" : this.sourceResultSetStatistics.getStatementExecutionPlanText(1));
    }

    public String getScanStatisticsText(String tableName, int depth) {
        if (this.sourceResultSetStatistics == null) {
            return "";
        }
        return this.sourceResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43X19.U");
    }
}

