/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PageActions;

public class DirectActions
implements PageActions {
    protected DynamicByteArrayOutputStream outBytes = new DynamicByteArrayOutputStream();
    protected ArrayInputStream limitIn = new ArrayInputStream();

    public void actionDelete(RawTransaction t, BasePage page, int slot, int recordId, boolean delete, LogicalUndo undo) throws StandardException {
        try {
            page.setDeleteStatus(null, slot, delete);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }

    public int actionUpdate(RawTransaction t, BasePage page, int slot, int recordId, Object[] row, FormatableBitSet validColumns, int realStartColumn, DynamicByteArrayOutputStream logBuffer, int realSpaceOnPage, RecordHandle headRowHandle) throws StandardException {
        if (logBuffer == null) {
            this.outBytes.reset();
        } else {
            this.outBytes = logBuffer;
        }
        try {
            int nextColumn = page.logRow(slot, false, recordId, row, validColumns, this.outBytes, 0, (byte)8, realStartColumn, realSpaceOnPage, 100);
            this.limitIn.setData(this.outBytes.getByteArray());
            this.limitIn.setPosition(this.outBytes.getBeginPosition());
            this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
            page.storeRecord(null, slot, false, this.limitIn);
            return nextColumn;
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }

    public void actionPurge(RawTransaction t, BasePage page, int slot, int num_rows, int[] recordIds, boolean needDataLogged) throws StandardException {
        try {
            for (int i = num_rows - 1; i >= 0; --i) {
                page.purgeRecord(null, slot + i, recordIds[i]);
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }

    public void actionUpdateField(RawTransaction t, BasePage page, int slot, int recordId, int fieldId, Object newValue, LogicalUndo undo) throws StandardException {
        this.outBytes.reset();
        try {
            page.logColumn(slot, fieldId, newValue, this.outBytes, 100);
            this.limitIn.setData(this.outBytes.getByteArray());
            this.limitIn.setPosition(this.outBytes.getBeginPosition());
            this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
            page.storeField(null, slot, fieldId, this.limitIn);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }

    public int actionInsert(RawTransaction t, BasePage page, int slot, int recordId, Object[] row, FormatableBitSet validColumns, LogicalUndo undo, byte insertFlag, int startColumn, boolean isLongColumn, int realStartColumn, DynamicByteArrayOutputStream logBuffer, int realSpaceOnPage, int overflowThreshold) throws StandardException {
        if (logBuffer == null) {
            this.outBytes.reset();
        } else {
            this.outBytes = logBuffer;
        }
        try {
            startColumn = isLongColumn ? page.logLongColumn(slot, recordId, row[0], this.outBytes) : page.logRow(slot, true, recordId, row, validColumns, this.outBytes, startColumn, insertFlag, realStartColumn, realSpaceOnPage, overflowThreshold);
            this.limitIn.setData(this.outBytes.getByteArray());
            this.limitIn.setPosition(this.outBytes.getBeginPosition());
            this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
            page.storeRecord(null, slot, true, this.limitIn);
            return startColumn;
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }

    public void actionCopyRows(RawTransaction t, BasePage destPage, BasePage srcPage, int destSlot, int numRows, int srcSlot, int[] recordIds) throws StandardException {
        try {
            int i;
            int[] spaceNeeded = new int[numRows];
            for (i = 0; i < numRows; ++i) {
                this.outBytes.reset();
                srcPage.logRecord(srcSlot + i, 0, recordIds[i], null, this.outBytes, null);
                spaceNeeded[i] = this.outBytes.getUsed();
            }
            if (!destPage.spaceForCopy(numRows, spaceNeeded)) {
                throw StandardException.newException("XSDA3.S");
            }
            for (i = 0; i < numRows; ++i) {
                this.outBytes.reset();
                srcPage.logRecord(srcSlot + i, 0, recordIds[i], null, this.outBytes, null);
                this.limitIn.setData(this.outBytes.getByteArray());
                this.limitIn.setPosition(this.outBytes.getBeginPosition());
                this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
                destPage.storeRecord(null, destSlot + i, true, this.limitIn);
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }

    public void actionInvalidatePage(RawTransaction t, BasePage page) throws StandardException {
        page.setPageStatus(null, (byte)2);
    }

    public void actionInitPage(RawTransaction t, BasePage page, int initFlag, int pageFormatId, long pageOffset) throws StandardException {
        boolean overflowPage = (initFlag & 2) != 0;
        boolean reuse = (initFlag & 1) != 0;
        int nextRecordId = (initFlag & 4) == 0 ? page.newRecordId() : 6;
        SanityManager.ASSERT(page.getTypeFormatId() == pageFormatId, "Direct initPage somehow got the wrong page formatId");
        page.initPage(null, (byte)1, nextRecordId, overflowPage, reuse);
    }

    public void actionShrinkReservedSpace(RawTransaction t, BasePage page, int slot, int recordId, int newValue, int oldValue) throws StandardException {
        try {
            page.setReservedSpace(null, slot, newValue);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }
}

