/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.keyprovider;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeneratorHostKeyProvider
extends AbstractKeyPairProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FileKeyPairProvider.class);
    private String path;
    private String algorithm = "DSA";
    private int keySize;
    private KeyPair keyPair;

    protected AbstractGeneratorHostKeyProvider() {
    }

    protected AbstractGeneratorHostKeyProvider(String path) {
        this.path = path;
    }

    protected AbstractGeneratorHostKeyProvider(String path, String algorithm) {
        this.path = path;
        this.algorithm = algorithm;
    }

    protected AbstractGeneratorHostKeyProvider(String path, String algorithm, int keySize) {
        this.path = path;
        this.algorithm = algorithm;
        this.keySize = keySize;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    protected abstract KeyPair doReadKeyPair(InputStream var1) throws Exception;

    protected abstract void doWriteKeyPair(KeyPair var1, OutputStream var2) throws Exception;

    public synchronized KeyPair[] loadKeys() {
        if (this.keyPair == null) {
            File f;
            if (this.path != null && (f = new File(this.path)).exists() && f.isFile()) {
                this.keyPair = this.readKeyPair(f);
            }
            if (this.keyPair == null) {
                this.keyPair = this.generateKeyPair(this.algorithm);
                if (this.keyPair != null && this.path != null) {
                    this.writeKeyPair(this.keyPair, new File(this.path));
                }
            }
            if (this.keyPair == null) {
                return new KeyPair[0];
            }
        }
        return new KeyPair[]{this.keyPair};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPair readKeyPair(File f) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            KeyPair keyPair = this.doReadKeyPair(is);
            Object var5_5 = null;
            this.close(is);
            return keyPair;
        }
        catch (Exception e) {
            try {
                LOG.info("Unable to read key {}: {}", (Object)this.path, (Object)e);
                Object var5_6 = null;
                this.close(is);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.close(is);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKeyPair(KeyPair kp, File f) {
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(f);
                this.doWriteKeyPair(kp, os);
            }
            catch (Exception e) {
                LOG.info("Unable to write key {}: {}", (Object)this.path, (Object)e);
                Object var6_5 = null;
                this.close(os);
            }
            Object var6_4 = null;
            this.close(os);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.close(os);
            throw throwable;
        }
    }

    private KeyPair generateKeyPair(String algorithm) {
        try {
            KeyPairGenerator generator = SecurityUtils.getKeyPairGenerator(algorithm);
            if (this.keySize != 0) {
                generator.initialize(this.keySize);
            }
            LOG.info("Generating host key...");
            KeyPair kp = generator.generateKeyPair();
            return kp;
        }
        catch (Exception e) {
            LOG.error("Unable to generate keypair", (Throwable)e);
            return null;
        }
    }

    private void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

