/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.acceleo.ui.interpreter.InterpreterPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.PlatformUI;

public final class InterpreterImages {
    private static final URL BASE_URL = InterpreterPlugin.getDefault().getBundle().getEntry("icons/");
    private static ImageRegistry imageRegistry;

    private InterpreterImages() {
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return InterpreterImages.getImageRegistry().getDescriptor(key);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            InterpreterImages.initializeRegistry();
        }
        return imageRegistry;
    }

    private static void createImage(String key, String path) {
        ImageDescriptor image = ImageDescriptor.getMissingImageDescriptor();
        if (BASE_URL != null) {
            try {
                image = ImageDescriptor.createFromURL((URL)new URL(BASE_URL, path));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        imageRegistry.put(key, image);
    }

    private static void initializeRegistry() {
        imageRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        InterpreterImages.createImage("clear_action.gif", "clear_action.gif");
        InterpreterImages.createImage("delete_action_disabled.gif", "delete_action_disabled.gif");
        InterpreterImages.createImage("delete_action.gif", "delete_action.gif");
        InterpreterImages.createImage("evaluate_action.gif", "evaluate_action.gif");
        InterpreterImages.createImage("view_icon.gif", "view_icon.gif");
        InterpreterImages.createImage("link_action.gif", "link_action.gif");
        InterpreterImages.createImage("link_action_disabled.gif", "link_action_disabled.gif");
        InterpreterImages.createImage("realtime_action.gif", "realtime_action.gif");
        InterpreterImages.createImage("variable_action.gif", "variable_action.gif");
    }
}

