/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.zest.ide;

import org.eclipse.amp.agf.zest.GraphViewPart;
import org.eclipse.amp.agf.zest.SpringPartitionLayoutAlgorithm;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;

public class SpringLayoutModAction
implements IViewActionDelegate {
    SpringPartitionLayoutAlgorithm algorithm;
    private boolean modified = false;
    GraphViewPart zestPart;
    double gravity = 0.5;
    double strain = 0.5;
    double move = 0.5;
    double length = 0.5;

    public void init(IViewPart view) {
        this.zestPart = (GraphViewPart)view;
        this.algorithm = ((GraphViewPart)view).getSpringLayout();
        this.gravity = this.zestPart.getGravity();
        this.strain = this.zestPart.getStrain();
        this.move = this.zestPart.getSpringMove();
        this.length = this.zestPart.getSpringLength();
    }

    protected boolean modifyAlgorithm(AbstractLayoutAlgorithm alg) {
        this.modified = false;
        Shell shell = new Shell(Display.getDefault());
        ModifyDialog dialog = new ModifyDialog(shell);
        dialog.open();
        return this.modified;
    }

    public void run(IAction action) {
        this.modified = false;
        Shell shell = Display.getDefault().getActiveShell();
        ModifyDialog dialog = new ModifyDialog(shell);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.zestPart.setSpringCustomizer(action);
    }

    class ModifyDialog
    extends TitleAreaDialog {
        public ModifyDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle("Spring Layout Settings");
            this.setMessage("Adjust settings for graph layout.");
            parent.setLayout((Layout)new GridLayout(3, true));
            this.gravitationAdjustment(parent);
            this.strainAdjustment(parent);
            this.lengthAdjustment(parent);
            this.springMove(parent);
            return super.createDialogArea(parent);
        }

        private void modifyLayout() {
        }

        private void springMove(Composite parent) {
            Label spring = new Label(parent, 0);
            spring.setText("Move");
            final Slider springSlider = new Slider(parent, 256);
            final Text text = new Text(parent, 0);
            springSlider.setSelection((int)(SpringLayoutModAction.this.move * 100.0));
            text.setText("" + SpringLayoutModAction.this.move);
            springSlider.setMinimum(0);
            springSlider.setMaximum(100);
            springSlider.setIncrement(1);
            springSlider.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.move = (double)springSlider.getSelection() / 100.0;
                    ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.zestPart.setSpringMove(((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.move);
                    text.setText("" + ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.algorithm.getSpringMove());
                    SpringLayoutModAction.this.modified = true;
                    ModifyDialog.this.modifyLayout();
                }
            });
        }

        private void lengthAdjustment(Composite parent) {
            Label spring = new Label(parent, 0);
            spring.setText("Length");
            final Slider springSlider = new Slider(parent, 256);
            final Text text = new Text(parent, 0);
            text.setText("" + SpringLayoutModAction.this.length);
            springSlider.setSelection((int)(SpringLayoutModAction.this.length * 100.0));
            springSlider.setMinimum(0);
            springSlider.setMaximum(100);
            springSlider.setIncrement(1);
            springSlider.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.length = (double)springSlider.getSelection() / 100.0;
                    ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.zestPart.setSpringLength(((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.length);
                    text.setText("" + ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.algorithm.getSpringLength());
                    SpringLayoutModAction.this.modified = true;
                    ModifyDialog.this.modifyLayout();
                }
            });
        }

        private void strainAdjustment(Composite parent) {
            Label spring = new Label(parent, 0);
            spring.setText("Strain");
            final Slider springSlider = new Slider(parent, 256);
            final Text text = new Text(parent, 0);
            text.setText("" + SpringLayoutModAction.this.strain);
            springSlider.setSelection((int)(SpringLayoutModAction.this.strain * 100.0));
            springSlider.setMinimum(0);
            springSlider.setMaximum(100);
            springSlider.setIncrement(1);
            springSlider.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.strain = (double)springSlider.getSelection() / 100.0;
                    ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.zestPart.setStrain(((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.strain);
                    text.setText("" + ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.algorithm.getSpringStrain());
                    SpringLayoutModAction.this.modified = true;
                    ModifyDialog.this.modifyLayout();
                }
            });
        }

        private void gravitationAdjustment(Composite parent) {
            Label spring = new Label(parent, 0);
            spring.setText("Gravity");
            final Slider springSlider = new Slider(parent, 256);
            final Text text = new Text(parent, 0);
            text.setText("" + SpringLayoutModAction.this.gravity);
            springSlider.setSelection((int)(SpringLayoutModAction.this.gravity * 100.0));
            springSlider.setMinimum(0);
            springSlider.setMaximum(100);
            springSlider.setIncrement(1);
            springSlider.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.gravity = (double)springSlider.getSelection() / 100.0;
                    ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.zestPart.setGravity(((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.gravity);
                    text.setText("" + ((ModifyDialog)ModifyDialog.this).SpringLayoutModAction.this.gravity);
                    SpringLayoutModAction.this.modified = true;
                    ModifyDialog.this.modifyLayout();
                }
            });
        }
    }
}

