/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis;

import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartSpinner;
import org.eclipse.birt.chart.ui.swt.composites.LabelAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class AxisLabelSheet
extends AbstractPopupSheet
implements Listener {
    private Composite cmpContent = null;
    private LabelAttributesComposite lacLabel = null;
    private ChartSpinner iscInterval;
    private ChartSpinner iscEllipsis;
    private Axis axis;
    private int axisType;
    private Axis defAxis;

    public AxisLabelSheet(String title, ChartWizardContext context, Axis axis, int axisType, Axis defAxis) {
        super(title, context, true);
        this.axis = axis;
        this.axisType = axisType;
        this.defAxis = defAxis;
    }

    protected void bindHelp(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.TextFormat_ID");
    }

    protected Composite getComponent(Composite parent) {
        this.cmpContent = new Composite(parent, 0);
        GridLayout glMain = new GridLayout();
        glMain.marginHeight = 7;
        glMain.marginWidth = 7;
        this.cmpContent.setLayout((Layout)glMain);
        boolean isLabelEnabled = !this.getContext().getUIFactory().isSetInvisible((EObject)this.getAxisForProcessing().getLabel());
        Group grpLabel = new Group(this.cmpContent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 10;
        grpLabel.setLayout((Layout)layout);
        grpLabel.setText(Messages.getString("BaseAxisLabelAttributeSheetImpl.Lbl.Label"));
        grpLabel.setEnabled(isLabelEnabled);
        this.lacLabel = new LabelAttributesComposite((Composite)grpLabel, 0, this.getContext(), this.getLabelAttributesContext(), null, (EObject)this.getAxisForProcessing(), "labelPosition", "label", (EObject)this.defAxis, this.getChart().getUnits(), this.getPositionScope());
        GridData gdLACLabel = new GridData(768);
        gdLACLabel.horizontalSpan = 2;
        this.lacLabel.setLayoutData(gdLACLabel);
        this.lacLabel.addListener(this);
        this.lacLabel.setEnabled(isLabelEnabled);
        switch (this.axisType) {
            case 1: {
                this.lacLabel.setDefaultLabelValue(DefaultValueProvider.defBaseAxis().getLabel());
                break;
            }
            case 2: {
                this.lacLabel.setDefaultLabelValue(DefaultValueProvider.defOrthogonalAxis().getLabel());
                break;
            }
            case 3: {
                this.lacLabel.setDefaultLabelValue(DefaultValueProvider.defAncillaryAxis().getLabel());
            }
        }
        Composite cmpOther = new Composite((Composite)grpLabel, 0);
        GridLayout glCmpOther = new GridLayout();
        glCmpOther.numColumns = 3;
        glCmpOther.marginWidth = 0;
        glCmpOther.marginHeight = 0;
        cmpOther.setLayout((Layout)glCmpOther);
        Label lblInterval = new Label(cmpOther, 0);
        GridData gd = new GridData();
        gd.horizontalIndent = 10;
        lblInterval.setLayoutData((Object)gd);
        lblInterval.setText(Messages.getString("AxisTextSheet.Label.Interval"));
        lblInterval.setEnabled(isLabelEnabled);
        this.iscInterval = this.getContext().getUIFactory().createChartSpinner(cmpOther, 2048, (EObject)this.getAxisForProcessing(), "interval", isLabelEnabled);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = 135;
        this.iscInterval.setLayoutData((Object)gd);
        this.iscInterval.getWidget().setMinimum(1);
        this.iscInterval.getWidget().setSelection(this.getAxisForProcessing().getInterval());
        this.createEllipsis(cmpOther);
        return this.cmpContent;
    }

    protected LabelAttributesComposite.LabelAttributesContext getLabelAttributesContext() {
        LabelAttributesComposite.LabelAttributesContext attributesContext = new LabelAttributesComposite.LabelAttributesContext();
        if (this.axisType == 3) {
            attributesContext.isPositionEnabled = false;
            attributesContext.isVisibilityEnabled = false;
            attributesContext.isFontEnabled = false;
            attributesContext.isFontAlignmentEnabled = false;
        } else {
            attributesContext.isVisibilityEnabled = false;
            attributesContext.isFontEnabled = false;
            attributesContext.isFontAlignmentEnabled = false;
        }
        return attributesContext;
    }

    protected void createEllipsis(Composite cmpOther) {
        Label lbEllipsis = new Label(cmpOther, 0);
        GridData gd = new GridData();
        gd.horizontalIndent = 10;
        lbEllipsis.setLayoutData((Object)gd);
        lbEllipsis.setText(Messages.getString("AxisLabelSheet.Label.Ellipsis"));
        lbEllipsis.setEnabled(true);
        boolean enableEllipsis = this.canEnableEllipsisUI();
        this.iscEllipsis = this.getContext().getUIFactory().createChartSpinner(cmpOther, 2048, (EObject)this.getAxisForProcessing().getLabel(), "ellipsis", enableEllipsis);
        GridData gd2 = new GridData(1808);
        gd2.horizontalSpan = 2;
        this.iscEllipsis.setLayoutData((Object)gd2);
        this.iscEllipsis.getWidget().setMinimum(0);
        this.iscEllipsis.getWidget().setToolTipText(Messages.getString("AxisLabelSheet.Label.Ellipsis.Tooltip"));
        this.iscEllipsis.getWidget().setSelection(this.getAxisForProcessing().getLabel().getEllipsis());
    }

    protected boolean canEnableEllipsisUI() {
        Axis axis = this.getAxisForProcessing();
        return axis.isSetType() && axis.getType() == AxisType.TEXT_LITERAL || !axis.isSetType() && this.defAxis.getType() == AxisType.TEXT_LITERAL || axis.isSetCategoryAxis() && axis.isCategoryAxis() || !axis.isSetCategoryAxis() && this.defAxis.isCategoryAxis();
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.lacLabel)) {
            boolean isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
            switch (event.type) {
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getLabel(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing(), (String)"labelPosition", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.getAxisForProcessing().getLabel().getCaption().setFont((FontDefinition)((Object[])event.data)[0]);
                    this.getAxisForProcessing().getLabel().getCaption().setColor((ColorDefinition)((Object[])event.data)[1]);
                    break;
                }
                case 4: {
                    this.getAxisForProcessing().getLabel().setBackground((Fill)event.data);
                    break;
                }
                case 5: {
                    this.getAxisForProcessing().getLabel().setShadowColor((ColorDefinition)event.data);
                    break;
                }
                case 6: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getLabel().getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 7: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getLabel().getOutline(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                    break;
                }
                case 8: {
                    this.getAxisForProcessing().getLabel().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 9: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getAxisForProcessing().getLabel().getOutline(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                    break;
                }
                case 10: {
                    this.getAxisForProcessing().getLabel().setInsets((Insets)event.data);
                }
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private Axis getAxisForProcessing() {
        return this.axis;
    }

    private int getPositionScope() {
        if (this.axisType == 1) {
            return 3;
        }
        return 12;
    }
}

