/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.util;

import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.CurveFitting;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.CurveFittingImpl;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartUIHelper;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.widgets.Combo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartUIExtensionUtil {
    public static int PROPERTY_UPDATE = ChartElementUtil.PROPERTY_UPDATE;
    public static int PROPERTY_UNSET = ChartElementUtil.PROPERTY_UNSET;

    public static void populateSeriesTypesList(Hashtable<String, Series> htSeriesNames, Combo cmbTypes, ChartWizardContext context, Collection<IChartType> allChartType, Series currentSeries) {
        IChartUIHelper helper = context.getUIFactory().createUIHelper();
        IChartType currentChartType = ChartUIUtil.getChartType((String)context.getModel().getType());
        cmbTypes.removeAll();
        if (helper.canCombine(currentChartType, context)) {
            Orientation orientation = ((ChartWithAxes)context.getModel()).getOrientation();
            for (IChartType type : allChartType) {
                Series newSeries = type.getSeries(false);
                if (!helper.canCombine(type, context) || newSeries instanceof AreaSeries && context.getModel().getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) continue;
                if (!(newSeries instanceof StockSeries) || orientation.getValue() == 1) {
                    String sDisplayName = newSeries.getDisplayName();
                    htSeriesNames.put(sDisplayName, newSeries);
                    cmbTypes.add(sDisplayName);
                }
                if (!type.getName().equals(context.getModel().getType())) continue;
                cmbTypes.select(cmbTypes.getItemCount() - 1);
            }
            String sDisplayName = currentSeries.getDisplayName();
            cmbTypes.setText(sDisplayName);
        } else {
            String seriesName = currentSeries.getDisplayName();
            cmbTypes.add(seriesName);
            cmbTypes.select(0);
        }
    }

    public static CurveFitting createCurveFitting(ChartWizardContext context) {
        return context.getUIFactory().supportAutoUI() ? CurveFittingImpl.createDefault() : CurveFittingImpl.create();
    }
}

