/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.ICloseable;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.CandidateQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.aggregation.AggrDefnManager;
import org.eclipse.birt.data.engine.executor.aggregation.IProgressiveAggregationHelper;
import org.eclipse.birt.data.engine.executor.aggregation.ProgressiveAggregationHelper;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.executor.cache.RowResultSet;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheRequest;
import org.eclipse.birt.data.engine.executor.transform.IGroupCalculator;
import org.eclipse.birt.data.engine.executor.transform.SimpleGroupCalculator;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.StringTable;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IAggrInfo;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Scriptable;

public class SimpleResultSet
implements IResultIterator {
    private RowResultSet rowResultSet;
    private IResultObject currResultObj;
    private IEventHandler handler;
    private int initialRowCount;
    private int rowCount;
    private StreamWrapper streamsWrapper;
    private OutputStream dataSetStream;
    private DataOutputStream dataSetLenStream;
    private long offset = 4L;
    private long rowCountOffset = 0L;
    private Set resultSetNameSet = null;
    private IBaseQueryDefinition query;
    private IResultClass resultClass;
    private IGroupCalculator groupCalculator;
    private IProgressiveAggregationHelper aggrHelper;
    private boolean isClosed;
    private ICloseable closeable;

    public SimpleResultSet(BaseQuery dataSourceQuery, final ResultSet resultSet, IResultClass resultClass, IEventHandler handler, IQuery.GroupSpec[] groupSpecs, DataEngineSession session, boolean forceLookingForward) throws DataException {
        SmartCacheRequest scRequest = new SmartCacheRequest(dataSourceQuery.getMaxRows(), dataSourceQuery.getFetchEvents(), new OdiAdapter(resultSet, resultClass), resultClass, false);
        this.populateRowResultSet(handler, scRequest);
        this.closeable = new ICloseable(){

            public void close() throws DataException {
                resultSet.close();
            }
        };
        this.initialize(dataSourceQuery, resultClass, handler, groupSpecs, session, forceLookingForward);
    }

    private void populateRowResultSet(IEventHandler handler, SmartCacheRequest scRequest) {
        DataSetRuntime runtime = handler.getDataSetRuntime();
        this.rowResultSet = runtime == null ? new RowResultSet(scRequest) : new RowResultSetWithDataSetScopeAwareness(scRequest, runtime);
    }

    public SimpleResultSet(BaseQuery dataSourceQuery, IDataSetPopulator populator, IResultClass resultClass, IEventHandler handler, IQuery.GroupSpec[] groupSpecs, DataEngineSession session, boolean forceLookingForward) throws DataException {
        SmartCacheRequest scRequest = new SmartCacheRequest(dataSourceQuery.getMaxRows(), dataSourceQuery.getFetchEvents(), new OdiAdapter(populator), resultClass, false);
        this.populateRowResultSet(handler, scRequest);
        this.closeable = populator instanceof ICloseable ? (ICloseable)((Object)populator) : null;
        this.initialize(dataSourceQuery, resultClass, handler, groupSpecs, session, forceLookingForward);
    }

    public SimpleResultSet(CandidateQuery dataSourceQuery, final ICustomDataSet customDataSet, IResultClass resultMetadata, IEventHandler handler, IQuery.GroupSpec[] grouping, DataEngineSession session, boolean forceLookingForward) throws DataException {
        SmartCacheRequest scRequest = new SmartCacheRequest(dataSourceQuery.getMaxRows(), dataSourceQuery.getFetchEvents(), new OdiAdapter(customDataSet), resultMetadata, false);
        DataSetRuntime runtime = handler.getDataSetRuntime();
        this.rowResultSet = runtime == null ? new RowResultSet(scRequest) : new RowResultSetWithDataSetScopeAwareness(scRequest, runtime);
        this.closeable = new ICloseable(){

            public void close() throws DataException {
                customDataSet.close();
            }
        };
        this.initialize(dataSourceQuery, resultMetadata, handler, grouping, session, forceLookingForward);
    }

    private void initialize(BaseQuery dataSourceQuery, IResultClass resultClass, IEventHandler handler, IQuery.GroupSpec[] groupSpecs, DataEngineSession session, boolean forceLookingForward) throws DataException {
        this.query = dataSourceQuery.getQueryDefinition();
        this.groupCalculator = this.needLookingForwardFor1Row(groupSpecs, forceLookingForward) ? new SimpleGroupCalculator(session, groupSpecs, this.rowResultSet.getMetaData()) : new DummyGroupCalculator();
        this.currResultObj = this.rowResultSet.next();
        this.groupCalculator.registerCurrentResultObject(this.currResultObj);
        this.groupCalculator.registerNextResultObject(this.rowResultSet);
        this.initialRowCount = this.currResultObj != null ? -1 : 0;
        this.rowCount = this.currResultObj != null ? 1 : 0;
        this.handler = handler;
        this.resultSetNameSet = ResultSetUtil.getRsColumnRequestMap(handler.getAllColumnBindings());
        if (this.query instanceof IQueryDefinition && ((IQueryDefinition)this.query).needAutoBinding()) {
            int i = 1;
            while (i <= resultClass.getFieldCount()) {
                this.resultSetNameSet.add(resultClass.getFieldName(i));
                this.resultSetNameSet.add(resultClass.getFieldAlias(i));
                ++i;
            }
        }
        Scriptable scope = session.getSharedScope();
        AggrDefnManager manager = new AggrDefnManager(this.handler.getAggrDefinitions());
        this.aggrHelper = this.needLookingForwardFor1Row(groupSpecs, forceLookingForward) ? new ProgressiveAggregationHelper(manager, session.getTempDir(), scope, session.getEngineContext().getScriptContext()) : new DummyAggregationHelper();
        this.groupCalculator.setAggrHelper(this.aggrHelper);
    }

    private boolean needLookingForwardFor1Row(IQuery.GroupSpec[] groupSpecs, boolean forceLookingForward) {
        return forceLookingForward || groupSpecs.length > 0 || this.query.cacheQueryResults();
    }

    public void close() throws DataException {
        if (this.isClosed) {
            return;
        }
        if (this.closeable != null) {
            this.closeable.close();
            this.closeable = null;
        }
        this.groupCalculator.close();
        if (this.dataSetStream != null) {
            try {
                if (this.dataSetStream instanceof RAOutputStream) {
                    ((RAOutputStream)this.dataSetStream).seek(this.rowCountOffset);
                    IOUtil.writeInt((OutputStream)this.dataSetStream, (int)this.rowCount);
                }
                if (this.streamsWrapper.getStreamForIndex(this.getResultClass(), this.handler.getAppContext()) != null) {
                    Map<String, IIndexSerializer> hashes = this.streamsWrapper.getStreamForIndex(this.getResultClass(), this.handler.getAppContext());
                    for (IIndexSerializer hash : hashes.values()) {
                        hash.close();
                    }
                }
                Map<String, StringTable> stringTables = this.streamsWrapper.getOutputStringTable(this.getResultClass());
                for (StringTable stringTable : stringTables.values()) {
                    stringTable.close();
                }
                if (this.streamsWrapper.getStreamManager().hasOutStream(31, 0, 2)) {
                    OutputStream exprValueStream = this.streamsWrapper.getStreamManager().getOutStream(31, 0, 2);
                    if (exprValueStream instanceof RAOutputStream) {
                        ((RAOutputStream)exprValueStream).seek(0L);
                        IOUtil.writeInt((OutputStream)exprValueStream, (int)this.rowCount);
                    }
                    exprValueStream.close();
                }
                this.dataSetStream.close();
                this.dataSetStream = null;
            }
            catch (Exception e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
            this.dataSetStream = null;
        }
        if (this.dataSetLenStream != null) {
            try {
                this.dataSetLenStream.close();
            }
            catch (Exception exception) {}
            this.dataSetLenStream = null;
        }
        this.isClosed = true;
    }

    public void incrementalUpdate(StreamWrapper streamsWrapper, int originalRowCount, boolean isSubQuery) throws DataException {
        this.streamsWrapper = streamsWrapper;
        try {
            this.dataSetStream = this.streamsWrapper.getStreamManager().getOutStream(21, 0, 2);
            OutputStream dlenStream = this.streamsWrapper.getStreamManager().getOutStream(23, 0, 2);
            if (this.dataSetStream instanceof RAOutputStream) {
                this.rowCountOffset = ((RAOutputStream)this.dataSetStream).getOffset();
                ((RAOutputStream)this.dataSetStream).seek(((RAOutputStream)this.dataSetStream).length());
                this.offset = ((RAOutputStream)this.dataSetStream).getOffset();
            }
            if (dlenStream instanceof RAOutputStream) {
                ((RAOutputStream)dlenStream).seek(((RAOutputStream)dlenStream).length());
            }
            this.dataSetLenStream = new DataOutputStream(dlenStream);
            this.rowCount += originalRowCount;
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
        this.streamsWrapper = streamsWrapper;
        this.groupCalculator.doSave(streamsWrapper.getStreamManager());
        try {
            if (streamsWrapper.getStreamForResultClass() != null) {
                ((ResultClass)this.populateResultClass(this.getResultClass())).doSave(streamsWrapper.getStreamForResultClass(), (List<IBinding>)(this.query instanceof IQueryDefinition && ((IQueryDefinition)this.query).needAutoBinding() ? null : this.handler.getAllColumnBindings()), streamsWrapper.getStreamManager().getVersion());
                streamsWrapper.getStreamForResultClass().close();
            }
            this.dataSetStream = this.streamsWrapper.getStreamManager().getOutStream(21, 0, 2);
            this.dataSetLenStream = streamsWrapper.getStreamForDataSetRowLens();
            if (this.dataSetStream instanceof RAOutputStream) {
                this.rowCountOffset = ((RAOutputStream)this.dataSetStream).getOffset();
            }
            IOUtil.writeInt((OutputStream)this.dataSetStream, (int)this.initialRowCount);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        this.groupCalculator.next(0);
    }

    private IResultClass populateResultClass(IResultClass meta) throws DataException {
        if (this.resultClass == null) {
            ArrayList<ResultFieldMetadata> list = new ArrayList<ResultFieldMetadata>();
            int i = 1;
            while (i <= meta.getFieldCount()) {
                if (!meta.getFieldName(i).equals("_$$_dte_inner_row_id_$$_")) {
                    list.add(meta.getFieldMetaData(i));
                }
                ++i;
            }
            this.resultClass = new ResultClass(list);
        }
        return this.resultClass;
    }

    public void first(int groupingLevel) throws DataException {
    }

    public Object getAggrValue(String aggrName) throws DataException {
        return this.aggrHelper.getAggrValue(aggrName, this);
    }

    public IProgressiveAggregationHelper getAggrHelper() throws DataException {
        return this.aggrHelper;
    }

    public Integer[] getGroupIndex() throws DataException {
        if (this.groupCalculator.getStartingGroup() == 0) {
            Object[] result = new Integer[this.groupCalculator.getGroupInstanceIndex().length];
            Arrays.fill(result, (Object)0);
            return result;
        }
        Integer[] groupIndex = this.groupCalculator.getGroupInstanceIndex();
        Integer[] copy = new Integer[groupIndex.length];
        System.arraycopy(groupIndex, 0, copy, 0, copy.length);
        return copy;
    }

    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        return 0;
    }

    public IResultObject getCurrentResult() throws DataException {
        return this.currResultObj;
    }

    public int getCurrentResultIndex() throws DataException {
        return this.rowResultSet.getIndex();
    }

    public int getEndingGroupLevel() throws DataException {
        return this.groupCalculator.getEndingGroup();
    }

    public IExecutorHelper getExecutorHelper() {
        return this.handler.getExecutorHelper();
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return null;
    }

    public IResultClass getResultClass() throws DataException {
        return this.rowResultSet.getMetaData();
    }

    public ResultSetCache getResultSetCache() {
        return null;
    }

    public int getRowCount() throws DataException {
        return this.initialRowCount;
    }

    public int getStartingGroupLevel() throws DataException {
        return this.groupCalculator.getStartingGroup();
    }

    /*
     * Unable to fully structure code
     */
    public void last(int groupingLevel) throws DataException {
        if (this.getEndingGroupLevel() > groupingLevel) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            if (this.getEndingGroupLevel() > groupingLevel) continue;
            return;
lbl5:
            // 2 sources

            ** while (this.next())
        }
lbl6:
        // 1 sources

    }

    public boolean next() throws DataException {
        if (this.currResultObj == null) {
            return false;
        }
        if (this.streamsWrapper != null && this.currResultObj != null) {
            try {
                if (this.dataSetStream != null) {
                    int colCount = this.populateResultClass(this.currResultObj.getResultClass()).getFieldCount();
                    IOUtil.writeLong((DataOutputStream)this.dataSetLenStream, (long)this.offset);
                    this.offset += (long)ResultSetUtil.writeResultObject(new DataOutputStream(this.dataSetStream), this.currResultObj, colCount, this.resultSetNameSet, this.streamsWrapper.getOutputStringTable(this.getResultClass()), this.streamsWrapper.getStreamForIndex(this.getResultClass(), this.handler.getAppContext()), this.rowCount - 1, this.streamsWrapper.getStreamManager().getVersion());
                }
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }
        try {
            this.groupCalculator.registerPreviousResultObject(this.currResultObj);
            this.currResultObj = this.rowResultSet.next();
            this.groupCalculator.registerCurrentResultObject(this.currResultObj);
            this.groupCalculator.registerNextResultObject(this.rowResultSet);
            if (this.currResultObj != null) {
                this.groupCalculator.next(this.rowResultSet.getIndex());
            }
        }
        catch (DataException e) {
            this.currResultObj = null;
            throw e;
        }
        if (this.currResultObj != null) {
            ++this.rowCount;
        }
        return this.currResultObj != null;
    }

    public boolean aggrValueAvailable(String aggrName, int index) throws DataException {
        return this.groupCalculator.isAggrAtIndexAvailable(aggrName, index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DummyAggregationHelper
    implements IProgressiveAggregationHelper {
        private DummyAggregationHelper() {
        }

        @Override
        public void onRow(int startingGroupLevel, int endingGroupLevel, IResultObject ro, int currentRowIndex) throws DataException {
        }

        @Override
        public void close() throws DataException {
        }

        @Override
        public Object getLatestAggrValue(String name) throws DataException {
            return null;
        }

        @Override
        public Object getAggrValue(String name, IResultIterator ri) throws DataException {
            return null;
        }

        @Override
        public List getAggrValues(String name) throws DataException {
            return null;
        }

        @Override
        public boolean hasAggr(String name) throws DataException {
            return false;
        }

        @Override
        public Set<String> getAggrNames() throws DataException {
            return new HashSet<String>();
        }

        @Override
        public IAggrInfo getAggrInfo(String aggrName) throws DataException {
            return null;
        }
    }

    private class DummyGroupCalculator
    implements IGroupCalculator {
        private DummyGroupCalculator() {
        }

        public void registerPreviousResultObject(IResultObject previous) {
        }

        public void registerCurrentResultObject(IResultObject current) {
        }

        public void registerNextResultObject(RowResultSet rowResultSet) throws DataException {
        }

        public void next(int rowId) throws DataException {
        }

        public int getStartingGroup() throws DataException {
            if (SimpleResultSet.this.rowCount == 1) {
                return 0;
            }
            return 1;
        }

        public int getEndingGroup() throws DataException {
            if (SimpleResultSet.this.currResultObj == null) {
                return 0;
            }
            return 1;
        }

        public void close() throws DataException {
        }

        public void doSave(StreamManager manager) throws DataException {
        }

        public void setAggrHelper(IProgressiveAggregationHelper aggrHelper) throws DataException {
        }

        public boolean isAggrAtIndexAvailable(String aggrName, int currentIndex) throws DataException {
            return false;
        }

        public Integer[] getGroupInstanceIndex() {
            return new Integer[0];
        }
    }

    private class RowResultSetWithDataSetScopeAwareness
    extends RowResultSet {
        private DataSetRuntime runtime;
        private DataSetRuntime.Mode cachedMode;

        public RowResultSetWithDataSetScopeAwareness(SmartCacheRequest smartCacheRequest, DataSetRuntime runtime) {
            super(smartCacheRequest);
            this.runtime = runtime;
        }

        protected void beforeNext() throws DataException {
            this.cachedMode = this.runtime.getMode();
            this.runtime.setMode(DataSetRuntime.Mode.DataSet);
        }

        protected void afterNext() throws DataException {
            this.runtime.setMode(this.cachedMode);
        }
    }
}

