/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ConditionAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.DataAdapterUtil;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;

public class FilterAdapter
extends FilterDefinition {
    protected IModelAdapter adapter;

    public FilterAdapter(IModelAdapter adapter, FilterConditionHandle modelFilter) throws AdapterException {
        super(null);
        this.adapter = adapter;
        String filterExpr = modelFilter.getExpr();
        if (filterExpr != null) {
            String filterOpr = modelFilter.getOperator();
            if (filterOpr == null || filterOpr.length() == 0) {
                this.setExpression((IBaseExpression)adapter.adaptExpression(DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("expr"))));
            } else {
                if (!filterOpr.equals("in") && !filterOpr.equals("not-in")) {
                    String operand1 = modelFilter.getValue1();
                    String operand2 = modelFilter.getValue2();
                    Expression mainExpr = DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("expr"));
                    String exp = mainExpr.getStringExpression();
                    if (operand1 == null && operand2 == null) {
                        Pattern pattern = Pattern.compile("LOWER\\((.*?)\\)");
                        Matcher matcher = pattern.matcher(exp);
                        while (matcher.find()) {
                            exp = matcher.group(1);
                        }
                    }
                    this.setExpression((IBaseExpression)adapter.adaptConditionalExpression(new Expression((Object)exp, mainExpr.getType()), filterOpr, operand1 == null ? null : (Expression)modelFilter.getValue1ExpressionList().getListValue().get(0), DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("value2"))));
                } else {
                    List operands = modelFilter.getValue1ExpressionList().getListValue();
                    ArrayList<ScriptExpression> adaptedExpressions = new ArrayList<ScriptExpression>();
                    for (Expression expr : operands) {
                        adaptedExpressions.add(adapter.adaptExpression(expr));
                    }
                    this.setExpression((IBaseExpression)new ConditionAdapter((IScriptExpression)adapter.adaptExpression(DataAdapterUtil.getExpression(modelFilter.getExpressionProperty("expr"))), filterOpr, adaptedExpressions));
                }
                this.setUpdateAggregation(modelFilter.updateAggregation());
            }
        }
    }

    public FilterAdapter(IModelAdapter adapter, ExpressionHandle handle) throws AdapterException {
        super((IBaseExpression)adapter.adaptExpression(DataAdapterUtil.getExpression(handle)));
        this.adapter = adapter;
    }
}

