/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverLoader;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Schema;

public class ConnectionMetaData
implements Serializable {
    private static final long serialVersionUID = -4370317661507339132L;
    private String classname = null;
    private String url = null;
    private String username = null;
    private String password = null;
    private Properties properties = null;
    private String catalogname = null;
    private ArrayList schemas = null;
    private transient Connection connection = null;
    private transient DatabaseMetaData metadata = null;
    private static Logger logger = Logger.getLogger(ConnectionMetaData.class.getName());
    private long timeout;

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getUrl() {
        return this.url;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCatalogname() throws SQLException {
        if (this.catalogname == null) {
            this.catalogname = this.getConnection().getCatalog();
        }
        return this.catalogname;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.getMetaData().getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.getMetaData().getDatabaseProductVersion();
    }

    public ArrayList getSchemas() throws SQLException {
        if (this.schemas == null) {
            Thread h = new Thread(){

                public void run() {
                    try {
                        ConnectionMetaData.this.retrieveSchemas();
                    }
                    catch (SQLException sQLException) {}
                }
            };
            h.start();
            try {
                h.join(this.timeout);
            }
            catch (InterruptedException interruptedException) {}
            if (this.schemas == null) {
                this.schemas = new ArrayList();
            }
        }
        return this.schemas;
    }

    public Schema getSchema(String schemaName) throws SQLException {
        Iterator iter = this.getSchemas().iterator();
        Schema schema = null;
        while (iter.hasNext()) {
            schema = (Schema)iter.next();
            if (!schemaName.equals(schema.getName())) continue;
            return schema;
        }
        return null;
    }

    private Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connect();
        }
        return this.connection;
    }

    DatabaseMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = this.getConnection().getMetaData();
        }
        return this.metadata;
    }

    private synchronized void connect() throws SQLException {
        if ((this.connection == null || this.connection.isClosed()) && this.getClassname() != null && this.getUrl() != null) {
            if (this.getPassword() == null) {
                this.setPassword("");
            }
            this.connection = DriverLoader.getConnectionWithExceptionTip(this.classname, this.url, this.username, this.password, this.properties);
        }
    }

    private synchronized void retrieveSchemas() throws SQLException {
        if (this.schemas == null) {
            this.schemas = new ArrayList();
            Schema schema = null;
            if (this.getMetaData().supportsSchemasInTableDefinitions()) {
                ResultSet resultSet = this.getMetaData().getSchemas();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("TABLE_SCHEM");
                    schema = new Schema(this, this.timeout);
                    schema.setName(schemaName);
                    this.schemas.add(schema);
                }
            } else {
                schema = new Schema(this, this.timeout);
                this.schemas.add(schema);
            }
        }
    }

    public void clearCache() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
        if (this.schemas != null) {
            this.schemas.clear();
            this.schemas = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ConnectionMetaData castedObj = (ConnectionMetaData)o;
        return (this.classname == null ? castedObj.classname == null : this.classname.equals(castedObj.classname)) && (this.url == null ? castedObj.url == null : this.url.equals(castedObj.url)) && (this.username == null ? castedObj.username == null : this.username.equals(castedObj.username)) && (this.password == null ? castedObj.password == null : this.password.equals(castedObj.password)) && (this.properties == null ? castedObj.properties == null : this.properties.equals(castedObj.properties));
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.classname == null ? 0 : this.classname.hashCode());
        hashCode = 31 * hashCode + (this.url == null ? 0 : this.url.hashCode());
        hashCode = 31 * hashCode + (this.username == null ? 0 : this.username.hashCode());
        hashCode = 31 * hashCode + (this.password == null ? 0 : this.password.hashCode());
        hashCode = 31 * hashCode + (this.properties == null ? 0 : this.properties.hashCode());
        return hashCode;
    }

    protected void finalize() throws Throwable {
        this.clearCache();
        super.finalize();
    }
}

