/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.dialog;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Rule;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LevelStaticAttributeDialog
extends BaseDialog {
    private Text errorMessageText;
    private Text nameText;
    private Text expressionText;
    private TabularLevelHandle input;
    private RuleHandle rule;

    public LevelStaticAttributeDialog(String title) {
        super(title);
    }

    public void setInput(TabularLevelHandle input) {
        this.input = input;
    }

    public void setInput(TabularLevelHandle input, RuleHandle rule) {
        this.input = input;
        this.rule = rule;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Label nameLabel = new Label(container, 64);
        nameLabel.setText(Messages.getString("LevelStaticAttributeDialog.Label.Member"));
        nameLabel.setLayoutData((Object)new GridData());
        nameLabel.setFont(parent.getFont());
        this.nameText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 250;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LevelStaticAttributeDialog.this.checkButtonStatus();
            }
        });
        Label expressionLabel = new Label(container, 64);
        expressionLabel.setText(Messages.getString("LevelStaticAttributeDialog.Label.Expression"));
        expressionLabel.setLayoutData((Object)new GridData());
        expressionLabel.setFont(parent.getFont());
        this.expressionText = new Text(container, 2112);
        this.expressionText.setLayoutData((Object)new GridData(768));
        Button expressionButton = new Button(container, 8);
        expressionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LevelStaticAttributeDialog.this.handleExpressionButtonSelectEvent();
            }
        });
        UIUtil.setExpressionButtonImage((Button)expressionButton);
        this.errorMessageText = new Text(container, 72);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.errorMessageText.setLayoutData((Object)gd);
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        LevelStaticAttributeDialog.applyDialogFont((Control)composite);
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.LevelStaticAttributeDialog_ID");
        this.initDialog();
        return composite;
    }

    protected boolean initDialog() {
        if (this.rule != null) {
            this.nameText.setText(DEUtil.resolveNull((String)this.rule.getDisplayExpression()));
            this.expressionText.setText(DEUtil.resolveNull((String)this.rule.getRuleExpression()));
        }
        return super.initDialog();
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.checkButtonStatus();
        return bar;
    }

    private void checkButtonStatus() {
        if (this.nameText.getText().trim().length() == 0) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
                this.setErrorMessage(Messages.getString("LevelStaticAttributeDialog.Error.Message"));
            }
        } else if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }

    protected void handleExpressionButtonSelectEvent() {
        ExpressionBuilder expression = new ExpressionBuilder(this.expressionText.getText());
        expression.setExpressionProvider((IExpressionProvider)new CubeExpressionProvider((DesignElementHandle)this.input));
        if (expression.open() == 0 && expression.getResult() != null) {
            this.expressionText.setText(expression.getResult());
        }
    }

    public void setErrorMessage(String errorMessage) {
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected void okPressed() {
        if (this.rule != null) {
            if (this.nameText.getText().trim().length() > 0) {
                this.rule.setDisplayExpression(this.nameText.getText().trim());
            }
            this.rule.setRuleExpression(this.expressionText.getText().trim());
        } else {
            Rule rule = StructureFactory.createRule();
            rule.setProperty("displayExpre", (Object)this.nameText.getText().trim());
            rule.setProperty("ruleExpre", (Object)this.expressionText.getText().trim());
            try {
                this.input.getPropertyHandle("staticValues").addItem((IStructure)rule);
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
        super.okPressed();
    }
}

