/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.dialog;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeACLExpressionProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeMeasureExpressionProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.LinkToCubeExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MeasureDialog
extends TitleAreaDialog {
    private boolean isEdit = false;
    private boolean isAutoPrimaryKeyChecked = false;
    private CubeMeasureExpressionProvider provider;
    private Combo typeCombo;
    private Text expressionText;
    private Combo functionCombo;
    private Button derivedMeasureBtn;
    private Button visibilityBtn;
    private Label exprDesc;
    private TabularMeasureHandle input;
    private Text nameText;
    private static IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("dataType").getAllowedChoices().getChoices();
    private Object result;
    private IDialogHelper securityHelper;
    private IDialogHelper formatHelper;
    private IDialogHelper alignmentHelper;
    private Text displayNameText;

    public MeasureDialog(boolean newOrEdit) {
        super(UIUtil.getDefaultShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.isEdit = !newOrEdit;
    }

    private String[] getDataTypeNames() {
        IChoice[] choices = dataTypes;
        if (choices == null) {
            return new String[0];
        }
        String[] names = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            names[i] = choices[i].getName();
            ++i;
        }
        return names;
    }

    private String getDataTypeDisplayName(String name) {
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("dataType").getAllowedChoices());
    }

    private String[] getDataTypeDisplayNames() {
        IChoice[] choices = dataTypes;
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    private String[] getFunctionDisplayNames() {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    private IAggrFunction getFunctionByDisplayName(String displayName) {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return null;
        }
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getDisplayName().equals(displayName)) {
                return choices[i];
            }
            ++i;
        }
        return null;
    }

    private String getFunctionDisplayName(String function) {
        try {
            return DataUtil.getAggregationManager().getAggregation(function).getDisplayName();
        }
        catch (BirtException e) {
            ExceptionUtil.handle((Throwable)e);
            return null;
        }
    }

    private IAggrFunction[] getFunctions() {
        try {
            List aggrInfoList = DataUtil.getAggregationManager().getAggregations(2);
            return aggrInfoList.toArray(new IAggrFunction[0]);
        }
        catch (BirtException e) {
            ExceptionUtil.handle((Throwable)e);
            return new IAggrFunction[0];
        }
    }

    public void setInput(TabularMeasureHandle input) {
        this.input = input;
    }

    public void setAutoPrimaryKeyStatus(boolean isChecked) {
        this.isAutoPrimaryKeyChecked = isChecked;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.MeasureDialog_ID");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginWidth = 20;
        contents.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(70);
        contents.setLayoutData((Object)data);
        this.createMeasureArea(contents);
        this.createVisibilityGroup(contents);
        WidgetUtil.createGridPlaceholder((Composite)contents, (int)1, (boolean)true);
        this.initMeasureDialog();
        return contents;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Messages.getString("MeasureDialog.Title.Description"));
        this.setMessage(Messages.getString("MeasureDialog.Text.Description"));
        return control;
    }

    private void initMeasureDialog() {
        this.typeCombo.setItems(this.getDataTypeDisplayNames());
        this.functionCombo.setItems(this.getFunctionDisplayNames());
        if (!this.isEdit) {
            if (this.typeCombo.getItemCount() > 0) {
                this.typeCombo.select(0);
            }
            if (this.functionCombo.getItemCount() > 0) {
                this.functionCombo.select(0);
            }
            this.handleFunctionSelectEvent();
        } else {
            try {
                this.functionCombo.setText(this.getFunctionDisplayName(DataAdapterUtil.adaptModelAggregationType((String)this.input.getFunction())) == null ? "" : this.getFunctionDisplayName(DataAdapterUtil.adaptModelAggregationType((String)this.input.getFunction())));
            }
            catch (AdapterException e) {
                ExceptionUtil.handle((Throwable)e);
            }
            ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionText, (Object)this.input, (String)"measureExpression");
            this.nameText.setText(this.input.getName() == null ? "" : this.input.getName());
            this.displayNameText.setText(this.input.getDisplayName() == null ? "" : this.input.getDisplayName());
            this.handleFunctionSelectEvent();
            this.typeCombo.setText(this.getDataTypeDisplayName(this.input.getDataType()) == null ? "" : this.getDataTypeDisplayName(this.input.getDataType()));
            this.derivedMeasureBtn.setSelection(this.input.isCalculated());
            this.updateDerivedMeasureStatus();
        }
        if (this.formatHelper != null) {
            if (this.typeCombo.getSelectionIndex() > -1) {
                this.formatHelper.setProperty("Format Value Type", (Object)this.getDataTypeNames()[this.typeCombo.getSelectionIndex()]);
            }
            this.formatHelper.update(true);
        }
        if (this.alignmentHelper != null) {
            if (this.input.getAlignment() != null) {
                this.alignmentHelper.setProperty("Alignment Value", (Object)this.input.getAlignment());
            } else if (!this.isEdit && this.input.getDataType() != null) {
                if (this.isNumber(this.input.getDataType())) {
                    this.alignmentHelper.setProperty("Alignment Value", (Object)"right");
                } else {
                    this.alignmentHelper.setProperty("Alignment Value", (Object)"left");
                }
            }
            this.alignmentHelper.update(true);
        }
    }

    private boolean isNumber(String dataType) {
        return "decimal".equals(dataType) || "float".equals(dataType) || "integer".equals(dataType);
    }

    public Object getResult() {
        return this.result;
    }

    protected void okPressed() {
        try {
            if (!this.isEdit) {
                TabularMeasureHandle measure;
                if (this.input == null) {
                    measure = DesignElementFactory.getInstance().newTabularMeasure(this.nameText.getText());
                    if (this.displayNameText.getText().trim().length() > 0) {
                        measure.setDisplayName(this.displayNameText.getText().trim());
                    } else {
                        measure.setDisplayName(null);
                    }
                } else {
                    measure = this.input;
                    this.input.setName(this.nameText.getText());
                    if (this.displayNameText.getText().trim().length() > 0) {
                        this.input.setDisplayName(this.displayNameText.getText().trim());
                    } else {
                        this.input.setDisplayName(null);
                    }
                }
                measure.setCalculated(this.derivedMeasureBtn.getSelection());
                if (this.derivedMeasureBtn.getSelection()) {
                    measure.setFunction(null);
                } else {
                    measure.setFunction(this.getFunctions()[this.functionCombo.getSelectionIndex()].getName());
                }
                measure.setDataType(this.getDataTypeNames()[this.typeCombo.getSelectionIndex()]);
                if (this.expressionText.isEnabled()) {
                    ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionText, (Object)measure, (String)"measureExpression");
                }
                if (!this.derivedMeasureBtn.getSelection()) {
                    if (this.securityHelper != null) {
                        this.securityHelper.validate();
                        measure.setExpressionProperty("ACLExpression", (Expression)this.securityHelper.getProperty("Security Expression Property"));
                    }
                } else {
                    measure.setExpressionProperty("ACLExpression", null);
                }
                if (this.alignmentHelper != null) {
                    measure.setAlignment((String)this.alignmentHelper.getProperty("Alignment Value"));
                }
                if (this.formatHelper != null && this.formatHelper.getProperty("Format Value Result") instanceof Object[]) {
                    Object[] formatValue = (Object[])this.formatHelper.getProperty("Format Value Result");
                    Object value = measure.getProperty("format");
                    if (value == null) {
                        FormatValue formatValueToSet = new FormatValue();
                        formatValueToSet.setCategory((String)formatValue[0]);
                        formatValueToSet.setPattern((String)formatValue[1]);
                        formatValueToSet.setLocale((ULocale)formatValue[2]);
                        measure.setProperty("format", (Object)formatValueToSet);
                    } else {
                        PropertyHandle propHandle = measure.getPropertyHandle("format");
                        FormatValue formatValueToSet = (FormatValue)value;
                        FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                        formatHandle.setCategory((String)formatValue[0]);
                        formatHandle.setPattern((String)formatValue[1]);
                        formatHandle.setLocale((ULocale)formatValue[2]);
                    }
                }
                measure.setVisible(!this.visibilityBtn.getSelection());
                this.result = measure;
            } else {
                this.input.setName(this.nameText.getText());
                if (this.displayNameText.getText().trim().length() > 0) {
                    this.input.setDisplayName(this.displayNameText.getText().trim());
                } else {
                    this.input.setDisplayName(null);
                }
                this.input.setCalculated(this.derivedMeasureBtn.getSelection());
                if (this.derivedMeasureBtn.getSelection()) {
                    this.input.setFunction(null);
                } else {
                    this.input.setFunction(this.getFunctions()[this.functionCombo.getSelectionIndex()].getName());
                }
                this.input.setDataType(this.getDataTypeNames()[this.typeCombo.getSelectionIndex()]);
                if (this.expressionText.isEnabled()) {
                    ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionText, (Object)this.input, (String)"measureExpression");
                } else {
                    this.input.setMeasureExpression(null);
                }
                if (!this.derivedMeasureBtn.getSelection()) {
                    if (this.securityHelper != null) {
                        this.securityHelper.validate();
                        this.input.setExpressionProperty("ACLExpression", (Expression)this.securityHelper.getProperty("Security Expression Property"));
                    }
                } else {
                    this.input.setExpressionProperty("ACLExpression", null);
                }
                if (this.alignmentHelper != null) {
                    this.input.setAlignment((String)this.alignmentHelper.getProperty("Alignment Value"));
                }
                if (this.formatHelper != null && this.formatHelper.getProperty("Format Value Result") instanceof Object[]) {
                    Object[] formatValue = (Object[])this.formatHelper.getProperty("Format Value Result");
                    Object value = this.input.getProperty("format");
                    if (value == null) {
                        FormatValue formatValueToSet = new FormatValue();
                        formatValueToSet.setCategory((String)formatValue[0]);
                        formatValueToSet.setPattern((String)formatValue[1]);
                        formatValueToSet.setLocale((ULocale)formatValue[2]);
                        this.input.setProperty("format", (Object)formatValueToSet);
                    } else {
                        PropertyHandle propHandle = this.input.getPropertyHandle("format");
                        FormatValue formatValueToSet = (FormatValue)value;
                        FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                        formatHandle.setCategory((String)formatValue[0]);
                        formatHandle.setPattern((String)formatValue[1]);
                        formatHandle.setLocale((ULocale)formatValue[2]);
                    }
                }
                this.input.setVisible(!this.visibilityBtn.getSelection());
                this.result = this.input;
            }
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
            return;
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.checkOkButtonStatus();
    }

    private Composite createMeasureArea(Composite parent) {
        this.getShell().setText(Messages.getString("MeasureDialog.Title.Property"));
        Group group = new Group(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        Label nameLabel = new Label((Composite)group, 0);
        nameLabel.setText(Messages.getString("MeasureDialog.Label.Name"));
        this.nameText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        Label displayNameLabel = new Label((Composite)group, 0);
        displayNameLabel.setText(Messages.getString("MeasureDialog.Label.DisplayName"));
        this.displayNameText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.displayNameText.setLayoutData((Object)gd);
        this.displayNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        new Label((Composite)group, 0);
        this.derivedMeasureBtn = new Button((Composite)group, 32);
        this.derivedMeasureBtn.setText(Messages.getString("MeasureDialog.Label.DerivedMeasure"));
        this.derivedMeasureBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MeasureDialog.this.updateDerivedMeasureStatus();
                if (!MeasureDialog.this.derivedMeasureBtn.getSelection()) {
                    MeasureDialog.this.handleTypeSelectEvent();
                }
            }
        });
        new Label((Composite)group, 0);
        Label functionLabel = new Label((Composite)group, 0);
        functionLabel.setText(Messages.getString("MeasureDialog.Label.Function"));
        this.functionCombo = new Combo((Composite)group, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.functionCombo.setLayoutData((Object)gd);
        this.functionCombo.setVisibleItemCount(30);
        this.functionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MeasureDialog.this.handleFunctionSelectEvent();
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        this.functionCombo.setEnabled(!this.derivedMeasureBtn.getSelection() && !this.isAutoPrimaryKeyChecked);
        Label typeLabel = new Label((Composite)group, 0);
        typeLabel.setText(Messages.getString("MeasureDialog.Label.DataType"));
        this.typeCombo = new Combo((Composite)group, 2056);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.typeCombo.setLayoutData((Object)gd);
        this.typeCombo.setVisibleItemCount(30);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MeasureDialog.this.derivedMeasureBtn.getSelection()) {
                    MeasureDialog.this.handleTypeSelectEvent();
                }
                MeasureDialog.this.checkOkButtonStatus();
                if (MeasureDialog.this.formatHelper != null) {
                    if (MeasureDialog.this.typeCombo.getSelectionIndex() > -1) {
                        MeasureDialog.this.formatHelper.setProperty("Format Value Type", (Object)MeasureDialog.this.getDataTypeNames()[MeasureDialog.this.typeCombo.getSelectionIndex()]);
                    }
                    MeasureDialog.this.formatHelper.update(true);
                }
            }
        });
        Label expressionLabel = new Label((Composite)group, 0);
        expressionLabel.setText(Messages.getString("MeasureDialog.Label.Expression"));
        this.expressionText = new Text((Composite)group, 2112);
        gd = new GridData(768);
        this.expressionText.setLayoutData((Object)gd);
        this.expressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MeasureDialog.this.checkOkButtonStatus();
            }
        });
        this.provider = new CubeMeasureExpressionProvider(this.input, this.input.isCalculated());
        ExpressionButtonUtil.createExpressionButton((Composite)group, (Control)this.expressionText, (IExpressionProvider)this.provider, (Object)this.input);
        new Label((Composite)group, 0);
        this.exprDesc = new Label((Composite)group, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        this.exprDesc.setLayoutData((Object)gd);
        this.exprDesc.setText(Messages.getString(Messages.getString(this.derivedMeasureBtn.getSelection() ? "MeasureDialog.Label.ExprDesc.Derived" : "MeasureDialog.Label.ExprDesc")));
        this.exprDesc.setForeground(ColorManager.getColor((int)128, (int)128, (int)128));
        this.createSecurityPart((Composite)group);
        this.createHyperLinkPart((Composite)group);
        this.createFormatPart((Composite)group);
        this.createAlignmentPart((Composite)group);
        return group;
    }

    private Composite createVisibilityGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(Messages.getString("MeasureDialog.Label.Visibility.Group"));
        this.visibilityBtn = new Button((Composite)group, 32);
        this.visibilityBtn.setText(Messages.getString("MeasureDialog.Label.Visibility"));
        this.visibilityBtn.setSelection(!this.input.isVisible());
        return group;
    }

    private IDialogHelper createHyperLinkPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelper hyperLinkHelper;
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && (hyperLinkHelper = helperProvider.createHelper((Object)this, "HyperLink Helper")) != null) {
                    hyperLinkHelper.setProperty("HyperLink Label", (Object)Messages.getString("MeasureDialog.Label.LinkTo"));
                    hyperLinkHelper.setProperty("HyperLink Button Text", (Object)Messages.getString("MeasureDialog.Button.Text.Edit"));
                    hyperLinkHelper.setProperty("HyperLink Report Item Handle", (Object)this.input);
                    hyperLinkHelper.setProperty("HyperLink Report Item Expression Provider", (Object)new LinkToCubeExpressionProvider((DesignElementHandle)this.input));
                    hyperLinkHelper.createContent(parent);
                    hyperLinkHelper.addListener(24, new Listener(){

                        public void handleEvent(Event event) {
                            hyperLinkHelper.update(false);
                        }
                    });
                    hyperLinkHelper.update(true);
                    return hyperLinkHelper;
                }
                ++i;
            }
        }
        return null;
    }

    private IDialogHelper createFormatPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null) {
                    this.formatHelper = helperProvider.createHelper((Object)this, "Format Helper");
                    if (this.formatHelper != null) {
                        this.formatHelper.setProperty("Format Label", (Object)Messages.getString("MeasureDialog.Label.Format"));
                        this.formatHelper.setProperty("Format Button Text", (Object)Messages.getString("MeasureDialog.Button.Format.Edit"));
                        PropertyHandle propHandle = this.input.getPropertyHandle("format");
                        if (this.input.getProperty("format") != null) {
                            Object value = this.input.getProperty("format");
                            FormatValue formatValueToSet = (FormatValue)value;
                            FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                            this.formatHelper.setProperty("Format Value", (Object)formatHandle);
                        }
                        this.formatHelper.createContent(parent);
                        this.formatHelper.update(true);
                        return this.formatHelper;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private IDialogHelper createAlignmentPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null) {
                    this.alignmentHelper = helperProvider.createHelper((Object)this, "Alignment Helper");
                    if (this.alignmentHelper != null) {
                        this.alignmentHelper.setProperty("Alignment Label", (Object)Messages.getString("MeasureDialog.Label.Alignment"));
                        this.alignmentHelper.setProperty("Alignment Value", (Object)this.input.getAlignment());
                        this.alignmentHelper.createContent(parent);
                        this.alignmentHelper.update(true);
                        return this.alignmentHelper;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private void createSecurityPart(Composite parent) {
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.input, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && this.securityHelper == null) {
                    this.securityHelper = helperProvider.createHelper((Object)this, "Security Helper");
                    if (this.securityHelper != null) {
                        this.securityHelper.setProperty("Security Label", (Object)Messages.getString("MeasureDialog.Access.Control.List.Expression"));
                        this.securityHelper.setProperty("Security Expression Context", (Object)this.input);
                        this.securityHelper.setProperty("Security Expression Provider", (Object)new CubeACLExpressionProvider((DesignElementHandle)this.input));
                        this.securityHelper.setProperty("Security Expression Property", (Object)this.input.getACLExpression());
                        this.securityHelper.createContent(parent);
                        this.securityHelper.addListener(24, new Listener(){

                            public void handleEvent(Event event) {
                                MeasureDialog.this.securityHelper.update(false);
                            }
                        });
                        this.securityHelper.update(true);
                    }
                }
                ++i;
            }
        }
    }

    protected void handleTypeSelectEvent() {
        IAggrFunction function = this.getFunctionByDisplayName(this.functionCombo.getText());
        if (function == null) {
            return;
        }
        try {
            String recommendType = this.getDataTypeDisplayName(DataAdapterUtil.adapterToModelDataType((int)DataUtil.getAggregationManager().getAggregation(function.getName()).getDataType()));
            if (!this.typeCombo.getText().equals(recommendType) && this.typeCombo.indexOf(recommendType) != -1 && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("MeasureDialog.MessageDialog.Title"), (String)Messages.getFormattedString("MeasureDialog.MessageDialog.Message", new Object[]{recommendType}))) {
                this.typeCombo.setText(recommendType);
            }
        }
        catch (BirtException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    private void handleFunctionSelectEvent() {
        IAggrFunction function = this.getFunctionByDisplayName(this.functionCombo.getText());
        if (function == null) {
            return;
        }
        try {
            this.typeCombo.setText(this.getDataTypeDisplayName(DataAdapterUtil.adapterToModelDataType((int)DataUtil.getAggregationManager().getAggregation(function.getName()).getDataType())));
        }
        catch (BirtException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        int parameterLength = function.getParameterDefn().length;
        this.expressionText.setEnabled(parameterLength > 0);
        ((ExpressionButton)this.expressionText.getData("exprButton")).setEnabled(parameterLength > 0);
    }

    protected void checkOkButtonStatus() {
        IParameterDefn param;
        IAggrFunction function;
        if (this.nameText.getText() == null || this.nameText.getText().trim().equals("") || this.functionCombo.getSelectionIndex() == -1 || this.typeCombo.getSelectionIndex() == -1) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
                this.setMessage(null);
                this.setErrorMessage(Messages.getString("MeasureDialog.Message.BlankName"));
                return;
            }
        } else if (!UIUtil.validateDimensionName((String)this.nameText.getText()) && this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
            this.setMessage(null);
            this.setErrorMessage(Messages.getString("MeasureDialog.Message.NumericName"));
            return;
        }
        if (!((function = this.getFunctionByDisplayName(this.functionCombo.getText())) == null || function.getParameterDefn().length <= 0 || (param = function.getParameterDefn()[0]).isOptional() || this.expressionText.getText() != null && this.expressionText.getText().trim().length() != 0 || this.getButton(0) == null)) {
            this.getButton(0).setEnabled(false);
            this.setMessage(null);
            this.setErrorMessage(Messages.getString("MeasureDialog.Message.BlankExpression"));
            return;
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(Messages.getString("MeasureDialog.Text.Description"));
        }
    }

    private void updateDerivedMeasureStatus() {
        this.functionCombo.setEnabled(!this.derivedMeasureBtn.getSelection() && !this.isAutoPrimaryKeyChecked);
        if (this.securityHelper != null) {
            this.securityHelper.setProperty("Security Expression Enable", (Object)(!this.derivedMeasureBtn.getSelection() ? 1 : 0));
            this.securityHelper.update(true);
        }
        this.exprDesc.setText(Messages.getString(this.derivedMeasureBtn.getSelection() ? "MeasureDialog.Label.ExprDesc.Derived" : "MeasureDialog.Label.ExprDesc"));
        this.provider.setDerivedMeasure(this.derivedMeasureBtn.getSelection());
    }
}

