/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.eclipse.birt.core.ui.swt.custom.TextCombo;
import org.eclipse.birt.core.ui.swt.custom.TextComboViewer;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.outline.ScriptElementNode;
import org.eclipse.birt.report.designer.core.model.views.outline.ScriptObjectNode;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.script.IScriptEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.script.IScriptMethodInfo;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSExpListProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSSubFunctionListProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.script.ScriptEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.script.ScriptParser;
import org.eclipse.birt.report.designer.internal.ui.editors.script.TreeViewPalettePage;
import org.eclipse.birt.report.designer.internal.ui.script.JSSyntaxContext;
import org.eclipse.birt.report.designer.internal.ui.script.ScriptValidator;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewPage;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewTreeViewerPage;
import org.eclipse.birt.report.designer.internal.ui.views.outline.DesignerOutlinePage;
import org.eclipse.birt.report.designer.internal.ui.views.property.ReportPropertySheetPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.scripts.IScriptContextInfo;
import org.eclipse.birt.report.designer.ui.scripts.IScriptContextProvider;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributeViewPage;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.text.undo.DocumentUndoEvent;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoListener;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class JSEditor
extends EditorPart
implements IColleague {
    protected static Logger logger = Logger.getLogger(JSEditor.class.getName());
    private static final String NO_EXPRESSION = Messages.getString((String)"JSEditor.Display.NoExpression");
    static final String METHOD_DISPLAY_INDENT = "  ";
    static final String VIEWER_CATEGORY_KEY = "Category";
    static final String VIEWER_CATEGORY_CONTEXT = "context";
    private IEditorPart editingDomainEditor;
    Combo cmbExpList = null;
    TextCombo cmbSubFunctions = null;
    ComboViewer cmbExprListViewer;
    TextComboViewer cmbSubFunctionsViewer;
    private IPropertyDefn cmbItemLastSelected = null;
    private boolean editorUIEnabled = true;
    private ToolBar validateTool = null;
    private ToolItem butReset = null;
    private ToolItem butValidate = null;
    private ToolItem butHelp = null;
    private Label validateIcon = null;
    private Composite mainPane = null;
    private Composite descriptionPane = null;
    private Text descriptionText = null;
    private Label ano;
    private final HashMap selectionMap = new HashMap();
    private boolean isModified;
    private Object editObject;
    private boolean isSaveScript = false;
    public TreeViewPalettePage palettePage = new TreeViewPalettePage();
    private IScriptEditor scriptEditor;
    private ScriptValidator scriptValidator = null;
    private boolean isTextListenerEnable = true;
    private int cleanPoint = -1;
    private boolean undoing = false;
    private final IDocumentListener documentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (JSEditor.this.isTextListenerEnable) {
                JSEditor.this.markDirty();
            }
            String text = JSEditor.this.getEditorText();
            boolean butEnabled = JSEditor.this.editorUIEnabled && text != null && text.length() > 0;
            JSEditor.this.butReset.setEnabled(butEnabled);
            JSEditor.this.butValidate.setEnabled(butEnabled);
        }
    };
    private final IDocumentUndoListener undoListener = new IDocumentUndoListener(){
        private int lastClearPoint = -1;

        public void documentUndoNotification(DocumentUndoEvent event) {
            if (event == null) {
                return;
            }
            int type = event.getEventType();
            boolean undone = (type & 4) != 0;
            boolean redone = (type & 8) != 0;
            JSEditor.this.undoing = (type & 3) != 0;
            if (JSEditor.this.undoing || !undone && !redone) {
                return;
            }
            if (undone) {
                this.lastClearPoint = JSEditor.this.cleanPoint;
                if (JSEditor.this.cleanPoint != JSEditor.this.getUndoLevel() - 1) {
                    return;
                }
            } else if (redone) {
                if (JSEditor.this.cleanPoint < 0) {
                    JSEditor.this.cleanPoint = this.lastClearPoint;
                }
                if (JSEditor.this.cleanPoint != JSEditor.this.getUndoLevel() + 1) {
                    return;
                }
            }
            JSEditor.this.setIsModified(false);
            ((IFormPage)JSEditor.this.getParentEditor()).getEditor().editorDirtyStateChanged();
            JSEditor.this.firePropertyChange(257);
        }
    };

    public JSEditor(IEditorPart parent) {
        this.editingDomainEditor = parent;
        this.setSite((IWorkbenchPartSite)parent.getEditorSite());
        this.scriptEditor = this.createScriptEditor();
    }

    protected IScriptEditor createScriptEditor() {
        return new ScriptEditor(this.getParentEditor());
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveModel();
    }

    public void doSave(IProgressMonitor monitor, boolean chnageText) {
        this.isSaveScript = !chnageText;
        this.saveModel();
        this.isSaveScript = false;
    }

    public boolean isDirty() {
        return this.isCodeModified();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void dispose() {
        this.selectionMap.clear();
        this.editingDomainEditor = null;
        if (this.scriptEditor != null) {
            this.scriptEditor.dispose();
            this.scriptEditor = null;
        }
        super.dispose();
        ((MultiPageEditorSite)this.getSite()).dispose();
    }

    protected static String convertToParameterName(String fullName) {
        fullName = fullName.substring(fullName.lastIndexOf(46) + 1);
        int upCase = 0;
        TreeMap<Integer, Integer> caps = new TreeMap<Integer, Integer>();
        int i = 0;
        while (i < fullName.length()) {
            char character = fullName.charAt(i);
            if (Character.isUpperCase(character)) {
                ++upCase;
                caps.put(i, Integer.valueOf(character));
            }
            ++i;
        }
        if (upCase > 2) {
            StringBuffer result = new StringBuffer();
            Iterator iter = caps.values().iterator();
            while (iter.hasNext()) {
                result.append((char)((Integer)iter.next()).intValue());
            }
            return result.toString().toLowerCase();
        }
        return String.valueOf(fullName.substring(0, 1).toLowerCase()) + fullName.substring(1);
    }

    private void updateExtensionScriptContext(Object[] adapters, JSSyntaxContext context, String contextName, String methodName) {
        if (adapters == null) {
            return;
        }
        Object[] objectArray = adapters;
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptContextInfo[] infos;
            Object adapt = objectArray[n2];
            IScriptContextProvider contextProvider = (IScriptContextProvider)adapt;
            if (contextProvider != null && (infos = methodName == null ? contextProvider.getScriptContext(contextName) : contextProvider.getScriptContext(contextName, methodName)) != null) {
                IScriptContextInfo[] iScriptContextInfoArray = infos;
                int n3 = infos.length;
                int n4 = 0;
                while (n4 < n3) {
                    IScriptContextInfo info = iScriptContextInfoArray[n4];
                    if (info != null) {
                        String name = info.getName();
                        IClassInfo type = info.getType();
                        if (name != null && type != null) {
                            context.setVariable(name, type);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void updateScriptContext(DesignElementHandle handle, String method) {
        ExtendedItemHandle exHandle;
        List mtds;
        List args = DEUtil.getDesignElementMethodArgumentsInfo((DesignElementHandle)handle, (String)method);
        JSSyntaxContext context = this.scriptEditor.getContext();
        context.clear();
        for (IArgumentInfo element : args) {
            String type;
            String name = element.getName();
            if (context.setVariable(name, type = element.getType())) continue;
            context.setVariable(name, element.getClassType());
        }
        Object[] adapters = ElementAdapterManager.getAdapters((Object)handle, IScriptContextProvider.class);
        this.updateExtensionScriptContext(adapters, context, method, null);
        if (handle instanceof ExtendedItemHandle && (mtds = (exHandle = (ExtendedItemHandle)handle).getMethods(method)) != null && mtds.size() > 0) {
            int i = 0;
            while (i < mtds.size()) {
                IMethodInfo mi = (IMethodInfo)mtds.get(i);
                Iterator itr = mi.argumentListIterator();
                while (itr.hasNext()) {
                    IArgumentInfoList ailist = (IArgumentInfoList)itr.next();
                    Iterator argItr = ailist.argumentsIterator();
                    while (argItr.hasNext()) {
                        IArgumentInfo aiinfo = (IArgumentInfo)argItr.next();
                        String argName = aiinfo.getName();
                        IClassInfo ci = aiinfo.getClassType();
                        if (argName == null || argName.length() == 0) {
                            argName = JSEditor.convertToParameterName(ci.getName());
                        }
                        context.setVariable(argName, ci);
                    }
                }
                if (mi.getName() != null) {
                    this.updateExtensionScriptContext(adapters, context, method, mi.getName());
                }
                ++i;
            }
        }
    }

    public void createPartControl(Composite parent) {
        IDocument document;
        Composite child = this.initEditorLayout(parent);
        this.cmbExprListViewer = new ComboViewer(this.cmbExpList);
        JSExpListProvider provider = new JSExpListProvider();
        this.cmbExprListViewer.setContentProvider((IContentProvider)provider);
        this.cmbExprListViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.cmbExprListViewer.setData(VIEWER_CATEGORY_KEY, (Object)VIEWER_CATEGORY_CONTEXT);
        JSSubFunctionListProvider subProvider = new JSSubFunctionListProvider(this);
        this.cmbExprListViewer.addSelectionChangedListener((ISelectionChangedListener)subProvider);
        this.cmbSubFunctions.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                JSEditor.this.cmbSubFunctions.deselectAll();
                ScriptParser parser = new ScriptParser(JSEditor.this.getEditorText());
                Collection<IScriptMethodInfo> coll = parser.getAllMethodInfo();
                for (IScriptMethodInfo mtd : coll) {
                    JSEditor.this.cmbSubFunctions.markSelection(JSEditor.METHOD_DISPLAY_INDENT + mtd.getName());
                }
            }
        });
        this.cmbSubFunctionsViewer = new TextComboViewer(this.cmbSubFunctions);
        this.cmbSubFunctionsViewer.setContentProvider((IContentProvider)subProvider);
        this.cmbSubFunctionsViewer.setLabelProvider((IBaseLabelProvider)subProvider);
        this.cmbSubFunctionsViewer.addSelectionChangedListener((ISelectionChangedListener)subProvider);
        Object model = this.getModel();
        if (model != null) {
            this.cmbExpList.setVisible(true);
            this.cmbSubFunctions.setVisible(true);
            this.setComboViewerInput(model);
        } else {
            this.setComboViewerInput(Messages.getString((String)"JSEditor.Input.trial"));
        }
        this.cmbExprListViewer.addSelectionChangedListener((ISelectionChangedListener)this.palettePage.getSupport());
        this.cmbExprListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] sel;
                ISelection selection = event.getSelection();
                if (selection != null && (sel = ((IStructuredSelection)selection).toArray()).length == 1 && sel[0] instanceof IPropertyDefn) {
                    DesignElementHandle desHandle = (DesignElementHandle)JSEditor.this.cmbExprListViewer.getInput();
                    JSEditor.this.saveModel();
                    IPropertyDefn elePropDefn = (IPropertyDefn)sel[0];
                    JSEditor.this.cmbItemLastSelected = elePropDefn;
                    JSEditor.this.setEditorText(desHandle.getStringProperty(elePropDefn.getName()));
                    JSEditor.this.selectionMap.put(JSEditor.this.getModel(), selection);
                    String method = JSEditor.this.cmbItemLastSelected.getName();
                    JSEditor.this.updateScriptContext(desHandle, method);
                    JSEditor.this.updateMethodDescription(method);
                    JSEditor.this.refreshAll();
                }
            }
        });
        this.scriptEditor.createPartControl(child);
        this.scriptValidator = new ScriptValidator((ISourceViewer)this.getViewer());
        this.disableEditor();
        SourceViewer viewer = this.getViewer();
        IDocument iDocument = document = viewer == null ? null : viewer.getDocument();
        if (document != null) {
            IDocumentUndoManager undoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
            if (undoManager != null) {
                undoManager.addDocumentUndoListener(this.undoListener);
            }
            document.addDocumentListener(this.documentListener);
        }
    }

    public void connectRoot(ModuleHandle root) {
        if (root == null) {
            root = SessionHandleAdapter.getInstance().getReportDesignHandle();
        }
        SessionHandleAdapter.getInstance().getMediator(root).addColleague((IColleague)this);
    }

    public void disConnectRoot(ModuleHandle root) {
        if (root == null) {
            root = SessionHandleAdapter.getInstance().getReportDesignHandle();
        }
        SessionHandleAdapter.getInstance().getMediator(root).removeColleague((IColleague)this);
    }

    private void setTextListenerEnable(boolean enabled) {
        this.isTextListenerEnable = enabled;
    }

    public Object getModel() {
        return this.editObject;
    }

    public IEditorPart getParentEditor() {
        return this.editingDomainEditor;
    }

    private void updateAnnotationLabel(Object handle) {
        String name = ProviderFactory.createProvider((Object)handle).getNodeDisplayName(handle);
        if (name == null) {
            this.ano.setText("");
        } else {
            this.ano.setText(name);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ITextEditor.class)) {
            if (this.scriptEditor instanceof ITextEditor) {
                return this.scriptEditor;
            }
            return null;
        }
        if (adapter == ActionRegistry.class) {
            return this.scriptEditor.getActionRegistry();
        }
        if (adapter == PalettePage.class) {
            if (this.cmbExprListViewer != null) {
                this.cmbExprListViewer.addSelectionChangedListener((ISelectionChangedListener)this.palettePage.getSupport());
            }
            this.palettePage.setViewer(this.getViewer());
            return this.palettePage;
        }
        if (adapter == IContentOutlinePage.class) {
            DesignerOutlinePage outlinePage = new DesignerOutlinePage(SessionHandleAdapter.getInstance().getReportDesignHandle());
            return outlinePage;
        }
        if (adapter == IPropertySheetPage.class) {
            ReportPropertySheetPage sheetPage = new ReportPropertySheetPage(SessionHandleAdapter.getInstance().getReportDesignHandle());
            return sheetPage;
        }
        if (adapter == DataViewPage.class) {
            DataViewTreeViewerPage page = new DataViewTreeViewerPage(SessionHandleAdapter.getInstance().getReportDesignHandle());
            return page;
        }
        if (adapter == AttributeViewPage.class) {
            AttributeViewPage page = new AttributeViewPage();
            return page;
        }
        if (adapter == ITextEditor.class) {
            return this.scriptEditor;
        }
        return super.getAdapter(adapter);
    }

    protected PropertyHandle getPropertyHandle() {
        if (this.editObject instanceof DesignElementHandle) {
            DesignElementHandle desHdl = (DesignElementHandle)this.editObject;
            if (this.cmbItemLastSelected != null) {
                return desHdl.getPropertyHandle(this.cmbItemLastSelected.getName());
            }
        }
        return null;
    }

    private Composite initEditorLayout(Composite parent) {
        this.mainPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.mainPane.setLayout((Layout)layout);
        this.createController(this.mainPane);
        this.createDescriptionPane(this.mainPane);
        Composite editorPane = new Composite(this.mainPane, 0);
        GridData layoutData = new GridData(1808);
        layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        editorPane.setLayout((Layout)layout);
        editorPane.setLayoutData((Object)layoutData);
        final Composite sep = new Composite(editorPane, 0);
        layoutData = new GridData(768);
        layoutData.heightHint = 1;
        sep.setLayoutData((Object)layoutData);
        sep.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle rect = sep.getBounds();
                gc.setForeground(ReportColorConstants.DarkGrayForground);
                gc.drawLine(0, 0, rect.width, 0);
            }
        });
        Composite jsEditorContainer = new Composite(editorPane, 0);
        layoutData = new GridData(1808);
        jsEditorContainer.setLayoutData((Object)layoutData);
        jsEditorContainer.setLayout((Layout)new FillLayout());
        return jsEditorContainer;
    }

    private void createController(Composite parent) {
        Composite barPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout(8, false);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        GridData gdata = new GridData(768);
        barPane.setLayout((Layout)layout);
        barPane.setLayoutData((Object)gdata);
        this.initScriptLabel(barPane);
        this.initComboBoxes(barPane);
        Composite toolPane = new Composite(barPane, 0);
        layout = new GridLayout(3, false);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        toolPane.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = 6;
        toolPane.setLayoutData((Object)layoutData);
        ToolBar toolBar = new ToolBar(toolPane, 0x800000);
        this.butReset = new ToolItem(toolBar, 0);
        this.butReset.setImage(ReportPlatformUIImages.getImage((String)"Script Reset"));
        this.butReset.setToolTipText(Messages.getString((String)"JSEditor.Button.Reset"));
        this.butReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceViewer viewer = JSEditor.this.getViewer();
                if (viewer != null) {
                    viewer.getTextWidget().setText("");
                    JSEditor.this.refreshAll();
                    JSEditor.this.setFocus();
                }
            }
        });
        this.butHelp = new ToolItem(toolBar, 32);
        this.butHelp.setImage(ReportPlatformUIImages.getImage((String)"Script Help"));
        this.butHelp.setToolTipText(Messages.getString((String)"JSEditor.Button.Help"));
        this.butHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSEditor.this.refreshAll();
            }
        });
        this.validateTool = new ToolBar(toolPane, 0x800000);
        layoutData = new GridData();
        this.validateTool.setLayoutData((Object)layoutData);
        new ToolItem(this.validateTool, 2);
        this.butValidate = new ToolItem(this.validateTool, 0);
        this.butValidate.setImage(ReportPlatformUIImages.getImage((String)"Validate Expression"));
        this.butValidate.setToolTipText(Messages.getString((String)"JSEditor.Button.Validate"));
        this.butValidate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSEditor.this.doValidate();
                JSEditor.this.refreshAll();
            }
        });
        this.validateIcon = new Label(toolPane, 0);
        Label column = new Label(barPane, 514);
        layoutData = new GridData();
        layoutData.heightHint = 20;
        column.setLayoutData((Object)layoutData);
        this.ano = new Label(barPane, 0);
        layoutData = new GridData(772);
        this.ano.setLayoutData((Object)layoutData);
    }

    private void createDescriptionPane(Composite parent) {
        this.descriptionPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData layoutData = new GridData(768);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        this.descriptionPane.setLayout((Layout)layout);
        this.descriptionPane.setLayoutData((Object)layoutData);
        final Composite headerLine = new Composite(this.descriptionPane, 0);
        layoutData = new GridData(768);
        layoutData.heightHint = 3;
        headerLine.setLayoutData((Object)layoutData);
        headerLine.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle rect = headerLine.getBounds();
                gc.setForeground(ReportColorConstants.DarkShadowLineColor);
                gc.drawLine(0, 0, rect.width, 0);
            }
        });
        layoutData = new GridData(768);
        this.descriptionText = new Text(this.descriptionPane, 72);
        this.descriptionText.setLayoutData((Object)layoutData);
    }

    protected void hideValidateButtonIcon() {
        this.hideControl((Control)this.validateTool);
        this.refreshAll();
    }

    private void hideControl(Control control) {
        if (control == null) {
            return;
        }
        Object layoutData = control.getLayoutData();
        if (layoutData == null) {
            layoutData = new GridData();
            control.setLayoutData(layoutData);
        }
        if (layoutData instanceof GridData) {
            GridData gridData = (GridData)layoutData;
            gridData.exclude = true;
            control.setLayoutData((Object)gridData);
            control.setVisible(false);
        }
    }

    private void showControl(Control control) {
        if (control == null) {
            return;
        }
        Object layoutData = control.getLayoutData();
        if (layoutData == null) {
            layoutData = new GridData();
            control.setLayoutData(layoutData);
        }
        if (layoutData instanceof GridData) {
            GridData gridData = (GridData)layoutData;
            gridData.exclude = false;
            control.setLayoutData((Object)gridData);
            control.setVisible(true);
        }
    }

    private void refreshAll() {
        if (this.butHelp != null && !this.butHelp.getSelection()) {
            this.hideControl((Control)this.descriptionPane);
        } else {
            this.showControl((Control)this.descriptionPane);
        }
        if (this.validateTool == null || this.butValidate == null || !this.validateTool.isVisible() || !this.butValidate.getEnabled()) {
            this.hideControl((Control)this.validateIcon);
        } else {
            this.showControl((Control)this.validateIcon);
        }
        if (this.mainPane != null) {
            this.mainPane.layout(true, true);
        }
    }

    private void initScriptLabel(Composite parent) {
        Label lblScript = new Label(parent, 0);
        lblScript.setText(Messages.getString((String)"JSEditor.Label.Script"));
        FontData fd = lblScript.getFont().getFontData()[0];
        Font labelFont = FontManager.getFont((String)fd.getName(), (int)fd.getHeight(), (int)1);
        lblScript.setFont(labelFont);
        GridData layoutData = new GridData(1);
        lblScript.setLayoutData((Object)layoutData);
    }

    private void initComboBoxes(Composite parent) {
        this.cmbExpList = new Combo(parent, 8);
        GridData layoutData = new GridData(1);
        layoutData.widthHint = 140;
        this.cmbExpList.setLayoutData((Object)layoutData);
        this.cmbExpList.setVisibleItemCount(30);
        this.cmbSubFunctions = new TextCombo(parent, 0);
        layoutData = new GridData(1);
        layoutData.widthHint = 180;
        this.cmbSubFunctions.setLayoutData((Object)layoutData);
    }

    public void handleSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.handleSelectionChanged(selection);
    }

    public void handleSelectionChanged(ISelection selection) {
        if (this.editorUIEnabled) {
            this.saveModel();
        }
        if (selection != null) {
            Object[] sel = ((IStructuredSelection)selection).toArray();
            IElementPropertyDefn targetMethod = null;
            if (sel.length == 1) {
                this.editObject = sel[0];
                if (sel[0] instanceof ScriptElementNode) {
                    this.editObject = ((ScriptElementNode)this.editObject).getParent();
                } else if (sel[0] instanceof ScriptObjectNode) {
                    this.editObject = ((ScriptObjectNode)this.editObject).getParent();
                }
                if (this.editObject instanceof PropertyHandle && (targetMethod = ((PropertyHandle)this.editObject).getPropertyDefn()).getMethodInfo() != null) {
                    this.editObject = ((PropertyHandle)this.editObject).getElementHandle();
                }
            }
            if (this.editObject instanceof DesignElementHandle) {
                this.palettePage.getSupport().setCurrentEditObject(this.editObject);
                this.setComboViewerInput(this.editObject);
                this.cmbItemLastSelected = null;
                this.setEditorText("");
                if (this.cmbExpList.getItemCount() > 0) {
                    this.enableEditor();
                    if (targetMethod != null) {
                        this.selectItemInComboExpList((ISelection)new StructuredSelection((Object)targetMethod));
                    } else {
                        this.selectItemInComboExpList((ISelection)this.selectionMap.get(this.getModel()));
                    }
                } else {
                    this.disableEditor();
                }
                this.checkDirty();
                this.palettePage.getSupport().updateParametersTree();
            } else {
                this.disableEditor();
                this.cmbExpList.removeAll();
                this.cmbSubFunctions.setItems(null);
                this.cmbItemLastSelected = null;
                this.palettePage.getSupport().setCurrentEditObject(null);
            }
            if (sel.length > 0) {
                this.updateAnnotationLabel(sel[0]);
            }
        }
    }

    private void checkDirty() {
    }

    private void selectItemInComboExpList(ISelection selection) {
        IPropertyDefn propDefn;
        ISelection sel = selection;
        if (sel.isEmpty() && this.cmbExpList.getItemCount() > 0 && (propDefn = (IPropertyDefn)this.cmbExprListViewer.getElementAt(0)) != null) {
            sel = new StructuredSelection((Object)propDefn);
        }
        this.cmbExprListViewer.setSelection(this.getNewSelection(sel));
    }

    private ISelection getNewSelection(ISelection selection) {
        if (!(this.getModel() instanceof DesignElementHandle)) {
            return selection;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return selection;
        }
        ArrayList<Object> temp = new ArrayList<Object>();
        List list = ((IStructuredSelection)selection).toList();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof IElementPropertyDefn) {
                String name = ((IElementPropertyDefn)list.get(i)).getName();
                Object obj = this.findData(name);
                if (obj != null) {
                    temp.add(obj);
                } else {
                    temp.add(list.get(i));
                }
            } else {
                temp.add(list.get(i));
            }
            ++i;
        }
        return new StructuredSelection(temp);
    }

    private Object findData(String name) {
        if (this.cmbExprListViewer.getCombo().getItemCount() <= 0) {
            return null;
        }
        int count = this.cmbExprListViewer.getCombo().getItemCount();
        int i = 0;
        while (i < count) {
            Object obj = this.cmbExprListViewer.getElementAt(i);
            if (obj instanceof IElementPropertyDefn && ((IElementPropertyDefn)obj).getName().equals(name)) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    protected void setEditorText(String text) {
        if (this.scriptEditor == null) {
            return;
        }
        try {
            this.setTextListenerEnable(false);
            this.scriptEditor.setScript(text);
            if (this.scriptValidator != null) {
                this.scriptValidator.init();
                this.setValidateIcon(null, null);
            }
        }
        finally {
            this.setTextListenerEnable(true);
        }
    }

    String getEditorText() {
        return this.scriptEditor.getScript();
    }

    private boolean saveEditorContentsDE(DesignElementHandle desHdl, boolean isSaveScript) {
        if (desHdl != null && this.getEditorText() != null) {
            try {
                if (this.cmbItemLastSelected != null) {
                    String name = this.cmbItemLastSelected.getName();
                    desHdl.setStringProperty(name, this.getEditorText());
                    if (!isSaveScript) {
                        this.setEditorText(desHdl.getStringProperty(name));
                    }
                }
                this.selectionMap.put(this.getModel(), this.cmbExprListViewer.getSelection());
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
                return false;
            }
        }
        return true;
    }

    private void saveModel() {
        IUndoManager undoManager;
        if (this.isCodeModified() && this.editObject instanceof DesignElementHandle) {
            this.saveEditorContentsDE((DesignElementHandle)this.editObject, this.isSaveScript);
        }
        this.setIsModified(false);
        ((IFormPage)this.getParentEditor()).getEditor().editorDirtyStateChanged();
        this.firePropertyChange(257);
        SourceViewer viewer = this.getViewer();
        IUndoManager iUndoManager = undoManager = viewer == null ? null : viewer.getUndoManager();
        if (undoManager != null) {
            undoManager.endCompoundChange();
        }
        this.cleanPoint = this.getUndoLevel();
    }

    private int getUndoLevel() {
        SourceViewer viewer = this.getViewer();
        IUndoableOperation[] history = viewer == null ? null : OperationHistoryFactory.getOperationHistory().getUndoHistory((IUndoContext)new ObjectUndoContext((Object)viewer.getDocument()));
        return history == null ? -1 : history.length;
    }

    public void setIsModified(boolean b) {
        this.isModified = b;
    }

    private boolean isCodeModified() {
        return this.isModified;
    }

    protected void markDirty() {
        if (!this.isModified) {
            this.setIsModified(true);
            ((IFormPage)this.getParentEditor()).getEditor().editorDirtyStateChanged();
            this.firePropertyChange(257);
        }
        if (this.cleanPoint > this.getUndoLevel() && !this.undoing) {
            this.cleanPoint = -1;
        }
    }

    private void enableEditor() {
        if (!this.editorUIEnabled) {
            this.getViewer().getTextWidget().setEnabled(true);
            this.cmbExpList.setEnabled(true);
            this.butReset.setEnabled(true);
            this.butValidate.setEnabled(true);
            this.editorUIEnabled = true;
        }
        this.setEditorText("");
    }

    private void disableEditor() {
        if (this.editorUIEnabled) {
            this.getViewer().getTextWidget().setEnabled(false);
            this.cmbExpList.setEnabled(false);
            this.cmbSubFunctions.setEnabled(false);
            this.butReset.setEnabled(false);
            this.butValidate.setEnabled(false);
            this.editorUIEnabled = false;
        }
        this.setEditorText(NO_EXPRESSION);
    }

    public SourceViewer getViewer() {
        return (SourceViewer)this.scriptEditor.getViewer();
    }

    public void performRequest(ReportRequest request) {
        if ("selection".equals(request.getType())) {
            this.handleSelectionChange(request.getSelectionModelList());
        }
        if ("create element".equals(request.getType()) && request.getSelectionModelList().get(0) instanceof ScriptDataSourceHandle) {
            this.handleSelectionChange(request.getSelectionModelList());
        }
        this.refreshAll();
    }

    private void setComboViewerInput(Object model) {
        this.cmbExprListViewer.setInput(model);
        Object oldSelection = this.selectionMap.get(model);
        if (oldSelection == null) {
            this.selectItemInComboExpList((ISelection)new StructuredSelection());
        } else {
            this.selectItemInComboExpList((ISelection)oldSelection);
        }
        this.cmbSubFunctionsViewer.setInput(model);
        int itemCount = this.cmbSubFunctions.getItemCount();
        if (itemCount > 0) {
            this.cmbSubFunctions.select(0);
        }
        this.cmbSubFunctions.setEnabled(itemCount > 0);
    }

    private void setComboViewerInput(String message) {
        this.cmbExprListViewer.setInput((Object)message);
    }

    public void handleSelectionChange(List list) {
        if (this.scriptEditor instanceof AbstractTextEditor) {
            SelectionChangedEvent event = new SelectionChangedEvent(((AbstractTextEditor)this.scriptEditor).getSelectionProvider(), (ISelection)new StructuredSelection(list));
            this.handleSelectionChanged(event);
        }
    }

    protected IScriptEditor getScriptEditor() {
        return this.scriptEditor;
    }

    public void doValidate() {
        block6: {
            Image image = null;
            String message = null;
            if (this.scriptValidator == null) {
                return;
            }
            try {
                try {
                    this.scriptValidator.validate(true, true);
                    image = ReportPlatformUIImages.getImage((String)"Script NoError");
                    message = Messages.getString((String)"JSEditor.Validate.NoError");
                }
                catch (ParseException e) {
                    image = ReportPlatformUIImages.getImage((String)"Script Error");
                    message = e.getLocalizedMessage();
                    this.setValidateIcon(image, message);
                    this.setFocus();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.setValidateIcon(image, message);
                this.setFocus();
                throw throwable;
            }
            this.setValidateIcon(image, message);
            this.setFocus();
        }
    }

    private void setValidateIcon(Image image, String tip) {
        if (this.validateIcon != null) {
            this.validateIcon.setImage(image);
            this.validateIcon.setToolTipText(tip);
        }
    }

    public void doSaveAs() {
        this.scriptEditor.doSaveAs();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.scriptEditor.init(site, input);
    }

    public void setFocus() {
        this.scriptEditor.setFocus();
    }

    public void resetText() {
        if (this.editObject instanceof DesignElementHandle && this.cmbItemLastSelected != null) {
            DesignElementHandle desHdl = (DesignElementHandle)this.editObject;
            String name = this.cmbItemLastSelected.getName();
            this.setEditorText(desHdl.getStringProperty(name));
        }
    }

    private void updateMethodDescription(String methodName) {
        IMethodInfo methodInfo;
        Object obj = this.findData(methodName);
        String description = null;
        if (obj instanceof IElementPropertyDefn && (methodInfo = ((IElementPropertyDefn)obj).getMethodInfo()) != null) {
            description = methodInfo.getToolTip();
        }
        this.setDescriptionText(description);
    }

    private void setDescriptionText(String text) {
        String description;
        Font font = this.descriptionText.getFont();
        FontData[] fontData = font.getFontData();
        if (text != null && text.length() > 0) {
            int i = 0;
            while (i < fontData.length) {
                fontData[i].setStyle(fontData[i].getStyle() & 0xFFFFFFFD);
                ++i;
            }
            description = text;
        } else {
            int i = 0;
            while (i < fontData.length) {
                fontData[i].setStyle(fontData[i].getStyle() | 2);
                ++i;
            }
            description = Messages.getString((String)"JSEditor.Text.NoDescription");
        }
        this.descriptionText.setFont(new Font(font.getDevice(), fontData));
        this.descriptionText.setText(description);
    }
}

