/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.CellDragTracker;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutOwner;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class TableUtil {
    public static void calculateNewSelection(Rectangle bounds, List selection, List children) {
        int i = 0;
        while (i < children.size()) {
            EditPart child = (EditPart)children.get(i);
            if (child.isSelectable() && !TableUtil.isInTable(child)) {
                IFigure figure = ((GraphicalEditPart)child).getFigure();
                Rectangle r = figure.getBounds().getCopy();
                figure.translateToAbsolute((Translatable)r);
                Rectangle rect = bounds.getCopy().intersect(r);
                if (rect.width > 0 && rect.height > 0 && figure.isShowing() && child.getTargetEditPart(CellDragTracker.MARQUEE_REQUEST) == child && TableUtil.isFigureVisible(figure) && !selection.contains(child)) {
                    selection.add(child);
                }
            }
            ++i;
        }
    }

    public static Rectangle getUnionBounds(List list) {
        int size = list.size();
        if (size == 0) {
            return new Rectangle();
        }
        IFigure figure = ((GraphicalEditPart)list.get(0)).getFigure();
        Rectangle retValue = figure.getBounds().getCopy();
        int i = 1;
        while (i < size) {
            GraphicalEditPart cellPart = (GraphicalEditPart)list.get(i);
            retValue.union(cellPart.getFigure().getBounds());
            ++i;
        }
        retValue.shrink(2, 2);
        figure.translateToAbsolute((Translatable)retValue);
        return retValue;
    }

    private static boolean isInTable(EditPart child) {
        if (child instanceof AbstractCellEditPart) {
            return false;
        }
        EditPart part = child.getParent();
        while (part != null) {
            if (part instanceof AbstractCellEditPart) {
                return true;
            }
            part = part.getParent();
        }
        return false;
    }

    private static boolean isFigureVisible(IFigure fig) {
        Rectangle figBounds = fig.getBounds().getCopy();
        IFigure walker = fig.getParent();
        while (!figBounds.isEmpty() && walker != null) {
            walker.translateToParent((Translatable)figBounds);
            figBounds.intersect(walker.getBounds());
            walker = walker.getParent();
        }
        return !figBounds.isEmpty();
    }

    public static int caleY(AbstractTableEditPart part, int row) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        int height = 0;
        int i = 1;
        while (i < row) {
            height += data.findRowData((int)i).height;
            ++i;
        }
        return height;
    }

    public static int caleVisualHeight(TableEditPart part, Object row) {
        RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(row);
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return adapt.getHeight();
        }
        int rowNumber = adapt.getRowNumber();
        if (rowNumber <= data.rowHeights.length) {
            return data.findRowData((int)rowNumber).height;
        }
        return 0;
    }

    public static int caleVisualWidth(TableEditPart part, Object column) {
        return TableUtil.caleVisualWidth(part, -1, column);
    }

    public static int caleVisualWidth(TableEditPart part, int columnIndex, Object column) {
        int columnNumber;
        ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(column);
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return adapt.getWidth();
        }
        int n = columnNumber = columnIndex <= 0 ? adapt.getColumnNumber() : columnIndex;
        if (columnNumber <= data.columnWidths.length) {
            return data.findColumnData((int)columnNumber).width;
        }
        return 0;
    }

    public static int caleX(AbstractTableEditPart part, int column) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        int height = 0;
        int i = 1;
        while (i < column) {
            height += data.findColumnData((int)i).width;
            ++i;
        }
        return height;
    }

    public static List getSelectionCells(ITableLayoutOwner part) {
        List list = part.getViewer().getSelectedEditParts();
        ArrayList temp = new ArrayList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            if (list.get(i) instanceof AbstractCellEditPart) {
                temp.add(list.get(i));
            }
            ++i;
        }
        return temp;
    }

    public static ISelection filletCellInSelectionEditorpart(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return new StructuredSelection(Collections.EMPTY_LIST);
        }
        List list = ((IStructuredSelection)selection).toList();
        list = TableUtil.filterRemoveEditpart(list);
        List retValue = TableUtil.filletCellModel(list);
        return new StructuredSelection(retValue);
    }

    private static List filterRemoveEditpart(List list) {
        ArrayList retValue = new ArrayList(list);
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof ReportElementEditPart && ((ReportElementEditPart)((Object)obj)).isDelete()) {
                retValue.remove(obj);
            }
            ++i;
        }
        return retValue;
    }

    public static List filletCellModel(List list) {
        Object obj;
        ArrayList retValue = new ArrayList(list);
        boolean hasRowOrColumn = false;
        int size = list.size();
        int i = 0;
        while (i < size) {
            obj = list.get(i);
            if (obj instanceof TableEditPart.DummyColumnEditPart || obj instanceof TableEditPart.DummyRowEditPart) {
                hasRowOrColumn = true;
                break;
            }
            ++i;
        }
        if (hasRowOrColumn) {
            i = 0;
            while (i < size) {
                obj = list.get(i);
                if (obj instanceof TableCellEditPart) {
                    retValue.remove(obj);
                }
                ++i;
            }
        }
        return retValue;
    }

    public static int getMinHeight(AbstractTableEditPart part, int rowNumber) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        if (rowNumber <= data.rowHeights.length) {
            return data.findRowData((int)rowNumber).minRowHeight;
        }
        return 0;
    }

    public static int getMinWidth(AbstractTableEditPart part, int columnNumber) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        if (columnNumber <= data.columnWidths.length) {
            return data.findColumnData((int)columnNumber).minColumnWidth;
        }
        return 0;
    }

    public static int getTableContentsHeight(TableEditPart part) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        int height = 0;
        if (data.rowHeights == null) {
            return height;
        }
        int len = data.rowHeights.length;
        int i = 0;
        while (i < len) {
            height += data.rowHeights[i].height;
            ++i;
        }
        return height;
    }

    public static int getTableContentsWidth(TableEditPart part) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        int width = 0;
        if (data.columnWidths == null) {
            return width;
        }
        int len = data.columnWidths.length;
        int i = 0;
        while (i < len) {
            width += data.columnWidths[i].width;
            ++i;
        }
        return width;
    }

    public static boolean isAllCell(List list) {
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (!(obj instanceof CellHandle)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isContinue(int[] intValue) {
        if (intValue == null || intValue.length < 2) {
            return true;
        }
        Arrays.sort(intValue);
        int len = intValue.length;
        return len - 1 == intValue[len - 1] - intValue[0];
    }
}

