/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml.writer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.wpml.AbstractEmitterImpl;
import org.eclipse.birt.report.engine.emitter.wpml.DiagonalLineInfo;
import org.eclipse.birt.report.engine.emitter.wpml.HyperlinkInfo;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractWordXmlWriter {
    protected XMLWriter writer;
    protected final String RIGHT = "right";
    protected final String LEFT = "left";
    protected final String TOP = "top";
    protected final String BOTTOM = "bottom";
    protected int imageId = 75;
    protected int bookmarkId = 0;
    private int lineId = 0;
    protected boolean rtl = false;

    protected abstract void writeTableLayout();

    protected abstract void writeFontSize(IStyle var1);

    protected abstract void writeFont(String var1);

    protected abstract void writeFontStyle(IStyle var1);

    protected abstract void writeFontWeight(IStyle var1);

    protected abstract void openHyperlink(HyperlinkInfo var1);

    protected abstract void closeHyperlink(HyperlinkInfo var1);

    protected abstract void writeVmerge(SpanInfo var1);

    protected abstract void writeIndent(int var1);

    public void startSectionInParagraph() {
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
        this.startSection();
    }

    public void endSectionInParagraph() {
        this.endSection();
        this.writer.closeTag("w:pPr");
        this.writer.closeTag("w:p");
    }

    public void startSection() {
        this.writer.openTag("w:sectPr");
    }

    public void endSection() {
        this.writer.closeTag("w:sectPr");
    }

    protected void drawImageShapeType(int imageId) {
        this.writer.openTag("v:shapetype");
        this.writer.attribute("id", "_x0000_t" + imageId);
        this.writer.attribute("coordsize", "21600,21600");
        this.writer.attribute("o:spt", "75");
        this.writer.attribute("o:preferrelative", "t");
        this.writer.attribute("path", "m@4@5l@4@11@9@11@9@5xe");
        this.writer.attribute("filled", "f");
        this.writer.attribute("stroked", "f");
        this.writer.openTag("v:stroke");
        this.writer.attribute("imagealignshape", "false");
        this.writer.attribute("joinstyle", "miter");
        this.writer.closeTag("v:stroke");
        this.writer.openTag("v:formulas");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "if lineDrawn pixelLineWidth 0");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @0 1 0");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum 0 0 @1");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @2 1 2");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @3 21600 pixelWidth");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @3 21600 pixelHeight");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @0 0 1");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @6 1 2");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @7 21600 pixelWidth");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @8 21600 0 ");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "prod @7 21600 pixelHeight");
        this.writer.closeTag("v:f");
        this.writer.openTag("v:f");
        this.writer.attribute("eqn", "sum @10 21600 0");
        this.writer.closeTag("v:f");
        this.writer.closeTag("v:formulas");
        this.writer.openTag("v:path");
        this.writer.attribute("o:extrusionok", "f");
        this.writer.attribute("gradientshapeok", "t");
        this.writer.attribute("o:connecttype", "rect");
        this.writer.closeTag("v:path");
        this.writer.openTag("o:lock");
        this.writer.attribute("v:ext", "edit");
        this.writer.attribute("aspectratio", "t");
        this.writer.closeTag("o:lock");
        this.writer.closeTag("v:shapetype");
    }

    protected void drawImageBordersStyle(IStyle style) {
        this.drawImageBorderStyle("bottom", style.getBorderBottomStyle(), style.getProperty(23));
        this.drawImageBorderStyle("top", style.getBorderTopStyle(), style.getProperty(6));
        this.drawImageBorderStyle("left", style.getBorderLeftStyle(), style.getProperty(31));
        this.drawImageBorderStyle("right", style.getBorderRightStyle(), style.getProperty(8));
    }

    private void drawImageBorderStyle(String pos, String style, CSSValue width) {
        String direct = "w10:border" + pos;
        this.writer.openTag(direct);
        this.writer.attribute("type", WordUtil.parseImageBorderStyle(style));
        this.writer.attribute("width", WordUtil.parseBorderSize(PropertyUtil.getDimensionValue((CSSValue)width)));
        this.writer.closeTag(direct);
    }

    protected void drawImageBordersColor(IStyle style) {
        this.drawImageBorderColor("bottom", style.getBorderBottomColor());
        this.drawImageBorderColor("top", style.getBorderTopColor());
        this.drawImageBorderColor("left", style.getBorderLeftColor());
        this.drawImageBorderColor("right", style.getBorderRightColor());
    }

    private void drawImageBorderColor(String pos, String color) {
        String borderColor = "#" + WordUtil.parseColor(color);
        String direct = "o:border" + pos + "color";
        this.writer.attribute(direct, borderColor);
    }

    public void writePageProperties(int pageHeight, int pageWidth, int headerHeight, int footerHeight, int topMargin, int bottomMargin, int leftMargin, int rightMargin, String orient) {
        this.writer.openTag("w:pgSz");
        this.writer.attribute("w:w", pageWidth);
        this.writer.attribute("w:h", pageHeight);
        this.writer.attribute("w:orient", orient);
        this.writer.closeTag("w:pgSz");
        this.writer.openTag("w:pgMar");
        this.writer.attribute("w:top", topMargin);
        this.writer.attribute("w:bottom", bottomMargin);
        this.writer.attribute("w:left", leftMargin);
        this.writer.attribute("w:right", rightMargin);
        this.writer.attribute("w:header", topMargin);
        this.writer.attribute("w:footer", bottomMargin);
        this.writer.closeTag("w:pgMar");
    }

    public void startTable(IStyle style, int tablewidth) {
        this.startTable(style, tablewidth, false);
    }

    public void startTable(IStyle style, int tablewidth, boolean inForeign) {
        this.writer.openTag("w:tbl");
        this.writer.openTag("w:tblPr");
        this.writeTableIndent();
        this.writeAttrTag("w:tblStyle", "TableGrid");
        this.writeAttrTag("w:tblOverlap", "Never");
        this.writeBidiTable();
        this.writeTableWidth(tablewidth);
        this.writeAttrTag("w:tblLook", "01E0");
        this.writeTableLayout();
        this.writeTableBorders(style);
        this.writeBackgroundColor(style.getBackgroundColor());
        if ("justify".equalsIgnoreCase(style.getTextAlign())) {
            this.writeAlign("left", style.getDirection());
        } else {
            this.writeAlign(style.getTextAlign(), style.getDirection());
        }
        if (inForeign) {
            this.writer.openTag("w:tblCellMar");
            this.writer.openTag("w:top");
            this.writer.attribute("w:w", 0);
            this.writer.attribute("w:type", "dxa");
            this.writer.closeTag("w:top");
            this.writer.openTag("w:left");
            this.writer.attribute("w:w", 0);
            this.writer.attribute("w:type", "dxa");
            this.writer.closeTag("w:left");
            this.writer.openTag("w:bottom");
            this.writer.attribute("w:w", 0);
            this.writer.attribute("w:type", "dxa");
            this.writer.closeTag("w:bottom");
            this.writer.openTag("w:right");
            this.writer.attribute("w:w", 0);
            this.writer.attribute("w:type", "dxa");
            this.writer.closeTag("w:right");
            this.writer.closeTag("w:tblCellMar");
        }
        this.writer.closeTag("w:tblPr");
    }

    private void writeTableBorders(IStyle style) {
        this.writer.openTag("w:tblBorders");
        this.writeBorders(style, 0, 0, 0, 0);
        this.writer.closeTag("w:tblBorders");
    }

    public void endTable() {
        this.writer.closeTag("w:tbl");
    }

    private void writeTableWidth(int tablewidth) {
        this.writer.openTag("w:tblW");
        this.writer.attribute("w:w", tablewidth);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tblW");
    }

    private void writeTableIndent() {
        this.writer.openTag("w:tblInd");
        this.writer.attribute("w:w", 0);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tblInd");
    }

    protected void writeBorders(IStyle style, int bottomMargin, int topMargin, int leftMargin, int rightMargin) {
        String borderStyle = style.getBorderBottomStyle();
        if (this.hasBorder(borderStyle)) {
            this.writeSingleBorder("bottom", borderStyle, style.getBorderBottomColor(), style.getProperty(23), bottomMargin);
        }
        if (this.hasBorder(borderStyle = style.getBorderTopStyle())) {
            this.writeSingleBorder("top", borderStyle, style.getBorderTopColor(), style.getProperty(6), topMargin);
        }
        if (this.hasBorder(borderStyle = style.getBorderLeftStyle())) {
            this.writeSingleBorder("left", borderStyle, style.getBorderLeftColor(), style.getProperty(31), leftMargin);
        }
        if (this.hasBorder(borderStyle = style.getBorderRightStyle())) {
            this.writeSingleBorder("right", borderStyle, style.getBorderRightColor(), style.getProperty(8), rightMargin);
        }
    }

    private void writeSingleBorder(String type, String borderStyle, String color, CSSValue width, int margin) {
        this.writer.openTag("w:" + type);
        this.writeBorderProperty(borderStyle, color, width, margin);
        this.writer.closeTag("w:" + type);
    }

    private void writeBorderProperty(String style, String color, CSSValue width, int margin) {
        this.writer.attribute("w:val", WordUtil.parseBorderStyle(style));
        this.writer.attribute("w:sz", WordUtil.parseBorderSize(PropertyUtil.getDimensionValue((CSSValue)width)));
        this.writer.attribute("w:space", this.validateBorderSpace(margin));
        this.writer.attribute("w:color", WordUtil.parseColor(color));
    }

    private int validateBorderSpace(int margin) {
        int space = (int)WordUtil.twipToPt(margin);
        if (space > 31) {
            space = 31;
        }
        return space;
    }

    protected void writeAlign(String align, String direction) {
        if (align == null) {
            return;
        }
        String textAlign = align;
        if ("justify".equalsIgnoreCase(align)) {
            textAlign = "both";
        }
        if ("rtl".equalsIgnoreCase(direction)) {
            if ("right".equals(textAlign)) {
                this.writeAttrTag("w:jc", "left");
            } else if ("left".equals(textAlign)) {
                this.writeAttrTag("w:jc", "right");
            } else {
                this.writeAttrTag("w:jc", textAlign);
            }
        } else {
            this.writeAttrTag("w:jc", textAlign);
        }
    }

    protected void writeBackgroundColor(String color) {
        String cssColor = WordUtil.parseColor(color);
        if (cssColor == null) {
            return;
        }
        this.writer.openTag("w:shd");
        this.writer.attribute("w:val", "clear");
        this.writer.attribute("w:color", "auto");
        this.writer.attribute("w:fill", cssColor);
        this.writer.closeTag("w:shd");
    }

    private void writeBidiTable() {
        if (this.rtl) {
            this.writer.openTag("w:bidiVisual");
            this.writer.closeTag("w:bidiVisual");
        }
    }

    protected void writeRunBorders(IStyle style) {
        String borderStyle = style.getBorderTopStyle();
        if (this.hasBorder(borderStyle)) {
            this.writeRunBorder(borderStyle, style.getBorderTopColor(), style.getProperty(6));
            return;
        }
        borderStyle = style.getBorderBottomStyle();
        if (this.hasBorder(borderStyle)) {
            this.writeRunBorder(borderStyle, style.getBorderBottomColor(), style.getProperty(23));
            return;
        }
        borderStyle = style.getBorderLeftStyle();
        if (this.hasBorder(borderStyle)) {
            this.writeRunBorder(borderStyle, style.getBorderLeftColor(), style.getProperty(31));
            return;
        }
        borderStyle = style.getBorderRightStyle();
        if (this.hasBorder(borderStyle)) {
            this.writeRunBorder(borderStyle, style.getBorderRightColor(), style.getProperty(8));
            return;
        }
    }

    private boolean hasBorder(String borderStyle) {
        return borderStyle != null && !"none".equalsIgnoreCase(borderStyle);
    }

    private void writeRunBorder(String borderStyle, String color, CSSValue borderWidth) {
        this.writer.openTag("w:bdr");
        this.writeBorderProperty(borderStyle, color, borderWidth, 0);
        this.writer.closeTag("w:bdr");
    }

    private boolean needNewParagraph(String txt) {
        return "\n".equals(txt) || "\r".equalsIgnoreCase(txt) || "\r\n".equals(txt);
    }

    public void startParagraph(IStyle style, boolean isInline, int paragraphWidth) {
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
        this.writeSpacing(style.getProperty(2), style.getProperty(16));
        this.writeAlign(style.getTextAlign(), style.getDirection());
        int indent = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(21), (int)paragraphWidth) / 1000 * 20;
        if (indent != 0) {
            this.writeIndent(indent);
        }
        if (!isInline) {
            this.writeBackgroundColor(style.getBackgroundColor());
            this.writeParagraphBorders(style);
        }
        this.writer.closeTag("w:pPr");
    }

    private void writeSpacing(CSSValue height) {
        float spacingValue = PropertyUtil.getDimensionValue((CSSValue)height);
        int spacing = WordUtil.milliPt2Twips(spacingValue) / 2;
        this.writeSpacing(spacing, spacing);
    }

    private void writeSpacing(CSSValue top, CSSValue bottom) {
        float topSpacingValue = PropertyUtil.getDimensionValue((CSSValue)top);
        float bottomSpacingValue = PropertyUtil.getDimensionValue((CSSValue)bottom);
        this.writeSpacing(WordUtil.milliPt2Twips(topSpacingValue) / 2, WordUtil.milliPt2Twips(bottomSpacingValue) / 2);
    }

    private void writeSpacing(int beforeValue, int afterValue) {
        this.writer.openTag("w:spacing");
        this.writer.attribute("w:before", beforeValue);
        this.writer.attribute("w:after", afterValue);
        this.writer.closeTag("w:spacing");
    }

    protected void writeAutoText(int type) {
        this.writer.openTag("w:instrText");
        if (type == 1) {
            this.writer.text("PAGE");
        } else if (type == 0) {
            this.writer.text("NUMPAGES");
        }
        this.writer.closeTag("w:instrText");
    }

    private void writeString(String txt, IStyle style) {
        if (txt == null) {
            return;
        }
        if (style != null) {
            String textTransform = style.getTextTransform();
            if ("capitalize".equalsIgnoreCase(textTransform)) {
                txt = WordUtil.capitalize(txt);
            } else if ("uppercase".equalsIgnoreCase(textTransform)) {
                txt = txt.toUpperCase();
            } else if ("lowercase".equalsIgnoreCase(textTransform)) {
                txt = txt.toLowerCase();
            }
        }
        this.writer.openTag("w:t");
        Pattern p = Pattern.compile("\r|\n");
        Matcher m = p.matcher(txt);
        int length = txt.length();
        int index = 0;
        while (m.find(index)) {
            int end;
            int start = m.start();
            if (start > index) {
                this.writer.cdata("<![CDATA[" + txt.substring(index, start) + "]]>");
            }
            if (txt.charAt((end = m.end()) - 1) != '\r' || end == length || txt.charAt(end) != '\n') {
                this.writer.cdata("<w:br/>");
            }
            index = end;
        }
        if (index < length) {
            this.writer.cdata("<![CDATA[" + txt.substring(index) + "]]>");
        }
        this.writer.closeTag("w:t");
    }

    private void writeLetterSpacing(IStyle style) {
        int letterSpacing = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(56));
        this.writeAttrTag("w:spacing", WordUtil.milliPt2Twips(letterSpacing));
    }

    private void writeHyperlinkStyle(HyperlinkInfo info, IStyle style) {
        if (info != null) {
            String color = info.getColor();
            if (color != null) {
                this.writeAttrTag("w:color", color);
            }
            this.writeAttrTag("w:rStyle", "Hyperlink");
        } else {
            this.writeTextUnderline(style);
            this.writeTextColor(style);
        }
    }

    protected void writeTocText(String tocText, int level) {
        this.writer.openTag("w:r");
        this.writer.openTag("w:instrText");
        this.writer.text(" TC \"" + tocText + "\"" + " \\f C \\l \"" + String.valueOf(level) + "\"");
        this.writer.closeTag("w:instrText");
        this.writer.closeTag("w:r");
    }

    protected void writeBidi(boolean rtl) {
        this.writeAttrTag("w:bidi", rtl ? "" : "off");
    }

    protected void writeField(boolean isStart) {
        String fldCharType = isStart ? "begin" : "end";
        this.writer.openTag("w:r");
        this.writer.openTag("w:fldChar");
        this.writer.attribute("w:fldCharType", fldCharType);
        this.writer.closeTag("w:fldChar");
        this.writer.closeTag("w:r");
    }

    protected void writeField(boolean isStart, IStyle style, String fontName) {
        String fldCharType = isStart ? "begin" : "end";
        this.writer.openTag("w:r");
        this.writeFieldRunProperties(style, fontName);
        this.writer.openTag("w:fldChar");
        this.writer.attribute("w:fldCharType", fldCharType);
        this.writer.closeTag("w:fldChar");
        this.writer.closeTag("w:r");
    }

    public void writeColumn(int[] cols) {
        this.writer.openTag("w:tblGrid");
        int i = 0;
        while (i < cols.length) {
            this.writeAttrTag("w:gridCol", cols[i]);
            ++i;
        }
        this.writer.closeTag("w:tblGrid");
    }

    public void startTableRow(double height, boolean isHeader, boolean repeatHeader, boolean fixedLayout) {
        this.writer.openTag("w:tr");
        this.writer.openTag("w:trPr");
        if (height != -1.0) {
            this.writer.openTag("w:trHeight");
            if (fixedLayout) {
                this.writer.attribute("w:h-rule", "exact");
            }
            this.writer.attribute("w:val", height);
            this.writer.closeTag("w:trHeight");
        }
        if (isHeader) {
            String headerOnOff = repeatHeader ? "on" : "off";
            this.writeAttrTag("w:tblHeader", headerOnOff);
        }
        this.writer.closeTag("w:trPr");
    }

    public void endTableRow() {
        this.writer.closeTag("w:tr");
    }

    public void startTableCell(int width, IStyle style, SpanInfo spanInfo) {
        this.writer.openTag("w:tc");
        this.writer.openTag("w:tcPr");
        this.writeCellWidth(width);
        if (spanInfo != null) {
            this.writeGridSpan(spanInfo);
            this.writeVmerge(spanInfo);
        }
        this.writeCellProperties(style);
        this.writer.closeTag("w:tcPr");
        String align = style.getTextAlign();
        if (align == null) {
            return;
        }
        String direction = style.getDirection();
        if ("left".equals(align) && !"rtl".equals(direction)) {
            return;
        }
        this.writer.openTag("w:pPr");
        this.writeAlign(align, direction);
        this.writer.closeTag("w:pPr");
    }

    private void writeCellWidth(int width) {
        this.writer.openTag("w:tcW");
        this.writer.attribute("w:w", width);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tcW");
    }

    private void writeGridSpan(SpanInfo spanInfo) {
        int columnSpan = spanInfo.getColumnSpan();
        if (columnSpan > 1) {
            this.writeAttrTag("w:gridSpan", columnSpan);
        }
    }

    public void writeSpanCell(SpanInfo info) {
        this.writer.openTag("w:tc");
        this.writer.openTag("w:tcPr");
        this.writeCellWidth(info.getCellWidth());
        this.writeGridSpan(info);
        this.writeVmerge(info);
        this.writeCellProperties(info.getStyle());
        this.writer.closeTag("w:tcPr");
        this.insertEmptyParagraph();
        this.writer.closeTag("w:tc");
    }

    public void endTableCell(boolean empty) {
        if (empty) {
            this.insertEmptyParagraph();
        }
        this.writer.closeTag("w:tc");
    }

    public void writeEmptyCell() {
        this.writer.openTag("w:tc");
        this.writer.openTag("w:tcPr");
        this.writer.openTag("w:tcW");
        this.writer.attribute("w:w", 0);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tcW");
        this.writer.closeTag("w:tcPr");
        this.insertEmptyParagraph();
        this.writer.closeTag("w:tc");
    }

    public void insertEmptyParagraph() {
        this.writer.openTag("w:p");
        this.writer.closeTag("w:p");
    }

    public void insertHiddenParagraph() {
        this.writer.openTag("w:p");
        this.writeHiddenProperty();
        this.writer.closeTag("w:p");
    }

    public void writeHiddenProperty() {
        this.writer.openTag("w:rPr");
        this.writeAttrTag("w:vanish", "on");
        this.writer.closeTag("w:rPr");
    }

    public void endParagraph() {
        this.writer.closeTag("w:p");
    }

    public void writeCaption(String txt) {
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
        this.writeAlign("center", null);
        this.writer.closeTag("w:pPr");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writeString(txt, null);
        this.writer.closeTag("w:rPr");
        this.writer.closeTag("w:r");
        this.writer.closeTag("w:p");
    }

    private void writeCellProperties(IStyle style) {
        if (style == null) {
            return;
        }
        this.writeBackgroundColor(style.getBackgroundColor());
        this.writeCellBorders(style);
        this.writeCellPadding(style);
        String verticalAlign = style.getVerticalAlign();
        if (verticalAlign != null) {
            this.writeAttrTag("w:vAlign", WordUtil.parseVerticalAlign(verticalAlign));
        }
        String noWrap = "nowrap".equalsIgnoreCase(style.getWhiteSpace()) ? "on" : "off";
        this.writeAttrTag("w:noWrap", noWrap);
    }

    private void writeCellBorders(IStyle style) {
        this.writer.openTag("w:tcBorders");
        this.writeBorders(style, 0, 0, 0, 0);
        this.writer.closeTag("w:tcBorders");
    }

    private void writeCellPadding(IStyle style) {
        int bottomPadding = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(9));
        int leftPadding = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(7));
        int topPadding = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(10));
        int rightPadding = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(12));
        this.writer.openTag("w:tcMar");
        this.writeCellPadding(bottomPadding, "bottom");
        this.writeCellPadding(leftPadding, "left");
        this.writeCellPadding(topPadding, "top");
        this.writeCellPadding(rightPadding, "right");
        this.writer.closeTag("w:tcMar");
    }

    private void writeCellPadding(int padding, String position) {
        this.writer.openTag("w:" + position);
        this.writer.attribute("w:w", WordUtil.milliPt2Twips(padding));
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:" + position);
    }

    protected void writeAttrTag(String name, String val) {
        this.writer.openTag(name);
        this.writer.attribute("w:val", val);
        this.writer.closeTag(name);
    }

    protected void writeAttrTag(String name, int val) {
        this.writer.openTag(name);
        this.writer.attribute("w:val", val);
        this.writer.closeTag(name);
    }

    protected void writeAttrTag(String name, double val) {
        this.writer.openTag(name);
        this.writer.attribute("w:val", val);
        this.writer.closeTag(name);
    }

    protected int getImageID() {
        return this.imageId++;
    }

    private void writeTextInParagraph(int type, String txt, IStyle style, String fontFamily, HyperlinkInfo info, int paragraphWidth, boolean runIsRtl) {
        this.writer.openTag("w:p");
        this.writer.openTag("w:pPr");
        CSSValue lineHeight = style.getProperty(22);
        if (!"normal".equalsIgnoreCase(lineHeight.getCssText())) {
            this.writeSpacing(lineHeight);
        }
        this.writeAlign(style.getTextAlign(), style.getDirection());
        this.writeBackgroundColor(style.getBackgroundColor());
        this.writeParagraphBorders(style);
        int indent = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(21), (int)(paragraphWidth * 1000)) / 1000 * 20;
        if (indent != 0) {
            this.writeIndent(indent);
        }
        this.writeBidi("rtl".equals(style.getDirection()));
        this.writer.closeTag("w:pPr");
        this.writeTextInRun(type, txt, style, fontFamily, info, false, paragraphWidth, runIsRtl);
    }

    private void writeParagraphBorders(IStyle style) {
        this.writer.openTag("w:pBdr");
        this.writeBorders(style, 0, 0, 0, 0);
        this.writer.closeTag("w:pBdr");
    }

    public void writeText(int type, String txt, IStyle style, String fontFamily, HyperlinkInfo info, AbstractEmitterImpl.TextFlag flag, int paragraphWidth, boolean runIsRtl) {
        if (flag == AbstractEmitterImpl.TextFlag.START) {
            this.writeTextInParagraph(type, txt, style, fontFamily, info, paragraphWidth, runIsRtl);
        } else if (flag == AbstractEmitterImpl.TextFlag.END) {
            this.writer.closeTag("w:p");
        } else if (flag == AbstractEmitterImpl.TextFlag.MIDDLE) {
            this.writeTextInRun(type, txt, style, fontFamily, info, false, paragraphWidth, runIsRtl);
        } else {
            this.writeTextInParagraph(type, txt, style, fontFamily, info, paragraphWidth, runIsRtl);
            this.writer.closeTag("w:p");
        }
    }

    public void writeTextInRun(int type, String txt, IStyle style, String fontFamily, HyperlinkInfo info, boolean isInline, int paragraphWidth, boolean runIsRtl) {
        if ("".equals(txt)) {
            return;
        }
        if (this.needNewParagraph(txt)) {
            this.writer.closeTag("w:p");
            this.startParagraph(style, isInline, paragraphWidth);
            return;
        }
        this.openHyperlink(info);
        boolean isField = WordUtil.isField(type);
        String direction = style.getDirection();
        if (isField) {
            this.writeField(true, style, fontFamily);
        }
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writeRunProperties(style, fontFamily, info);
        if (isInline) {
            this.writeAlign(style.getTextAlign(), direction);
            this.writeBackgroundColor(style.getBackgroundColor());
            this.writePosition(style.getVerticalAlign(), style.getProperty(44));
            this.writeRunBorders(style);
        }
        if (!isField && runIsRtl) {
            this.writer.openTag("w:rtl");
            this.writer.closeTag("w:rtl");
        }
        this.writer.closeTag("w:rPr");
        if (isField) {
            this.writeAutoText(type);
        } else {
            this.writeString(txt, style);
        }
        this.writer.closeTag("w:r");
        if (isField) {
            this.writeField(false, style, fontFamily);
        }
        this.closeHyperlink(info);
    }

    private void writePosition(String verticalAlign, CSSValue fontSize) {
        int size = WordUtil.parseFontSize(PropertyUtil.getDimensionValue((CSSValue)fontSize));
        if ("top".equalsIgnoreCase(verticalAlign)) {
            this.writeAttrTag("w:position", size * 1 / 3);
        } else if ("bottom".equalsIgnoreCase(verticalAlign)) {
            this.writeAttrTag("w:position", -size * 1 / 3);
        }
    }

    protected void writeRunProperties(IStyle style, String fontFamily, HyperlinkInfo info) {
        this.writeHyperlinkStyle(info, style);
        this.writeFont(fontFamily);
        this.writeFontSize(style);
        this.writeLetterSpacing(style);
        this.writeTextLineThrough(style);
        this.writeFontStyle(style);
        this.writeFontWeight(style);
    }

    protected void writeFieldRunProperties(IStyle style, String fontFamily) {
        this.writeFont(fontFamily);
        this.writeFontSize(style);
        this.writeLetterSpacing(style);
        this.writeTextLineThrough(style);
        this.writeFontStyle(style);
        this.writeFontWeight(style);
    }

    private void writeTextColor(IStyle style) {
        String val = WordUtil.parseColor(style.getColor());
        if (val != null) {
            this.writeAttrTag("w:color", val);
        }
    }

    private void writeTextUnderline(IStyle style) {
        String val = WordUtil.removeQuote(style.getTextUnderline());
        if (!"none".equalsIgnoreCase(val)) {
            this.writeAttrTag("w:u", "single");
        }
    }

    private void writeTextLineThrough(IStyle style) {
        String val = WordUtil.removeQuote(style.getTextLineThrough());
        if (!"none".equalsIgnoreCase(val)) {
            this.writeAttrTag("w:strike", "on");
        }
    }

    protected void startHeaderFooterContainer(int headerHeight, int headerWidth) {
        this.startHeaderFooterContainer(headerHeight, headerWidth, false);
    }

    protected void startHeaderFooterContainer(int headerHeight, int headerWidth, boolean writeColumns) {
        this.writer.openTag("w:tbl");
        this.writer.openTag("w:tblPr");
        this.writeTableWidth(headerWidth += 215);
        this.writeAttrTag("w:tblLook", "01E0");
        this.writeTableLayout();
        this.writer.closeTag("w:tblPr");
        if (writeColumns) {
            this.writeColumn(new int[]{headerWidth});
        }
        this.writer.openTag("w:tr");
        this.writer.openTag("w:trPr");
        this.writeAttrTag("w:trHeight", headerHeight);
        this.writer.closeTag("w:trPr");
        this.writer.openTag("w:tc");
        this.writer.openTag("w:tcPr");
        this.writeCellWidth(headerWidth);
        this.writer.closeTag("w:tcPr");
    }

    protected void endHeaderFooterContainer() {
        this.insertEmptyParagraph();
        this.writer.closeTag("w:tc");
        this.writer.closeTag("w:tr");
        this.writer.closeTag("w:tbl");
    }

    public void drawDiagonalLine(DiagonalLineInfo diagonalLineInfo) {
        if (diagonalLineInfo.getDiagonalNumber() <= 0 && diagonalLineInfo.getAntiDiagonalNumber() <= 0) {
            return;
        }
        this.writer.openTag("w:p");
        this.writer.openTag("w:r");
        this.writer.openTag("w:pict");
        double diagonalLineWidth = diagonalLineInfo.getDiagonalLineWidth();
        String diagonalLineStyle = diagonalLineInfo.getDiagonalStyle();
        double antidiagonalLineWidth = diagonalLineInfo.getAntiDiagonalLineWidth();
        String antidiagonalLineStyle = diagonalLineInfo.getAntiDiagonalStyle();
        String lineColor = diagonalLineInfo.getColor();
        for (DiagonalLineInfo.Line line : diagonalLineInfo.getDiagonalLine()) {
            this.drawLine(diagonalLineWidth, diagonalLineStyle, lineColor, line);
        }
        for (DiagonalLineInfo.Line antiLine : diagonalLineInfo.getAntidiagonalLine()) {
            this.drawLine(antidiagonalLineWidth, antidiagonalLineStyle, lineColor, antiLine);
        }
        this.writer.closeTag("w:pict");
        this.writer.closeTag("w:r");
        this.writer.closeTag("w:p");
    }

    private void drawLine(double width, String style, String color, DiagonalLineInfo.Line line) {
        this.writer.openTag("v:line");
        this.writer.attribute("id", "Line" + this.getLineId());
        this.writer.attribute("style", "position:absolute;left:0;text-align:left;z-index:1");
        this.writer.attribute("from", String.valueOf(line.getXCoordinateFrom()) + "pt," + line.getYCoordinateFrom() + "pt");
        this.writer.attribute("to", String.valueOf(line.getXCoordinateTo()) + "pt," + line.getYCoordinateTo() + "pt");
        this.writer.attribute("strokeweight", String.valueOf(width) + "pt");
        this.writer.attribute("strokecolor", "#" + color);
        this.writer.openTag("v:stroke");
        this.writer.attribute("dashstyle", WordUtil.parseLineStyle(style));
        this.writer.closeTag("v:stroke");
        this.writer.closeTag("v:line");
    }

    private int getLineId() {
        return this.lineId++;
    }
}

