/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AddRelativeTimePeriodAction
extends AbstractViewAction {
    public static final String ID = "com.actuate.birt.report.designer.internal.ui.croostab.AddRelativeTimePeriodAction";
    private static final double DEFAULT_COLUMN_WIDTH = 1.0;
    private static final String ICON = "/icons/obj16/relativetime.gif";
    private MeasureViewHandle measureViewHandle;
    private CrosstabReportItemHandle reportHandle;

    public AddRelativeTimePeriodAction(Object selectedObject) {
        super(selectedObject);
        this.setId(ID);
        this.setText(Messages.getString("AddRelativeTimePeriodAction_action_label"));
        Image image = CrosstabUIHelper.getImage("icons/pal/relativetime.gif");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
    }

    public void run() {
        this.reportHandle.getModuleHandle().getCommandStack().startTrans(Messages.getString("AddRelativeTimePeriodAction_trans_label"));
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
        dialog.setInput((ReportItemHandle)this.reportHandle.getModelHandle());
        dialog.setAggreate(true);
        dialog.setTimePeriod(true);
        if (dialog.open() == 0) {
            int index = this.caleIndex();
            try {
                ComputedColumnHandle bindingHandle = dialog.getBindingColumn();
                ComputedMeasureViewHandle computedMeasure = this.reportHandle.insertComputedMeasure(bindingHandle.getName(), index);
                computedMeasure.addHeader();
                ExtendedItemHandle cfr_ignored_0 = (ExtendedItemHandle)this.reportHandle.getModelHandle();
                if (bindingHandle == null) {
                    this.reportHandle.getModuleHandle().getCommandStack().rollbackAll();
                    return;
                }
                DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(bindingHandle.getName());
                CrosstabAdaptUtil.formatDataItem(computedMeasure.getCubeMeasure(), dataHandle);
                dataHandle.setResultSetColumn(bindingHandle.getName());
                AggregationCellHandle cell = computedMeasure.getCell();
                if ("horizontal".equals(this.reportHandle.getMeasureDirection())) {
                    CrosstabCellHandle cellHandle = computedMeasure.getHeader();
                    if (cellHandle == null) {
                        cellHandle = cell;
                    }
                    this.reportHandle.getModelHandle().getModuleHandle().getDefaultUnits();
                }
                cell.addContent((DesignElementHandle)dataHandle);
            }
            catch (SemanticException semanticException) {
                this.reportHandle.getModuleHandle().getCommandStack().rollbackAll();
            }
        }
        this.reportHandle.getModuleHandle().getCommandStack().commit();
    }

    public boolean isEnabled() {
        Object selection = this.getSelection();
        if (selection == null && !(selection instanceof DesignElementHandle)) {
            return false;
        }
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle((DesignElementHandle)selection);
        if (extendedHandle == null) {
            return false;
        }
        if (extendedHandle.getExtensionName().equals("Crosstab")) {
            try {
                this.reportHandle = (CrosstabReportItemHandle)extendedHandle.getReportItem();
            }
            catch (ExtendedElementException extendedElementException) {
                return false;
            }
        } else {
            this.measureViewHandle = CrosstabAdaptUtil.getMeasureViewHandle(extendedHandle);
            if (this.measureViewHandle == null) {
                return false;
            }
            this.reportHandle = this.measureViewHandle.getCrosstab();
        }
        if (DEUtil.isReferenceElement((DesignElementHandle)this.reportHandle.getCrosstabHandle())) {
            return false;
        }
        CubeHandle cube = this.reportHandle.getCube();
        if (cube == null) {
            return false;
        }
        if (cube.getPropertyHandle("dimensions") == null) {
            return false;
        }
        List list = cube.getPropertyHandle("dimensions").getContents();
        int i = 0;
        while (i < list.size()) {
            LevelViewHandle levelViewHandle;
            LevelHandle levelHandle;
            int count;
            DimensionViewHandle viewHandle;
            DimensionHandle dimension = (DimensionHandle)list.get(i);
            if (CrosstabAdaptUtil.isTimeDimension(dimension) && ((viewHandle = this.reportHandle.getDimension(dimension.getName())) == null ? (count = dimension.getDefaultHierarchy().getLevelCount()) != 0 && "year".equals((levelHandle = dimension.getDefaultHierarchy().getLevel(0)).getDateTimeLevelType()) : (count = viewHandle.getLevelCount()) != 0 && "year".equals((levelViewHandle = viewHandle.getLevel(0)).getCubeLevel().getDateTimeLevelType()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int caleIndex() {
        if (this.measureViewHandle != null) {
            return this.reportHandle.getAllMeasures().indexOf(this.measureViewHandle) + 1;
        }
        return this.reportHandle.getAllMeasures().size();
    }
}

