/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.model;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ITimeDimensionCheck;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.re.CrosstabQueryUtil;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.plugin.CrosstabPlugin;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CrosstabAdaptUtil {
    protected static final Logger logger = Logger.getLogger(CrosstabAdaptUtil.class.getName());

    public static int getNumberAfterDimensionViewHandle(DimensionViewHandle handle) {
        CrosstabReportItemHandle reportItem = (CrosstabReportItemHandle)CrosstabUtil.getReportItem((DesignElementHandle)handle.getCrosstabHandle());
        int index = handle.getIndex();
        int type = handle.getAxisType();
        int count = reportItem.getDimensionCount(type);
        int retValue = 0;
        int i = index;
        while (i < count) {
            retValue += reportItem.getDimension(type, index).getLevelCount();
            ++i;
        }
        return retValue;
    }

    public static ComputedColumn createComputedColumn(ReportItemHandle owner, LevelHandle levelHandle) {
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)owner, (String)levelHandle.getName());
        bindingColumn.setDataType(levelHandle.getDataType());
        bindingColumn.setExpression(DEUtil.getExpression((Object)levelHandle));
        return bindingColumn;
    }

    public static ComputedColumn createLevelDisplayComputedColumn(ReportItemHandle owner, LevelHandle levelHandle) {
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)owner, (String)levelHandle.getName());
        if (levelHandle instanceof TabularLevelHandle && ((TabularLevelHandle)levelHandle).getDisplayColumnName() != null && ((TabularLevelHandle)levelHandle).getDisplayColumnName().trim().length() > 0) {
            DesignElementHandle temp = levelHandle.getContainer();
            String dimensionName = "";
            while (temp != null) {
                if (temp instanceof DimensionHandle) {
                    dimensionName = ((DimensionHandle)temp).getName();
                    break;
                }
                temp = temp.getContainer();
            }
            String expr = ExpressionUtil.createJSDimensionExpression((String)dimensionName, (String)levelHandle.getName(), (String)"DisplayName");
            bindingColumn.setDataType("string");
            bindingColumn.setExpression(expr);
        } else {
            bindingColumn.setDataType(levelHandle.getDataType());
            bindingColumn.setExpression(DEUtil.getExpression((Object)levelHandle));
        }
        return bindingColumn;
    }

    public static DataItemHandle createColumnBindingAndDataItem(ReportItemHandle owner, LevelHandle levelHandle) throws SemanticException {
        ComputedColumn bindingColumn = CrosstabAdaptUtil.createLevelDisplayComputedColumn(owner, levelHandle);
        if ("any".equals(bindingColumn.getDataType())) {
            bindingColumn.setDataType("string");
        }
        ComputedColumnHandle bindingHandle = owner.addColumnBinding(bindingColumn, false);
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(levelHandle.getName());
        CrosstabAdaptUtil.formatDataItem(levelHandle, dataHandle);
        dataHandle.setResultSetColumn(bindingHandle.getName());
        if (levelHandle.getDateTimeFormat() != null && levelHandle.getContainer() != null && levelHandle.getContainer().getContainer() != null) {
            Iterator itr = levelHandle.attributesIterator();
            boolean hasDateAttribute = false;
            while (itr != null && itr.hasNext()) {
                LevelAttributeHandle att = (LevelAttributeHandle)itr.next();
                if (!"DateTime".equals(att.getName())) continue;
                hasDateAttribute = true;
                break;
            }
            if (hasDateAttribute) {
                String dimensionName = levelHandle.getContainer().getContainer().getName();
                bindingHandle.setDataType("date-time");
                bindingHandle.setExpression(ExpressionUtil.createJSDimensionExpression((String)dimensionName, (String)levelHandle.getName(), (String)"DateTime"));
                dataHandle.getPrivateStyle().setDateTimeFormatCategory("Custom");
                dataHandle.getPrivateStyle().setDateTimeFormat(levelHandle.getDateTimeFormat());
            }
        }
        return dataHandle;
    }

    public static DataItemHandle createColumnBindingAndDataItem(ReportItemHandle owner, LevelAttributeHandle levelAttrHandle) throws SemanticException {
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)owner, (String)levelAttrHandle.getName());
        ComputedColumnHandle bindingHandle = owner.addColumnBinding(bindingColumn, false);
        LevelHandle levelHandle = (LevelHandle)levelAttrHandle.getElementHandle();
        String dimensionName = levelHandle.getContainer().getContainer().getName();
        bindingHandle.setExpression(ExpressionUtil.createJSDimensionExpression((String)dimensionName, (String)levelHandle.getName(), (String)levelAttrHandle.getName()));
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(levelAttrHandle.getName());
        String type = levelHandle.getDataType();
        String aliment = levelHandle.getAlignment();
        CrosstabAdaptUtil.formatDataItem(type, null, aliment, dataHandle);
        dataHandle.setResultSetColumn(bindingHandle.getName());
        if ("DateTime".equals(levelAttrHandle.getName())) {
            bindingHandle.setDataType("date-time");
            dataHandle.getPrivateStyle().setDateTimeFormatCategory("Custom");
            dataHandle.getPrivateStyle().setDateTimeFormat(levelHandle.getDateTimeFormat());
        } else {
            bindingHandle.setDataType(levelAttrHandle.getDataType());
        }
        return dataHandle;
    }

    public static ComputedColumn createComputedColumn(ReportItemHandle owner, MeasureHandle measureHandle) {
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)owner, (String)measureHandle.getName());
        bindingColumn.setDataType(measureHandle.getDataType());
        bindingColumn.setExpression(DEUtil.getExpression((Object)measureHandle));
        return bindingColumn;
    }

    public static int findInsertPosition(DesignElementHandle parent, DesignElementHandle element) {
        if (element == null) {
            return parent.getContentCount(DEUtil.getDefaultContentName((Object)parent));
        }
        return element.getIndex();
    }

    public static ExtendedItemHandle getExtendedItemHandle(DesignElementHandle handle) {
        while (handle != null) {
            if (handle instanceof ExtendedItemHandle) {
                return (ExtendedItemHandle)handle;
            }
            handle = handle.getContainer();
        }
        return null;
    }

    public static LevelViewHandle getLevelViewHandle(ExtendedItemHandle extendedHandle) {
        AbstractCrosstabItemHandle handle = (AbstractCrosstabItemHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedHandle);
        while (handle != null) {
            if (handle instanceof LevelViewHandle) {
                return (LevelViewHandle)handle;
            }
            handle = handle.getContainer();
        }
        return null;
    }

    public static DimensionViewHandle getDimensionViewHandle(ExtendedItemHandle extendedHandle) {
        AbstractCrosstabItemHandle handle = (AbstractCrosstabItemHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedHandle);
        while (handle != null) {
            if (handle instanceof DimensionViewHandle) {
                return (DimensionViewHandle)handle;
            }
            handle = handle.getContainer();
        }
        return null;
    }

    public static DimensionHandle getDimensionHandle(LevelHandle levelHandle) {
        LevelHandle parent = levelHandle;
        while (parent != null) {
            if (parent instanceof DimensionHandle) {
                return (DimensionHandle)parent;
            }
            parent = parent.getContainer();
        }
        return null;
    }

    public static boolean isTimeDimension(DimensionHandle dim) {
        if (dim == null) {
            return false;
        }
        if (dim.isTimeType()) {
            return true;
        }
        Object[] objs = ElementAdapterManager.getAdapters((Object)dim, ITimeDimensionCheck.class);
        if (objs == null) {
            return false;
        }
        int i = 0;
        while (i < objs.length) {
            ITimeDimensionCheck check = (ITimeDimensionCheck)objs[i];
            if (check.isTimeDimension(dim)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static CubeHandle getCubeHandle(DesignElementHandle levelHandle) {
        DesignElementHandle parent = levelHandle;
        while (parent != null) {
            if (parent instanceof CubeHandle) {
                return (CubeHandle)parent;
            }
            parent = parent.getContainer();
        }
        return null;
    }

    public static MeasureViewHandle getMeasureViewHandle(ExtendedItemHandle extendedHandle) {
        AbstractCrosstabItemHandle handle = (AbstractCrosstabItemHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedHandle);
        while (handle != null) {
            if (handle instanceof MeasureViewHandle) {
                return (MeasureViewHandle)handle;
            }
            handle = handle.getContainer();
        }
        return null;
    }

    public static boolean needRemoveInvaildBindings(CrosstabReportItemHandle handle) {
        String preferenceData = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault()).getString("Auto.Del.Bindings");
        if (preferenceData == null || preferenceData.length() == 0 || preferenceData.equals("prompt")) {
            MessageDialogWithToggle msgDlg = MessageDialogWithToggle.openYesNoQuestion((Shell)UIUtil.getDefaultShell(), (String)Messages.getString("DeleteBindingDialog.Title"), (String)Messages.getString("DeleteBindingDialog.Message"), (String)Messages.getString("DeleteBindingDialog.ToggleMessage"), (boolean)false, null, null);
            if (msgDlg.getToggleState()) {
                String value = "";
                if (msgDlg.getReturnCode() == 2) {
                    value = "always";
                } else if (msgDlg.getReturnCode() == 3) {
                    value = "never";
                }
                PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault()).setValue("Auto.Del.Bindings", value);
            }
            if (msgDlg.getReturnCode() == 2) {
                return true;
            }
            if (msgDlg.getReturnCode() == 3) {
                return false;
            }
        } else if (preferenceData != null && preferenceData.equals("always")) {
            return true;
        }
        return false;
    }

    public static void removeInvalidBindings(CrosstabReportItemHandle handle) {
        DataRequestSession session = null;
        try {
            try {
                ICubeQueryDefinition definition = CrosstabQueryUtil.createCubeQuery((CrosstabReportItemHandle)handle, null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
                session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
                List list = session.getCubeQueryUtil().getInvalidBindings(definition);
                ((ReportItemHandle)handle.getModelHandle()).removedColumnBindings(list);
            }
            catch (BirtException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                if (session != null) {
                    session.shutdown();
                }
            }
        }
        finally {
            if (session != null) {
                session.shutdown();
            }
        }
    }

    public static void addMeasureHandle(CrosstabReportItemHandle reportHandle, MeasureHandle measureHandle, int position) throws SemanticException {
        MeasureViewHandle measureViewHandle = reportHandle.insertMeasure(measureHandle, position);
        measureViewHandle.addHeader();
    }

    public static boolean canCreateMultipleCommand(Object[] objects) {
        if (objects == null || objects.length <= 1) {
            return false;
        }
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof MeasureHandle) && !(objects[i] instanceof MeasureGroupHandle)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void formatDataItem(LevelHandle levelHandle, DataItemHandle dataHandle) {
        if (levelHandle == null || dataHandle == null) {
            return;
        }
        String type = levelHandle.getDataType();
        Object value = levelHandle.getProperty("format");
        String aliment = levelHandle.getAlignment();
        CrosstabAdaptUtil.formatDataItem(type, value, aliment, dataHandle);
    }

    public static void formatDataItem(MeasureHandle measureHandle, DataItemHandle dataHandle) {
        if (measureHandle == null || dataHandle == null) {
            return;
        }
        String type = measureHandle.getDataType();
        Object value = measureHandle.getProperty("format");
        String aliment = measureHandle.getAlignment();
        CrosstabAdaptUtil.formatDataItem(type, value, aliment, dataHandle);
    }

    private static void formatDataItem(String type, Object value, String aliment, DataItemHandle dataHandle) {
        StyleHandle styleHandle = dataHandle.getPrivateStyle();
        if (aliment != null) {
            try {
                styleHandle.setTextAlign(aliment);
            }
            catch (SemanticException semanticException) {}
        }
        if (value == null || !(value instanceof FormatValue)) {
            return;
        }
        FormatValue formartValue = (FormatValue)value;
        try {
            if ("integer".equals(type) || "decimal".equals(type) || "float".equals(type)) {
                if (formartValue.getPattern() != null) {
                    styleHandle.setNumberFormat(formartValue.getPattern());
                }
                if (formartValue.getCategory() != null) {
                    styleHandle.setNumberFormatCategory(formartValue.getCategory());
                }
            } else if ("date-time".equals(type) || "date".equals(type)) {
                if (formartValue.getPattern() != null) {
                    styleHandle.setDateTimeFormat(formartValue.getPattern());
                }
                if (formartValue.getCategory() != null) {
                    styleHandle.setDateTimeFormatCategory(formartValue.getCategory());
                }
            } else if ("string".equals(type)) {
                if (formartValue.getPattern() != null) {
                    styleHandle.setStringFormat(formartValue.getPattern());
                }
                if (formartValue.getCategory() != null) {
                    styleHandle.setStringFormatCategory(formartValue.getCategory());
                }
            }
        }
        catch (SemanticException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

