/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.details.providers;

import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.ui.details.tree.ITreeNode;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class VariableFilter
extends ViewerFilter
implements IFilter {
    Message fMessage;
    XSDElementDeclaration fElementDeclaration;
    XSDTypeDefinition fTypeDefinition;

    public void clear() {
        this.fMessage = null;
        this.fElementDeclaration = null;
        this.fTypeDefinition = null;
    }

    public void setType(Message msg) {
        this.fMessage = msg;
    }

    public void setType(XSDElementDeclaration decl) {
        this.fElementDeclaration = decl;
    }

    public void setType(XSDTypeDefinition typeDef) {
        this.fTypeDefinition = typeDef;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ITreeNode) {
            return this.select(((ITreeNode)element).getModelObject());
        }
        return this.select(element);
    }

    public boolean select(Object toTest) {
        if (toTest == null) {
            return false;
        }
        if (Variable.class.isInstance(toTest)) {
            Variable v = (Variable)toTest;
            if (this.fMessage == null && this.fElementDeclaration == null && this.fTypeDefinition == null) {
                return true;
            }
            if (this.fMessage != null) {
                Part part;
                XSDElementDeclaration decl;
                if (this.fMessage.equals(v.getMessageType())) {
                    return true;
                }
                if (this.fMessage.getEParts().size() == 1 && (decl = (part = (Part)this.fMessage.getEParts().get(0)).getElementDeclaration()) != null && decl.equals(v.getXSDElement())) {
                    return true;
                }
            }
            if (this.fElementDeclaration != null && this.fElementDeclaration.equals(v.getXSDElement())) {
                return true;
            }
            return this.fTypeDefinition != null && this.fTypeDefinition.equals(v.getType());
        }
        return true;
    }
}

