/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dnd;

import java.util.List;
import org.eclipse.bpel.model.resource.BPELReader;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.util.TransferBuffer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class BPELTextTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    BPELReader fReader = new BPELReader();
    Request fTargetRequest = null;
    protected Resource fTargetResource;
    protected BPELEditor fEditor;

    protected void unload() {
        super.unload();
        this.fTargetRequest = null;
    }

    public BPELTextTransferDropTargetListener(EditPartViewer viewer, BPELEditor editor) {
        super(viewer, (Transfer)TextTransfer.getInstance());
        this.fEditor = editor;
    }

    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        String data = (String)TextTransfer.getInstance().nativeToJava(this.getCurrentEvent().currentDataType);
        try {
            List list = this.fReader.fromXML(TransferBuffer.adjustXMLSource(data), "Drag-Session", this.fEditor.getResource());
            if (list.size() > 0) {
                request.setFactory((CreationFactory)new FromSourceFactory((EObject)list.get(0)));
                return request;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.setEnablementDeterminedByCommand(true);
        return request;
    }

    public boolean isEnabled(DropTargetEvent event) {
        boolean result = false;
        try {
            result = super.isEnabled(event);
        }
        catch (Exception exception) {}
        return result;
    }

    protected final CreateRequest getCreateRequest() {
        return (CreateRequest)this.getTargetRequest();
    }

    protected void handleDragOperationChanged() {
        this.getCurrentEvent().detail = this.getCreateRequest().getNewObject() == null ? 0 : 1;
        super.handleDragOperationChanged();
    }

    protected void handleDragOver() {
        if (this.getCreateRequest().getNewObject() == null) {
            this.getCurrentEvent().detail = 0;
            this.getCurrentEvent().detail = 0;
        } else {
            this.getCurrentEvent().detail = 1;
            this.getCurrentEvent().feedback = 24;
        }
        super.handleDragOver();
    }

    protected void handleDrop() {
        CreateRequest cr = this.getCreateRequest();
        super.handleDrop();
        this.selectAddedObject(cr);
    }

    private void selectAddedObject(CreateRequest cr) {
        Object model = cr.getNewObject();
        if (model == null) {
            return;
        }
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().forceFocus();
        Object editpart = viewer.getEditPartRegistry().get(model);
        if (editpart instanceof EditPart) {
            this.getViewer().flush();
            viewer.select((EditPart)editpart);
        }
    }

    protected Request getTargetRequest() {
        if (this.fTargetRequest == null) {
            this.fTargetRequest = this.createTargetRequest();
        }
        return this.fTargetRequest;
    }

    protected void updateTargetRequest() {
        CreateRequest request = this.getCreateRequest();
        request.setLocation(this.getDropLocation());
    }

    class FromSourceFactory
    implements CreationFactory {
        EObject fNewObject = null;

        FromSourceFactory(EObject newObject) {
            this.fNewObject = newObject;
        }

        public Object getNewObject() {
            return this.fNewObject;
        }

        public Object getObjectType() {
            EObject eObj = (EObject)this.getNewObject();
            if (eObj != null) {
                return eObj.eClass();
            }
            return null;
        }
    }
}

