/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.codan.core.CodanCorePlugin;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.internal.core.CheckersRegistry;
import org.eclipse.cdt.codan.internal.core.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class CodanRunner {
    private CodanRunner() {
    }

    public static void runInEditor(Object model, IResource resource, IProgressMonitor monitor) {
        CodanRunner.processResource(resource, model, CheckerLaunchMode.RUN_AS_YOU_TYPE, monitor);
    }

    public static void processResource(IResource resource, CheckerLaunchMode checkerLaunchMode, IProgressMonitor monitor) {
        CodanRunner.processResource(resource, null, checkerLaunchMode, monitor);
    }

    /*
     * Exception decompiling
     */
    private static void processResource(IResource resource, Object model, CheckerLaunchMode checkerLaunchMode, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 22[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void asynchronouslyRemoveMarkersForDisabledProblems(final IResource resource) {
        Job job = new Job(Messages.CodanRunner_Update_markers){

            protected IStatus run(IProgressMonitor monitor) {
                CodanRunner.removeMarkersForDisabledProblems(resource, monitor);
                return Status.OK_STATUS;
            }
        };
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        job.setRule(ruleFactory.markerRule(resource));
        job.setSystem(true);
        job.schedule();
    }

    public static void removeMarkersForDisabledProblems(IResource resource, IProgressMonitor monitor) {
        CheckersRegistry chegistry = CheckersRegistry.getInstance();
        HashSet<String> markerTypes = new HashSet<String>();
        for (IChecker checker : chegistry) {
            Collection<IProblem> problems = chegistry.getRefProblems(checker);
            for (IProblem problem : problems) {
                markerTypes.add(problem.getMarkerType());
            }
        }
        try {
            CodanRunner.removeMarkersForDisabledProblems(chegistry, markerTypes, resource, monitor);
        }
        catch (CoreException e) {
            CodanCorePlugin.log(e);
        }
    }

    private static void removeMarkersForDisabledProblems(CheckersRegistry chegistry, Set<String> markerTypes, IResource resource, IProgressMonitor monitor) throws CoreException {
        IResource[] children = null;
        if (resource instanceof IContainer) {
            children = ((IContainer)resource).members();
        }
        int numChildren = children == null ? 0 : children.length;
        int childWeight = 10;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + numChildren * childWeight));
        IProblemProfile resourceProfile = null;
        for (String markerType : markerTypes) {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers(markerType, false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem problem;
                IMarker marker = iMarkerArray[n2];
                String problemId = (String)marker.getAttribute("id");
                if (resourceProfile == null) {
                    resourceProfile = chegistry.getResourceProfile(resource);
                }
                if ((problem = resourceProfile.findProblem(problemId)) != null && !problem.isEnabled()) {
                    marker.delete();
                }
                ++n2;
            }
        }
        progress.worked(1);
        if (children != null) {
            IResource[] iResourceArray = children;
            int n = children.length;
            int n3 = 0;
            while (n3 < n) {
                IResource child = iResourceArray[n3];
                if (monitor.isCanceled()) {
                    return;
                }
                CodanRunner.removeMarkersForDisabledProblems(chegistry, markerTypes, child, (IProgressMonitor)progress.newChild(childWeight));
                ++n3;
            }
        }
    }
}

