/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParser;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCPerFileBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class GCCPerFileBOPConsoleParser
extends AbstractGCCBOPConsoleParser {
    private static final String[] FILE_EXTENSIONS = new String[]{".c", ".cc", ".cpp", ".cxx", ".C", ".CC", ".CPP", ".CXX"};
    private static final List<String> FILE_EXTENSIONS_LIST = Arrays.asList(FILE_EXTENSIONS);
    private GCCPerFileBOPConsoleParserUtility fUtil;

    @Override
    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        this.fUtil = project != null && workingDirectory != null && markerGenerator != null ? new GCCPerFileBOPConsoleParserUtility(project, workingDirectory, markerGenerator) : null;
        super.startup(project, collector);
    }

    @Override
    protected AbstractGCCBOPConsoleParserUtility getUtility() {
        return this.fUtil;
    }

    @Override
    protected boolean processCommand(String[] tokens) {
        int compilerInvocationIndex = this.findCompilerInvocation(tokens);
        if (compilerInvocationIndex < 0) {
            return false;
        }
        int extensionsIndex = -1;
        boolean found = false;
        String filePath = null;
        int i = compilerInvocationIndex + 1;
        while (i < tokens.length) {
            String fileExtension;
            String token = tokens[i];
            int k = token.lastIndexOf(46);
            if (k != -1 && token.length() - k < 5 && (extensionsIndex = FILE_EXTENSIONS_LIST.indexOf(fileExtension = token.substring(k))) != -1) {
                filePath = token;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            TraceUtil.outputTrace("Error identifying file name :1", tokens, TraceUtil.EOL);
            return false;
        }
        if (filePath == null || filePath.indexOf(FILE_EXTENSIONS[extensionsIndex]) == -1) {
            TraceUtil.outputTrace("Error identifying file name :2", tokens, TraceUtil.EOL);
            return false;
        }
        if (this.fUtil != null) {
            IPath pFilePath = this.fUtil.getAbsolutePath(filePath);
            String shortFileName = pFilePath.removeFileExtension().lastSegment();
            int i2 = compilerInvocationIndex + 1;
            while (i2 < tokens.length) {
                String token = tokens[i2];
                if (token.equals("-include")) {
                    ++i2;
                } else if (token.equals("-imacros")) {
                    ++i2;
                } else if (token.equals(filePath)) {
                    tokens[i2] = "LONG_NAME";
                } else if (token.startsWith(shortFileName)) {
                    tokens[i2] = "SHORT_NAME" + token.substring(shortFileName.length());
                }
                ++i2;
            }
            IFile file = null;
            IPath baseDirectory = this.fUtil.getBaseDirectory();
            if (baseDirectory.isPrefixOf(pFilePath) || baseDirectory.setDevice(null).isPrefixOf(pFilePath)) {
                IPath relPath = pFilePath.removeFirstSegments(baseDirectory.segmentCount());
                file = this.getProject().getFile(relPath);
            } else {
                IProject prj = this.fUtil.getProject();
                file = ResourceLookup.selectFileForLocation((IPath)pFilePath, (IProject)prj);
            }
            if (file != null) {
                CCommandDSC cmd = this.fUtil.getNewCCommandDSC(tokens, compilerInvocationIndex, extensionsIndex > 0);
                ArrayList<CCommandDSC> cmdList = new ArrayList<CCommandDSC>();
                cmdList.add(cmd);
                HashMap<ScannerInfoTypes, ArrayList<CCommandDSC>> sc = new HashMap<ScannerInfoTypes, ArrayList<CCommandDSC>>(1);
                sc.put(ScannerInfoTypes.COMPILER_COMMAND, cmdList);
                this.getCollector().contributeToScannerConfig(file, sc);
            } else {
                TraceUtil.outputError("Build command for file outside project: " + pFilePath.toString(), tokens);
            }
        }
        return true;
    }
}

