/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.jobs;

import java.util.List;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class SCJobsUtil {
    public static boolean getProviderScannerInfo(IProject project, IScannerConfigBuilderInfo2 buildInfo, IProgressMonitor monitor) {
        return SCJobsUtil.getProviderScannerInfo(project, buildInfo.getContext(), buildInfo, monitor);
    }

    public static boolean getProviderScannerInfo(final IProject project, final InfoContext context, final IScannerConfigBuilderInfo2 buildInfo, final IProgressMonitor monitor) {
        final RC rc = new RC(false);
        SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, context, buildInfo.getSelectedProfileId());
        final IScannerInfoCollector collector = profileInstance.getScannerInfoCollector();
        List<String> providerIds = buildInfo.getProviderIdList();
        int i = 0;
        while (i < providerIds.size()) {
            IExternalScannerInfoProvider esiProvider;
            final String providerId = providerIds.get(i);
            if (buildInfo.isProviderOutputParserEnabled(providerId) && (esiProvider = profileInstance.createExternalScannerInfoProvider(providerId)) != null) {
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() {
                        ICProjectDescription projDesc = CoreModel.getDefault().getProjectDescription(project);
                        ICConfigurationDescription configDesc = projDesc.getActiveConfiguration();
                        IEnvironmentVariableManager envVarManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
                        IEnvironmentVariable[] envVars = envVarManager.getVariables(configDesc, true);
                        Properties env = new Properties();
                        int i = 0;
                        while (i < envVars.length) {
                            IEnvironmentVariable envVar = envVars[i];
                            env.put(envVar.getName(), envVar.getValue());
                            ++i;
                        }
                        esiProvider.invokeProvider(monitor, (IResource)project, context, providerId, buildInfo, collector, env);
                        rc.set(true);
                    }

                    public void handleException(Throwable exception) {
                        rc.set(false);
                        MakeCorePlugin.log(exception);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
            ++i;
        }
        return rc.get();
    }

    public static boolean updateScannerConfiguration(IProject project, IScannerConfigBuilderInfo2 buildInfo, IProgressMonitor monitor) {
        return SCJobsUtil.updateScannerConfiguration(project, buildInfo.getContext(), buildInfo, monitor);
    }

    public static boolean updateScannerConfiguration(IProject project, InfoContext context, IScannerConfigBuilderInfo2 buildInfo, final IProgressMonitor monitor) {
        final RC rc = new RC(false);
        SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, context, buildInfo.getSelectedProfileId());
        IScannerInfoCollector collector = profileInstance.getScannerInfoCollector();
        if (collector instanceof IScannerInfoCollector2) {
            final IScannerInfoCollector2 collector2 = (IScannerInfoCollector2)collector;
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    collector2.updateScannerConfiguration(monitor);
                    rc.set(true);
                }

                public void handleException(Throwable exception) {
                    rc.set(false);
                    MakeCorePlugin.log(exception);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        return rc.get();
    }

    public static boolean readBuildOutputFile(IProject project, IScannerConfigBuilderInfo2 buildInfo, IProgressMonitor monitor) {
        return SCJobsUtil.readBuildOutputFile(project, buildInfo.getContext(), buildInfo, monitor);
    }

    public static boolean readBuildOutputFile(final IProject project, final InfoContext context, final IScannerConfigBuilderInfo2 buildInfo, final IProgressMonitor monitor) {
        final RC rc = new RC(false);
        SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, context, buildInfo.getSelectedProfileId());
        final IScannerInfoCollector collector = profileInstance.getScannerInfoCollector();
        final IExternalScannerInfoProvider esiProvider = profileInstance.createBuildOutputProvider();
        if (buildInfo.isBuildOutputFileActionEnabled()) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() {
                    esiProvider.invokeProvider(monitor, (IResource)project, context, null, buildInfo, collector, null);
                    rc.set(true);
                }

                public void handleException(Throwable exception) {
                    rc.set(false);
                    MakeCorePlugin.log(exception);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        return rc.get();
    }

    private static class RC {
        private boolean rc;

        public RC(boolean init) {
            this.rc = init;
        }

        public boolean get() {
            return this.rc;
        }

        public void set(boolean rc) {
            this.rc = rc;
        }

        public String toString() {
            return this.rc ? "true" : "false";
        }
    }
}

