/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.settings.model.MultiItemsHolder;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.MultiResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractToolSettingUI;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControlFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.ICustomBuildOptionEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.StringFieldEditorM;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolSettingsTab;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.osgi.framework.Bundle;

public class BuildOptionSettingsUI
extends AbstractToolSettingUI {
    private Map<String, FieldEditor> fieldsMap = new HashMap<String, FieldEditor>();
    private IOptionCategory category;
    private IHoldsOptions optionHolder;
    private IHoldsOptions[] ohs;
    private int curr = -1;
    private Map<String, CustomFieldEditorDescriptor> customFieldEditorDescriptorIndex;
    private Map<FieldEditor, Composite> fieldEditorsToParentMap = new HashMap<FieldEditor, Composite>();
    private boolean displayFixedTip;
    private static final int selectAction = 6;
    private final Listener tipSetListener = new Listener(){

        public void handleEvent(Event event) {
            Object data = event.widget.getData();
            if (data != null && BuildOptionSettingsUI.this.buildPropPage != null) {
                TipInfo obj = (TipInfo)data;
                ((ToolSettingsTab)BuildOptionSettingsUI.this.buildPropPage).updateTipText(obj.getName(), obj.getTip());
            }
        }
    };

    public BuildOptionSettingsUI(AbstractCBuildPropertyTab page, IResourceInfo info, IHoldsOptions optionHolder, IOptionCategory _category) {
        this(page, info, optionHolder, _category, false);
    }

    public BuildOptionSettingsUI(AbstractCBuildPropertyTab page, IResourceInfo info, IHoldsOptions optionHolder, IOptionCategory cat, boolean displayFixedTip) {
        super(info);
        this.category = cat;
        this.displayFixedTip = displayFixedTip;
        this.optionHolder = optionHolder;
        this.buildPropPage = page;
        if (info instanceof MultiItemsHolder) {
            MultiResourceInfo mri = (MultiResourceInfo)info;
            IResourceInfo[] ris = (IResourceInfo[])mri.getItems();
            String id = this.category.getId();
            ArrayList<Object> lst = new ArrayList<Object>();
            if (optionHolder instanceof ITool) {
                String ext = ((ITool)optionHolder).getDefaultInputExtension();
                int i = 0;
                while (i < ris.length) {
                    ITool[] ts = ris[i].getTools();
                    int j = 0;
                    while (j < ts.length) {
                        IOptionCategory op = ts[j].getOptionCategory(id);
                        if (op != null && ext.equals(ts[j].getDefaultInputExtension())) {
                            lst.add(ts[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else if (optionHolder instanceof IToolChain) {
                int i = 0;
                while (i < ris.length) {
                    IToolChain tc = ris[i].getParent().getToolChain();
                    IOptionCategory op = tc.getOptionCategory(id);
                    if (op != null) {
                        lst.add(tc);
                    }
                    ++i;
                }
            }
            this.ohs = lst.toArray(new IHoldsOptions[lst.size()]);
            int i = 0;
            while (i < this.ohs.length) {
                if (this.ohs[i].equals(optionHolder)) {
                    this.curr = i;
                    break;
                }
                ++i;
            }
        } else {
            this.ohs = null;
            this.curr = 0;
        }
    }

    public Point computeSize() {
        return super.computeSize();
    }

    @Override
    protected void createFieldEditors() {
        boolean pageHasToolTipBox = this.isToolTipBoxNeeded();
        super.createFieldEditors();
        Object[][] options = this.category.getOptions(this.fInfo, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            IOptionApplicability applicabilityCalculator = opt.getApplicabilityCalculator();
            IResourceInfo config = this.fInfo;
            if (applicabilityCalculator == null || applicabilityCalculator.isOptionVisible((IBuildObject)config, holder, opt)) {
                String optId = this.getToolSettingsPrefStore().getOptionId(opt);
                String nameStr = TextProcessor.process((String)opt.getName());
                String tipStr = TextProcessor.process((String)opt.getToolTip());
                String contextId = opt.getContextId();
                if (pageHasToolTipBox && (tipStr == null || tipStr.trim().length() == 0)) {
                    tipStr = Messages.BuildOptionSettingsUI_0;
                }
                try {
                    Composite fieldEditorParent = this.getFieldEditorParent();
                    Object fieldEditor = null;
                    String customFieldEditorId = opt.getFieldEditorId();
                    if (customFieldEditorId != null && (fieldEditor = this.createCustomFieldEditor(customFieldEditorId)) != null) {
                        ICustomBuildOptionEditor customFieldEditor = (ICustomBuildOptionEditor)fieldEditor;
                        if (customFieldEditor.init(opt, opt.getFieldEditorExtraArgument(), optId, fieldEditorParent)) {
                            Control[] toolTipSources = customFieldEditor.getToolTipSources();
                            if (toolTipSources != null) {
                                Control[] controlArray = toolTipSources;
                                int n = toolTipSources.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Control control = controlArray[n2];
                                    if (pageHasToolTipBox) {
                                        control.setData((Object)new TipInfo(nameStr, tipStr));
                                        control.addListener(6, this.tipSetListener);
                                    } else {
                                        control.setToolTipText(tipStr);
                                    }
                                    ++n2;
                                }
                            }
                        } else {
                            fieldEditor = null;
                        }
                    }
                    if (fieldEditor == null) {
                        switch (opt.getValueType()) {
                            case 2: {
                                String filterPath;
                                Object stringField;
                                switch (opt.getBrowseType()) {
                                    case 2: {
                                        stringField = new DirectoryFieldEditor(optId, nameStr, fieldEditorParent);
                                        if (opt.getBrowseFilterPath() == null) break;
                                        try {
                                            filterPath = ManagedBuildManager.getBuildMacroProvider().resolveValue(opt.getBrowseFilterPath(), null, null, 2, (Object)opt.getOptionContextData(holder));
                                            stringField.setFilterPath(new File(filterPath));
                                        }
                                        catch (BuildMacroException bmx) {
                                            ManagedBuilderUIPlugin.log(bmx);
                                        }
                                        break;
                                    }
                                    case 1: {
                                        stringField = new FileFieldEditor(optId, nameStr, fieldEditorParent){

                                            protected boolean checkState() {
                                                this.clearErrorMessage();
                                                return true;
                                            }
                                        };
                                        if (opt.getBrowseFilterPath() != null) {
                                            try {
                                                filterPath = ManagedBuildManager.getBuildMacroProvider().resolveValue(opt.getBrowseFilterPath(), null, null, 2, (Object)opt.getOptionContextData(holder));
                                                ((FileFieldEditor)stringField).setFilterPath(new File(filterPath));
                                            }
                                            catch (BuildMacroException bmx) {
                                                ManagedBuilderUIPlugin.log(bmx);
                                            }
                                        }
                                        ((FileFieldEditor)stringField).setFileExtensions(opt.getBrowseFilterExtensions());
                                        break;
                                    }
                                    case 0: {
                                        final StringFieldEditorM local = new StringFieldEditorM(optId, nameStr, fieldEditorParent);
                                        stringField = local;
                                        local.getTextControl().addModifyListener(new ModifyListener(){

                                            public void modifyText(ModifyEvent e) {
                                                local.valueChanged();
                                            }
                                        });
                                        break;
                                    }
                                    default: {
                                        throw new BuildException(null);
                                    }
                                }
                                Label label = stringField.getLabelControl(fieldEditorParent);
                                Text text = stringField.getTextControl(fieldEditorParent);
                                if (pageHasToolTipBox) {
                                    label.setData((Object)new TipInfo(nameStr, tipStr));
                                    label.addListener(6, this.tipSetListener);
                                    text.setData((Object)new TipInfo(nameStr, tipStr));
                                    text.addListener(6, this.tipSetListener);
                                } else {
                                    label.setToolTipText(tipStr);
                                    text.setToolTipText(tipStr);
                                }
                                if (!contextId.equals("")) {
                                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)text, contextId);
                                }
                                fieldEditor = stringField;
                                break;
                            }
                            case 0: {
                                fieldEditor = new TriStateBooleanFieldEditor(optId, nameStr, tipStr, fieldEditorParent, contextId, this.ohs, this.curr);
                                break;
                            }
                            case 1: {
                                String selId = opt.getSelectedEnum();
                                String sel = opt.getEnumName(selId);
                                String[] enumNames = opt.getApplicableValues();
                                Vector<String> enumValidList = new Vector<String>();
                                int i = 0;
                                while (i < enumNames.length) {
                                    if (opt.getValueHandler().isEnumValueAppropriate((IBuildObject)config, opt.getOptionHolder(), opt, opt.getValueHandlerExtraArgument(), enumNames[i])) {
                                        enumValidList.add(enumNames[i]);
                                    }
                                    ++i;
                                }
                                Object[] enumValidNames = new String[enumValidList.size()];
                                enumValidList.copyInto(enumValidNames);
                                String tooltipHoverStr = this.displayFixedTip ? null : tipStr;
                                fieldEditor = new BuildOptionComboFieldEditor(optId, nameStr, tooltipHoverStr, contextId, (String[])enumValidNames, sel, fieldEditorParent);
                                if (!pageHasToolTipBox) break;
                                Combo combo = ((BuildOptionComboFieldEditor)((Object)fieldEditor)).getComboControl();
                                Label label = fieldEditor.getLabelControl(fieldEditorParent);
                                combo.setData((Object)new TipInfo(nameStr, tipStr));
                                combo.addListener(6, this.tipSetListener);
                                label.setData((Object)new TipInfo(nameStr, tipStr));
                                label.addListener(6, this.tipSetListener);
                                break;
                            }
                            case 12: {
                                fieldEditor = new TreeBrowseFieldEditor(optId, nameStr, fieldEditorParent, nameStr, opt, contextId);
                                ((StringButtonFieldEditor)fieldEditor).setChangeButtonText("...");
                                if (!pageHasToolTipBox) break;
                                Text text = ((StringButtonFieldEditor)fieldEditor).getTextControl(fieldEditorParent);
                                Label label = fieldEditor.getLabelControl(fieldEditorParent);
                                text.setData((Object)new TipInfo(nameStr, tipStr));
                                text.addListener(6, this.tipSetListener);
                                label.setData((Object)new TipInfo(nameStr, tipStr));
                                label.addListener(6, this.tipSetListener);
                                break;
                            }
                            case -11: 
                            case -10: 
                            case -9: 
                            case -8: 
                            case -5: 
                            case -4: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                String filterPath;
                                String tooltipHoverStr = this.displayFixedTip ? null : tipStr;
                                fieldEditor = new FileListControlFieldEditor(optId, nameStr, tooltipHoverStr, contextId, fieldEditorParent, opt.getBrowseType());
                                if (opt.getBrowseFilterPath() != null) {
                                    try {
                                        filterPath = ManagedBuildManager.getBuildMacroProvider().resolveValue(opt.getBrowseFilterPath(), null, null, 2, (Object)opt.getOptionContextData(holder));
                                        ((FileListControlFieldEditor)((Object)fieldEditor)).setFilterPath(filterPath);
                                    }
                                    catch (BuildMacroException bmx) {
                                        ManagedBuilderUIPlugin.log(bmx);
                                    }
                                }
                                ((FileListControlFieldEditor)((Object)fieldEditor)).setFilterExtensions(opt.getBrowseFilterExtensions());
                                if (!pageHasToolTipBox) break;
                                Label label = fieldEditor.getLabelControl(fieldEditorParent);
                                label.setData((Object)new TipInfo(nameStr, tipStr));
                                label.addListener(6, this.tipSetListener);
                                break;
                            }
                            default: {
                                throw new BuildException(null);
                            }
                        }
                    }
                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)fieldEditor, fieldEditorParent);
                    this.addField((FieldEditor)fieldEditor);
                    this.fieldsMap.put(optId, (FieldEditor)fieldEditor);
                    this.fieldEditorsToParentMap.put((FieldEditor)fieldEditor, fieldEditorParent);
                }
                catch (BuildException buildException) {}
            }
            ++index;
        }
    }

    private FieldEditor createCustomFieldEditor(String customFieldEditorId) {
        CustomFieldEditorDescriptor editorDescriptor;
        if (this.customFieldEditorDescriptorIndex == null) {
            this.loadCustomFieldEditorDescriptors();
        }
        if ((editorDescriptor = this.customFieldEditorDescriptorIndex.get(customFieldEditorId)) != null) {
            return editorDescriptor.createEditor();
        }
        return null;
    }

    private void loadCustomFieldEditorDescriptors() {
        if (this.customFieldEditorDescriptorIndex != null) {
            return;
        }
        this.customFieldEditorDescriptorIndex = new HashMap<String, CustomFieldEditorDescriptor>();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(ManagedBuilderUIPlugin.getUniqueIdentifier()) + ".buildDefinitionsUI");
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement providerElement = iConfigurationElementArray[n4];
                String editorId = providerElement.getAttribute("id");
                String editorClassName = providerElement.getAttribute("class");
                String bundleName = providerElement.getContributor().getName();
                this.customFieldEditorDescriptorIndex.put(editorId, new CustomFieldEditorDescriptor(editorClassName, bundleName));
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public boolean isFor(Object holder, Object cat) {
        return holder instanceof IHoldsOptions && cat != null && cat instanceof IOptionCategory && holder == this.optionHolder && cat.equals(this.category);
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        IConfiguration realCfg = null;
        IConfiguration handler = null;
        realCfg = this.buildPropPage.getCfg();
        if (realCfg == null) {
            return false;
        }
        handler = realCfg;
        Object[][] clonedOptions = this.category.getOptions(this.fInfo, this.optionHolder);
        int i = 0;
        while (i < clonedOptions.length) {
            IHoldsOptions clonedHolder = (IHoldsOptions)clonedOptions[i][0];
            if (clonedHolder == null) break;
            IOption clonedOption = (IOption)clonedOptions[i][1];
            IHoldsOptions realHolder = clonedHolder;
            IOption realOption = clonedOption;
            if (realOption != null) {
                try {
                    IOption setOption = null;
                    switch (clonedOption.getValueType()) {
                        case 0: {
                            boolean boolVal = clonedOption.getBooleanValue();
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (boolean)boolVal);
                            break;
                        }
                        case 1: 
                        case 12: {
                            String enumVal = clonedOption.getStringValue();
                            String enumId = clonedOption.getId(enumVal);
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                            break;
                        }
                        case 2: {
                            String strVal = clonedOption.getStringValue();
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)strVal);
                            break;
                        }
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -5: 
                        case -4: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            String[] listVal = ((List)clonedOption.getValue()).toArray(new String[0]);
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String[])listVal);
                            break;
                        }
                    }
                    if (setOption == null) {
                        setOption = realOption;
                    }
                    setOption.getValueHandler().handleValue((IBuildObject)handler, setOption.getOptionHolder(), setOption, setOption.getValueHandlerExtraArgument(), 4);
                }
                catch (BuildException buildException) {
                }
                catch (ClassCastException classCastException) {}
            }
            ++i;
        }
        return ok;
    }

    @Override
    public void updateFields() {
        Object[][] options = this.category.getOptions(this.fInfo, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String prefName = this.getToolSettingsPrefStore().getOptionId(opt);
            if (this.fieldsMap.containsKey(prefName)) {
                IOptionApplicability applicabilityCalculator;
                FieldEditor fieldEditor = this.fieldsMap.get(prefName);
                try {
                    if (opt.getValueType() == 1) {
                        this.updateEnumList(fieldEditor, opt, holder, this.fInfo);
                    }
                }
                catch (BuildException buildException) {}
                if ((applicabilityCalculator = opt.getApplicabilityCalculator()) != null) {
                    Composite parent = this.fieldEditorsToParentMap.get(fieldEditor);
                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
                }
            }
            ++index;
        }
        Collection<FieldEditor> fieldsList = this.fieldsMap.values();
        for (FieldEditor editor : fieldsList) {
            if (editor instanceof TriStateBooleanFieldEditor) {
                ((TriStateBooleanFieldEditor)editor).set3(true);
            }
            editor.load();
        }
    }

    private void setFieldEditorEnablement(IHoldsOptions holder, IOption option, IOptionApplicability optionApplicability, FieldEditor fieldEditor, Composite parent) {
        if (optionApplicability == null) {
            return;
        }
        IResourceInfo config = this.fInfo;
        if (!optionApplicability.isOptionEnabled((IBuildObject)config, holder, option)) {
            fieldEditor.setEnabled(false, parent);
        } else {
            fieldEditor.setEnabled(true, parent);
        }
    }

    private boolean hasStr(String tipStr) {
        return tipStr != null && tipStr.trim().length() > 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object source = event.getSource();
        IOption changedOption = null;
        IHoldsOptions changedHolder = null;
        String id = null;
        if (source instanceof FieldEditor) {
            int n;
            FieldEditor fe = (FieldEditor)source;
            if (fe instanceof TriStateBooleanFieldEditor) {
                ((TriStateBooleanFieldEditor)fe).set3(false);
            }
            id = fe.getPreferenceName();
            Object[] option = this.getToolSettingsPrefStore().getOption(id);
            if (option == null && (n = id.lastIndexOf(46)) > 0) {
                id = id.substring(0, n);
                option = this.getToolSettingsPrefStore().getOption(id);
            }
            if (option != null) {
                changedOption = (IOption)option[1];
                changedHolder = (IHoldsOptions)option[0];
                try {
                    switch (changedOption.getValueType()) {
                        case 2: {
                            if (fe instanceof StringFieldEditor) {
                                String val = ((StringFieldEditor)fe).getStringValue();
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)val);
                            }
                            break;
                        }
                        case 0: {
                            if (fe instanceof BooleanFieldEditor) {
                                boolean val = ((BooleanFieldEditor)fe).getBooleanValue();
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (boolean)val);
                            }
                            break;
                        }
                        case 1: {
                            if (fe instanceof BuildOptionComboFieldEditor) {
                                String name = ((BuildOptionComboFieldEditor)fe).getSelection();
                                String enumId = changedOption.getEnumeratedId(name);
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)(enumId != null && enumId.length() > 0 ? enumId : name));
                            }
                            break;
                        }
                        case 12: {
                            if (fe instanceof TreeBrowseFieldEditor) {
                                String name = ((TreeBrowseFieldEditor)fe).getStringValue();
                                String treeId = changedOption.getId(name);
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)(treeId != null && treeId.length() > 0 ? treeId : name));
                            }
                            break;
                        }
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -5: 
                        case -4: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            if (fe instanceof FileListControlFieldEditor) {
                                String[] val = ((FileListControlFieldEditor)fe).getStringListValue();
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (String[])val);
                            }
                            break;
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        Object[][] options = this.category.getOptions(this.fInfo, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String optId = this.getToolSettingsPrefStore().getOptionId(opt);
            if (this.fieldsMap.containsKey(optId)) {
                IOptionApplicability applicabilityCalculator = opt.getApplicabilityCalculator();
                FieldEditor fieldEditor = this.fieldsMap.get(optId);
                try {
                    if (opt.getValueType() == 1) {
                        this.updateEnumList(fieldEditor, opt, holder, this.fInfo);
                    }
                }
                catch (BuildException buildException) {}
                if (applicabilityCalculator != null) {
                    Composite parent = this.fieldEditorsToParentMap.get(fieldEditor);
                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
                }
            }
            ++index;
        }
        Collection<FieldEditor> xxx = this.fieldsMap.values();
        for (FieldEditor editor : xxx) {
            if (id != null && id.equals(editor.getPreferenceName())) continue;
            editor.load();
        }
    }

    @Override
    public void setValues() {
        this.updateFields();
    }

    protected boolean needToolTipBox(IHoldsOptions optionHolder, IOptionCategory category) {
        if (optionHolder instanceof ITool) {
            Object[][] options = category.getOptions(this.fInfo, optionHolder);
            int index = 0;
            while (index < options.length) {
                IHoldsOptions holder = (IHoldsOptions)options[index][0];
                if (holder == null) break;
                IOption opt = (IOption)options[index][1];
                String tipStr = TextProcessor.process((String)opt.getToolTip());
                IOptionApplicability applicabilityCalculator = opt.getApplicabilityCalculator();
                IResourceInfo config = this.fInfo;
                if ((applicabilityCalculator == null || applicabilityCalculator.isOptionVisible((IBuildObject)config, holder, opt)) && this.hasStr(tipStr)) {
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    protected void updateEnumList(FieldEditor fieldEditor, IOption opt, IHoldsOptions holder, IResourceInfo config) throws BuildException {
        String[] enumNames = opt.getApplicableValues();
        String selectedEnum = opt.getSelectedEnum();
        String selectedEnumName = opt.getEnumName(selectedEnum);
        String defaultEnumId = (String)opt.getDefaultValue();
        String defaultEnumName = opt.getEnumName(defaultEnumId);
        boolean selectNewEnum = true;
        boolean selectDefault = false;
        Vector<String> enumValidList = new Vector<String>();
        int i = 0;
        while (i < enumNames.length) {
            if (opt.getValueHandler().isEnumValueAppropriate((IBuildObject)config, opt.getOptionHolder(), opt, opt.getValueHandlerExtraArgument(), enumNames[i])) {
                if (selectedEnumName.equals(enumNames[i])) {
                    selectNewEnum = false;
                }
                if (defaultEnumName.equals(enumNames[i])) {
                    selectDefault = true;
                }
                enumValidList.add(enumNames[i]);
            }
            ++i;
        }
        Object[] enumValidNames = new String[enumValidList.size()];
        enumValidList.copyInto(enumValidNames);
        if (selectNewEnum) {
            String selection = null;
            if (selectDefault) {
                selection = (String)opt.getDefaultValue();
            } else if (enumValidNames.length > 0) {
                selection = opt.getEnumeratedId((String)enumValidNames[0]);
            }
            ManagedBuildManager.setOption((IResourceInfo)config, (IHoldsOptions)holder, (IOption)opt, (String)selection);
        }
        ((BuildOptionComboFieldEditor)fieldEditor).setOptions((String[])enumValidNames);
        fieldEditor.load();
    }

    private class CustomFieldEditorDescriptor {
        private final String editorClassName;
        private final String bundleName;

        CustomFieldEditorDescriptor(String editorClassName, String bundleName) {
            this.editorClassName = editorClassName;
            this.bundleName = bundleName;
        }

        FieldEditor createEditor() {
            try {
                Object editor;
                Class editorClass;
                Bundle bundle = Platform.getBundle((String)this.bundleName);
                if (bundle != null && (editorClass = bundle.loadClass(this.editorClassName)) != null && (editor = editorClass.newInstance()) instanceof FieldEditor && editor instanceof ICustomBuildOptionEditor) {
                    return (FieldEditor)editor;
                }
            }
            catch (Exception x) {
                ManagedBuilderUIPlugin.log(x);
            }
            return null;
        }
    }

    private class TipInfo {
        private String name;
        private String tip;

        public TipInfo(String name, String tip) {
            this.name = name;
            this.tip = tip;
        }

        protected String getName() {
            return this.name;
        }

        protected String getTip() {
            return this.tip;
        }
    }

    private final class TreeBrowseFieldEditor
    extends StringButtonFieldEditor {
        private final String nameStr;
        private final IOption option;
        private String contextId;

        private TreeBrowseFieldEditor(String name, String labelText, Composite parent, String nameStr, IOption option, String contextId) {
            super(name, labelText, parent);
            this.nameStr = nameStr;
            this.option = option;
            this.contextId = contextId;
        }

        protected String changePressed() {
            try {
                IOption.ITreeRoot treeRoot = this.option.getTreeRoot();
                TreeSelectionDialog dlg = new TreeSelectionDialog(this.getShell(), treeRoot, this.nameStr, this.contextId);
                if (dlg.open() == 0) {
                    IOption.ITreeOption selected = dlg.getSelection();
                    return selected.getName();
                }
            }
            catch (BuildException buildException) {}
            return null;
        }
    }

    public static class TreeSelectionDialog
    extends TitleAreaDialog {
        private final IOption.ITreeRoot treeRoot;
        private IOption.ITreeOption selected;
        private final String name;
        private String contextId;
        private String baseMessage = "";

        public TreeSelectionDialog(Shell parentShell, IOption.ITreeRoot root, String name, String contextId) {
            super(parentShell);
            Image img;
            this.treeRoot = root;
            this.setShellStyle(this.getShellStyle() | 0x10);
            if (root.getIcon() != null && (img = this.createImage(root.getIcon())) != null) {
                this.setTitleImage(img);
            }
            this.name = name;
            this.contextId = contextId;
            if (contextId != null && contextId.length() > 0) {
                this.setHelpAvailable(true);
            }
        }

        protected Control createDialogArea(Composite parent) {
            if (this.contextId != null && this.contextId.length() > 0) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.contextId);
            }
            Composite control = new Composite(parent, 0);
            GridData gd = new GridData(1808);
            GridLayout topLayout = new GridLayout();
            topLayout.numColumns = 1;
            control.setLayout((Layout)topLayout);
            control.setLayoutData((Object)gd);
            PatternFilter filter = new PatternFilter();
            filter.setIncludeLeadingWildcard(true);
            FilteredTree tree = new FilteredTree(control, 2820, filter, true);
            final TreeViewer viewer = tree.getViewer();
            viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public Object[] getElements(Object inputElement) {
                    return this.getChildren(inputElement);
                }

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof IOption.ITreeOption) {
                        IOption.ITreeOption[] children = ((IOption.ITreeOption)parentElement).getChildren();
                        if (children == null) {
                            return null;
                        }
                        ArrayList<IOption.ITreeOption> childrenList = new ArrayList<IOption.ITreeOption>(Arrays.asList(children));
                        ArrayList<IOption.ITreeOption> toRemove = null;
                        IOption.ITreeOption[] iTreeOptionArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IOption.ITreeOption child = iTreeOptionArray[n2];
                            if (child.getName() == null || child.getName().trim().length() == 0) {
                                if (toRemove == null) {
                                    toRemove = new ArrayList<IOption.ITreeOption>();
                                }
                                toRemove.add(child);
                            }
                            ++n2;
                        }
                        if (toRemove != null) {
                            childrenList.removeAll(toRemove);
                        }
                        Collections.sort(childrenList, new Comparator<IOption.ITreeOption>(){

                            @Override
                            public int compare(IOption.ITreeOption arg0, IOption.ITreeOption arg1) {
                                if (arg0.getOrder() == arg1.getOrder()) {
                                    return arg0.getName().compareToIgnoreCase(arg1.getName());
                                }
                                return arg0.getOrder() - arg1.getOrder();
                            }
                        });
                        return childrenList.toArray(new IOption.ITreeOption[0]);
                    }
                    return null;
                }

                public Object getParent(Object element) {
                    if (element instanceof IOption.ITreeOption) {
                        return ((IOption.ITreeOption)element).getParent();
                    }
                    return null;
                }

                public boolean hasChildren(Object element) {
                    Object[] children = this.getChildren(element);
                    return children != null && children.length > 0;
                }
            });
            viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IOption.ITreeOption) {
                        return ((IOption.ITreeOption)element).getName();
                    }
                    return super.getText(element);
                }

                public Image getImage(Object element) {
                    if (element instanceof IOption.ITreeOption) {
                        String icon = ((IOption.ITreeOption)element).getIcon();
                        return TreeSelectionDialog.this.createImage(icon);
                    }
                    return super.getImage(element);
                }
            });
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object selectedObj;
                    ISelection selection = event.getSelection();
                    if (selection instanceof IStructuredSelection && (selectedObj = ((IStructuredSelection)selection).getFirstElement()) instanceof IOption.ITreeOption) {
                        TreeSelectionDialog.this.selected = (IOption.ITreeOption)selectedObj;
                        TreeSelectionDialog.this.updateOKButton(TreeSelectionDialog.this.selected);
                        String description = TreeSelectionDialog.this.selected.getDescription();
                        if (description == null) {
                            IOption.ITreeOption node = TreeSelectionDialog.this.selected;
                            description = "";
                            String sep = ": ";
                            while (node != null && node.getParent() != null) {
                                description = String.valueOf(sep) + node.getName() + description;
                                node = node.getParent();
                            }
                            description = description.substring(sep.length());
                        }
                        TreeSelectionDialog.this.setMessage(String.valueOf(TreeSelectionDialog.this.baseMessage) + description);
                    }
                }
            });
            viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    Object selectedNode;
                    ISelection selection = event.getSelection();
                    if (!selection.isEmpty() && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (selectedNode = ((IStructuredSelection)selection).getFirstElement()) instanceof IOption.ITreeOption) {
                        if (TreeSelectionDialog.this.updateOKButton((IOption.ITreeOption)selectedNode)) {
                            TreeSelectionDialog.this.okPressed();
                        } else {
                            viewer.setExpandedState(selectedNode, !viewer.getExpandedState(selectedNode));
                        }
                    }
                }
            });
            viewer.setInput((Object)this.treeRoot);
            String msg = "Select " + this.name;
            this.getShell().setText(msg);
            this.setTitle(msg);
            if (this.treeRoot.getDescription() != null) {
                this.baseMessage = this.treeRoot.getDescription();
                this.setMessage(this.baseMessage);
                this.baseMessage = String.valueOf(this.baseMessage) + "\nCurrent Selection: ";
            } else {
                this.setMessage(msg);
            }
            return control;
        }

        public IOption.ITreeOption getSelection() {
            return this.selected;
        }

        private Image createImage(String icon) {
            if (icon != null) {
                URL url = null;
                try {
                    url = FileLocator.find((URL)new URL(icon));
                }
                catch (Exception exception) {}
                if (url != null) {
                    ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                    return desc.createImage();
                }
            }
            return null;
        }

        private boolean updateOKButton(IOption.ITreeOption selection) {
            if (this.treeRoot.isSelectLeafsOnly()) {
                boolean enableOK = !selection.isContainer();
                this.getButton(0).setEnabled(enableOK);
                return enableOK;
            }
            return false;
        }
    }

    class TriStateBooleanFieldEditor
    extends BooleanFieldEditor {
        protected Button button;
        protected IHoldsOptions[] holders;
        private boolean enable3;
        protected int current;

        public TriStateBooleanFieldEditor(String name, String labelText, String tooltip, Composite parent, String contextId, IHoldsOptions[] ho, int curr) {
            super(name, labelText, parent);
            this.button = null;
            this.holders = null;
            this.enable3 = true;
            this.current = 0;
            this.holders = ho;
            this.current = curr;
            this.button = this.getChangeControl(parent);
            if (BuildOptionSettingsUI.this.displayFixedTip && BuildOptionSettingsUI.this.isToolTipBoxNeeded()) {
                this.button.setData((Object)new TipInfo(labelText, tooltip));
                this.button.addListener(6, BuildOptionSettingsUI.this.tipSetListener);
            } else {
                this.button.setToolTipText(tooltip);
            }
            if (!contextId.equals("")) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.button, contextId);
            }
        }

        protected void valueChanged(boolean oldValue, boolean newValue) {
            this.button.setGrayed(false);
            super.valueChanged(!newValue, newValue);
        }

        protected void doLoad() {
            String id;
            IOption op;
            if (this.enable3 && this.holders != null && this.button != null && (op = this.holders[this.current].getOptionById(id = this.getPreferenceName())) != null) {
                if (op.getSuperClass() != null) {
                    id = op.getSuperClass().getId();
                }
                int[] vals = new int[2];
                int i = 0;
                while (i < this.holders.length) {
                    op = this.holders[i].getOptionBySuperClassId(id);
                    try {
                        if (op != null) {
                            int n = op.getBooleanValue() ? 1 : 0;
                            vals[n] = vals[n] + 1;
                        }
                    }
                    catch (BuildException buildException) {}
                    ++i;
                }
                boolean value = false;
                boolean gray = false;
                if (vals[1] > 0) {
                    value = true;
                    if (vals[0] > 0) {
                        gray = true;
                    }
                }
                this.button.setGrayed(gray);
                this.button.setSelection(value);
                return;
            }
            super.doLoad();
        }

        void set3(boolean state) {
            this.enable3 = state;
        }
    }
}

