/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.irc.identity;

import java.net.URI;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.presence.im.IChatID;

public class IRCID
extends BaseID
implements IChatID {
    private static final long serialVersionUID = -6582811574473106742L;
    public static final int DEFAULT_IRC_PORT = 6667;
    URI uri;

    protected IRCID(Namespace namespace, URI uri) {
        super(namespace);
        this.uri = uri;
    }

    protected int namespaceCompareTo(BaseID o) {
        return this.getName().compareTo(o.getName());
    }

    protected boolean namespaceEquals(BaseID o) {
        if (!(o instanceof IRCID)) {
            return false;
        }
        IRCID other = (IRCID)o;
        return this.uri.equals(other.uri);
    }

    protected String namespaceGetName() {
        return this.uri.toString();
    }

    protected int namespaceHashCode() {
        return this.uri.hashCode();
    }

    public String getUser() {
        return this.uri.getUserInfo();
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public String getHostname() {
        return this.getHost();
    }

    public int getPort() {
        int p = this.uri.getPort();
        if (p == -1) {
            return 6667;
        }
        return p;
    }

    public String getChannel() {
        String frag = this.uri.getFragment();
        if (frag != null && !frag.equals("")) {
            return "#" + frag;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("IRCID[");
        sb.append(this.uri.toString()).append(']');
        return sb.toString();
    }

    public String getUsername() {
        return this.getUser();
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isInstance((Object)this)) {
            return this;
        }
        return super.getAdapter(clazz);
    }
}

